/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.integrations.CompatiblePlugin;
import me.val_mobile.integrations.RealisticSeasons;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.ColdBreathTask;
import me.val_mobile.tan.HyperthermiaTask;
import me.val_mobile.tan.HypothermiaTask;
import me.val_mobile.tan.SweatTask;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.TemperatureChangeEvent;
import me.val_mobile.tan.TemperatureEnvironmentTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TemperatureCalculateTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, TemperatureCalculateTask> tasks = new HashMap<UUID, TemperatureCalculateTask>();
    private final RealisticSeasons rs;
    private final TanModule module;
    private final TempManager manager;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private double equilibriumTemp;
    private double regulate = 0.0;
    private double change = 0.0;
    private double regulateEnv = 0.0;
    private double changeEnv = 0.0;
    private final double seasonsDefaultTemp;
    private final double seasonsColdMultiplier;
    private final double seasonsHotMultiplier;
    private final double distSqr;
    private double temp;
    private Location currentLoc;
    public static final double MINIMUM_TEMPERATURE = 0.0;
    public static final double MAXIMUM_TEMPERATURE = 25.0;
    public static final double NEUTRAL_TEMPERATURE = 12.5;

    public TemperatureCalculateTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.module = module;
        this.manager = module.getTempManager();
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.temp = player.getTanDataModule().getTemperature();
        this.allowedWorlds = module.getAllowedWorlds();
        this.currentLoc = player.getPlayer().getLocation();
        this.distSqr = this.config.getDouble("Temperature.Environment.CubeLength") * this.config.getDouble("Temperature.Environment.CubeLength");
        this.rs = (RealisticSeasons)CompatiblePlugin.getPlugin("RealisticSeasons");
        this.seasonsDefaultTemp = this.rs.getDefaultTemperature();
        this.seasonsColdMultiplier = this.rs.getColdMultiplier();
        this.seasonsHotMultiplier = this.rs.getHotMultiplier();
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            double oldTemp = this.temp;
            if (this.rs.isIntegrated() && this.rs.hasTemperatureEnabled(player)) {
                int seasonsTemp = this.rs.getTemperature(player);
                this.temp = ((double)seasonsTemp - this.seasonsDefaultTemp) * ((double)seasonsTemp > this.seasonsDefaultTemp ? this.seasonsHotMultiplier : this.seasonsColdMultiplier) + 12.5;
            } else {
                double pz;
                double py;
                Location pLoc;
                double px;
                double tempMaxChange = this.config.getDouble("Temperature.MaxChange");
                this.regulate = 0.0;
                this.change = 0.0;
                World pWorld = player.getWorld();
                double biomeTemp = pWorld.getTemperature((int)(px = (pLoc = player.getLocation()).getX()), (int)(py = pLoc.getY()), (int)(pz = pLoc.getZ()));
                biomeTemp = biomeTemp > this.config.getDouble("Temperature.Environment.BiomeTemperature.HotCutoff") ? (biomeTemp *= this.config.getDouble("Temperature.Environment.BiomeTemperature.HotMultiplier")) : (biomeTemp >= this.config.getDouble("Temperature.Environment.BiomeTemperature.WarmCutoff") ? (biomeTemp *= this.config.getDouble("Temperature.Environment.BiomeTemperature.WarmMultiplier")) : (biomeTemp >= this.config.getDouble("Temperature.Environment.BiomeTemperature.ModerateCutoff") ? (biomeTemp *= this.config.getDouble("Temperature.Environment.BiomeTemperature.ModerateMultiplier")) : (biomeTemp >= this.config.getDouble("Temperature.Environment.BiomeTemperature.CoolCutoff") ? (biomeTemp *= this.config.getDouble("Temperature.Environment.BiomeTemperature.CoolMultiplier")) : (biomeTemp >= this.config.getDouble("Temperature.Environment.BiomeTemperature.ColdCutoff") ? (biomeTemp *= this.config.getDouble("Temperature.Environment.BiomeTemperature.ColdMultiplier")) : (biomeTemp *= this.config.getDouble("Temperature.Environment.BiomeTemperature.FrigidMultiplier"))))));
                double daylightChange = pWorld.getEnvironment() == World.Environment.NORMAL ? Math.sin(2.617993877991494E-4 * (double)pWorld.getTime() - 3500.0) * this.config.getDouble("Temperature.Environment.DaylightCycleMultiplier") : 0.0;
                double worldChange = biomeTemp + daylightChange;
                this.change += worldChange;
                this.change += this.changeEnv;
                this.regulate += this.regulateEnv;
                if (pLoc.getWorld().getName().equals(this.currentLoc.getWorld().getName())) {
                    if (pLoc.distanceSquared(this.currentLoc) > this.distSqr) {
                        this.currentLoc = pLoc;
                        new TemperatureEnvironmentTask(this.module, this.plugin, this.player).start();
                    }
                } else {
                    this.currentLoc = pLoc;
                    new TemperatureEnvironmentTask(this.module, this.plugin, this.player).start();
                }
                if (player.isInWater()) {
                    this.add("Temperature.Environment.SubmergedWater");
                }
                if (Utils.isInLava((Entity)player)) {
                    this.add("Temperature.Environment.SubmergedLava");
                }
                if (Utils.isExposedToSky(player)) {
                    if (pWorld.hasStorm()) {
                        this.add("Temperature.Environment.Storming");
                    }
                } else {
                    this.add("Temperature.Environment.Housed");
                }
                if (player.getFireTicks() > 0) {
                    this.add("Temperature.Environment.Burning");
                }
                for (ItemStack item : player.getInventory().getArmorContents()) {
                    if (!Utils.isItemReal(item)) continue;
                    ItemMeta meta = item.getItemMeta();
                    if (RSVItem.isRSVItem(item)) {
                        String itemName;
                        switch (itemName = RSVItem.getNameFromItem(item)) {
                            case "wool_hood": 
                            case "wool_boots": 
                            case "wool_pants": 
                            case "wool_jacket": 
                            case "jelled_slime_helmet": 
                            case "jelled_slime_chestplate": 
                            case "jelled_slime_leggings": 
                            case "jelled_slime_boots": {
                                this.add("Temperature.Armor." + itemName);
                                break;
                            }
                        }
                        continue;
                    }
                    Material mat = item.getType();
                    if (!Utils.isArmor(mat)) continue;
                    this.add("Temperature.Armor." + String.valueOf(mat));
                }
                double normalTemp = 12.5 + this.change;
                double regulatedTemp = this.temp;
                if (normalTemp != 12.5) {
                    regulatedTemp = normalTemp > 12.5 ? Math.max(normalTemp - this.regulate, 12.5) : Math.min(normalTemp + this.regulate, 12.5);
                }
                this.equilibriumTemp = regulatedTemp;
                if (Math.abs(this.temp - regulatedTemp) < tempMaxChange) {
                    this.temp = regulatedTemp;
                } else {
                    double d = this.temp = regulatedTemp > this.temp ? this.temp + tempMaxChange : this.temp - tempMaxChange;
                }
            }
            if (this.temp != 12.5) {
                if (this.temp < 12.5 && this.hasColdImmunity(player)) {
                    this.temp = 12.5;
                }
                if (this.temp > 12.5 && this.hasHotImmunity(player)) {
                    this.temp = 12.5;
                }
            }
            if (!this.hasColdImmunity(player)) {
                if (!this.rs.disableHypothermiaCompletely() && this.config.getBoolean("Temperature.Hypothermia.Enabled") && this.temp <= this.config.getDouble("Temperature.Hypothermia.Temperature") && !HypothermiaTask.hasTask(this.id)) {
                    new HypothermiaTask(this.module, this.plugin, this.player).start();
                }
                if (!this.rs.disableColdBreath() && !player.hasPermission("realisticsurvival.toughasnails.resistance.cold.breath") && this.config.getBoolean("Temperature.ColdBreath.Enabled") && this.temp <= this.config.getDouble("Temperature.ColdBreath.MaximumTemperature") && !ColdBreathTask.hasTask(this.id)) {
                    new ColdBreathTask(this.module, this.plugin, this.player).start();
                }
            }
            if (!this.hasHotImmunity(player)) {
                if (!this.rs.disableHyperthermiaCompletely() && this.config.getBoolean("Temperature.Hyperthermia.Enabled") && this.temp >= this.config.getDouble("Temperature.Hyperthermia.Temperature") && !HyperthermiaTask.hasTask(this.id)) {
                    new HyperthermiaTask(this.module, this.plugin, this.player).start();
                }
                if (!this.rs.disableSweating() && !player.hasPermission("realisticsurvival.toughasnails.resistance.hot.sweat") && this.config.getBoolean("Temperature.Sweating.Enabled") && this.temp >= this.config.getDouble("Temperature.Sweating.MinimumTemperature") && !SweatTask.hasTask(this.id)) {
                    new SweatTask(this.module, this.plugin, this.player).start();
                }
            }
            if (!Utils.doublesEquals(this.temp, oldTemp)) {
                Bukkit.getServer().getPluginManager().callEvent((Event)new TemperatureChangeEvent(player, oldTemp, this.temp));
            }
            this.manager.setTemperature(player, this.temp);
        } else {
            this.stop();
        }
    }

    public void add(String configPath) {
        double amount = this.config.getDouble(configPath + ".Value");
        if (this.config.contains(configPath + ".Enabled")) {
            if (this.config.getBoolean(configPath + ".Enabled")) {
                if (this.config.getBoolean(configPath + ".IsRegulatory")) {
                    this.regulate += amount;
                } else {
                    this.change += amount;
                }
            }
        } else if (this.config.getBoolean(configPath + ".IsRegulatory")) {
            this.regulate += amount;
        } else {
            this.change += amount;
        }
    }

    private boolean hasHotImmunity(@Nonnull Player player) {
        return player.hasPermission("realisticsurvival.toughasnails.resistance.hot.*");
    }

    private boolean hasColdImmunity(@Nonnull Player player) {
        return player.hasPermission("realisticsurvival.toughasnails.resistance.cold.*");
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName());
    }

    @Override
    public void start() {
        new TemperatureEnvironmentTask(this.module, this.plugin, this.player).start();
        int tickPeriod = this.config.getInt("Temperature.CalculateTickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        this.manager.setTemperature(this.player.getPlayer(), this.temp);
        tasks.remove(this.id);
        this.cancel();
    }

    private void saveData() {
        RSVPlayer.getPlayers().get(this.id).getTanDataModule().saveData();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, TemperatureCalculateTask> getTasks() {
        return tasks;
    }

    public double getEquilibriumTemp() {
        return this.equilibriumTemp;
    }

    public double getTemp() {
        return this.temp;
    }

    public double getChangeEnv() {
        return this.changeEnv;
    }

    public double getRegulateEnv() {
        return this.regulateEnv;
    }

    public void setTemp(double temp) {
        this.temp = temp;
    }

    public void setChangeEnv(double changeEnv) {
        this.changeEnv = changeEnv;
    }

    public void setRegulateEnv(double regulateEnv) {
        this.regulateEnv = regulateEnv;
    }
}

