/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TemperatureCalculateTask;
import me.val_mobile.utils.RSVTask;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TemperatureEnvironmentTask
extends BukkitRunnable
implements RSVTask {
    private final TemperatureCalculateTask calcTask;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final Collection<String> allowedWorlds;
    private final ConfigurationSection section;
    private double regulate = 0.0;
    private double change = 0.0;

    public TemperatureEnvironmentTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.allowedWorlds = module.getAllowedWorlds();
        this.calcTask = TemperatureCalculateTask.getTasks().get(player.getPlayer().getUniqueId());
        this.section = this.config.getConfigurationSection("Temperature.Environment.Blocks");
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            this.regulate = 0.0;
            this.change = 0.0;
            Location pLoc = player.getLocation();
            double px = pLoc.getX();
            double py = pLoc.getY();
            double pz = pLoc.getZ();
            int cubeLength = this.config.getInt("Temperature.Environment.CubeLength");
            for (int x = -(cubeLength - 1); x < cubeLength; ++x) {
                for (int y = -(cubeLength - 1); y < cubeLength; ++y) {
                    for (int z = -(cubeLength - 1); z < cubeLength; ++z) {
                        Location loc = new Location(player.getWorld(), px + (double)x, py + (double)y, pz + (double)z);
                        Block block = loc.getBlock();
                        if (block.isEmpty() || !this.willAffectTemperature(block)) continue;
                        this.add(block);
                    }
                }
            }
            this.calcTask.setChangeEnv(this.change);
            this.calcTask.setRegulateEnv(this.regulate);
        } else {
            this.stop();
        }
    }

    public static boolean willAffectTemperature(@Nullable BlockData data, @Nonnull ConfigurationSection section) {
        if (data == null) {
            return false;
        }
        String material = data.getMaterial().toString();
        if (!section.contains(material)) {
            return false;
        }
        if (data instanceof Lightable) {
            Lightable lightable = (Lightable)data;
            if (section.contains(material + ".Lit")) {
                return section.getBoolean(material + ".Lit") == lightable.isLit();
            }
        } else if (data instanceof Levelled) {
            Levelled levelled = (Levelled)data;
            if (section.contains(material + ".MaximumLevel")) {
                return levelled.getLevel() <= section.getInt(material + ".MaximumLevel");
            }
            if (section.contains(material + ".MinimumLevel")) {
                return levelled.getLevel() >= section.getInt(material + ".MinimumLevel");
            }
        }
        return true;
    }

    public static boolean willAffectTemperature(@Nonnull Block block, @Nonnull ConfigurationSection section) {
        return TemperatureEnvironmentTask.willAffectTemperature(block.getBlockData(), section);
    }

    public static boolean isRegulatory(@Nullable BlockData blockData, @Nonnull ConfigurationSection section) {
        if (blockData == null) {
            return false;
        }
        return section.getBoolean(String.valueOf(blockData.getMaterial()) + ".IsRegulatory");
    }

    public static boolean isRegulatory(@Nonnull Block block, @Nonnull ConfigurationSection section) {
        return TemperatureEnvironmentTask.isRegulatory(block.getBlockData(), section);
    }

    public static double getValue(@Nullable BlockData blockData, @Nonnull ConfigurationSection section) {
        if (blockData == null) {
            return 0.0;
        }
        if (!section.contains(String.valueOf(blockData.getMaterial()) + ".Value")) {
            return 0.0;
        }
        double val = section.getDouble(String.valueOf(blockData.getMaterial()) + ".Value");
        String type = blockData.getMaterial().toString();
        if (blockData instanceof Lightable) {
            Lightable lightable = (Lightable)blockData;
            if (section.contains(type + ".Lit") && section.getBoolean(type + ".Lit")) {
                return lightable.isLit() ? val : 0.0;
            }
        }
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            if (section.contains(type + ".MinimumLevel")) {
                int minLevel = section.getInt(type + ".MinimumLevel");
                return levelled.getLevel() >= minLevel ? val : 0.0;
            }
            if (section.contains(type + ".MaximumLevel")) {
                int maxLevel = section.getInt(type + ".MaximumLevel");
                return levelled.getLevel() <= maxLevel ? val : 0.0;
            }
        }
        return val;
    }

    public static double getValue(@Nonnull Block block, @Nonnull ConfigurationSection section) {
        return TemperatureEnvironmentTask.getValue(block.getBlockData(), section);
    }

    public boolean willAffectTemperature(@Nonnull Block block) {
        return TemperatureEnvironmentTask.willAffectTemperature(block.getBlockData(), this.section);
    }

    public void add(@Nonnull BlockData data) {
        String type = data.getMaterial().toString();
        double val = TemperatureEnvironmentTask.getValue(data, this.section);
        if (this.section.getBoolean(type + ".IsRegulatory")) {
            this.regulate += val;
        } else {
            this.change += val;
        }
    }

    public void add(@Nonnull Block data) {
        String type = data.getType().toString();
        double val = TemperatureEnvironmentTask.getValue(data, this.section);
        if (this.section.getBoolean(type + ".IsRegulatory")) {
            this.regulate += val;
        } else {
            this.change += val;
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.calcTask != null && this.allowedWorlds.contains(player.getWorld().getName());
    }

    @Override
    public void start() {
        this.runTaskAsynchronously((Plugin)this.plugin);
    }

    @Override
    public void stop() {
        this.cancel();
    }
}

