/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.DehydrationTask;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.ThirstChangeEvent;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ThirstCalculateTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, ThirstCalculateTask> tasks = new HashMap<UUID, ThirstCalculateTask>();
    private final TanModule module;
    private final TempManager tempManager;
    private final ThirstManager thirstManager;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private int thirstLvl;
    private int saturationLvl;
    private int tickTimer;
    private double exhaustionLvl;
    private final int tickPeriod;
    private boolean parasitesActive = false;
    private final double peMultiplier;
    private final double sprintingIncrease;
    private final double swimmingIncrease;
    private final double passiveIncrease;
    private final double hyperthermiaMinTemp;
    private final double hyperthermiaIncrease;
    public static final int MAXIMUM_THIRST = 20;
    public static final int MINIMUM_THIRST = 0;

    public ThirstCalculateTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.module = module;
        this.tempManager = module.getTempManager();
        this.thirstManager = module.getThirstManager();
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.thirstLvl = player.getTanDataModule().getThirst();
        this.saturationLvl = player.getTanDataModule().getThirstSaturation();
        this.exhaustionLvl = player.getTanDataModule().getThirstExhaustion();
        this.tickTimer = player.getTanDataModule().getThirstTickTimer();
        this.allowedWorlds = module.getAllowedWorlds();
        this.peMultiplier = this.config.getDouble("Thirst.Parasites.MultiplyExhaustionRates.Value");
        this.sprintingIncrease = this.config.getDouble("Thirst.ExhaustionLevelIncrease.Sprinting");
        this.swimmingIncrease = this.config.getDouble("Thirst.ExhaustionLevelIncrease.Swimming");
        this.passiveIncrease = this.config.getDouble("Thirst.ExhaustionLevelIncrease.PassiveDecay");
        this.hyperthermiaMinTemp = this.config.getDouble("Thirst.ExhaustionLevelIncrease.Hyperthermia.MinTemperature");
        this.hyperthermiaIncrease = this.config.getDouble("Thirst.ExhaustionLevelIncrease.Hyperthermia.MaxValue");
        this.tickPeriod = this.config.getInt("Thirst.CalculateTickPeriod");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            double pTemp;
            this.tickTimer += this.tickPeriod;
            double currentLvl = this.thirstLvl;
            double addition = 0.0;
            if (player.isSprinting()) {
                addition += this.sprintingIncrease;
            }
            if (player.isSwimming()) {
                addition += this.swimmingIncrease;
            }
            if (this.tempManager.isTempEnabled(player) && (pTemp = this.tempManager.getTemperature(player)) >= this.hyperthermiaMinTemp) {
                addition += this.hyperthermiaIncrease * pTemp / 25.0;
            }
            addition += this.passiveIncrease;
            this.exhaustionLvl = Utils.clamp(this.exhaustionLvl + (addition *= (double)this.tickPeriod * (this.parasitesActive ? this.peMultiplier : 1.0)), 0.0, 4.0);
            if (Utils.doublesEquals(this.exhaustionLvl, 4.0) && this.tickTimer >= 80) {
                this.exhaustionLvl = 0.0;
                this.tickTimer = 0;
                if (this.saturationLvl > 0) {
                    this.saturationLvl = Utils.clamp(this.saturationLvl - 1, 0, this.thirstLvl);
                } else {
                    --this.thirstLvl;
                    this.saturationLvl = Utils.clamp(this.saturationLvl, 0, this.thirstLvl);
                }
            }
            if (player.getWorld().getDifficulty() == Difficulty.PEACEFUL) {
                this.thirstLvl = Utils.clamp(this.thirstLvl + 1, 0, 20);
            }
            if (player.hasPermission("realisticsurvival.toughasnails.resistance.thirst.*")) {
                this.thirstLvl = Math.max(20, this.thirstLvl);
            } else if (this.config.getBoolean("Thirst.Dehydration.Enabled") && (double)this.thirstLvl <= this.config.getDouble("Thirst.Dehydration.Thirst") && !DehydrationTask.hasTask(this.id)) {
                new DehydrationTask(this.module, this.plugin, this.player).start();
            }
            if (!Utils.doublesEquals(currentLvl, this.thirstLvl)) {
                Bukkit.getServer().getPluginManager().callEvent((Event)new ThirstChangeEvent(player, currentLvl, this.thirstLvl));
            }
            this.thirstManager.setThirst(player, this.thirstLvl);
            this.thirstManager.setExhaustion(player, this.exhaustionLvl);
            this.thirstManager.setSaturation(player, this.saturationLvl);
            this.thirstManager.setTickTimer(player, this.tickTimer);
        } else {
            this.stop();
        }
    }

    public void setParasitesActive(boolean parasitesActive) {
        this.parasitesActive = parasitesActive;
    }

    public boolean isParasitesActive() {
        return this.parasitesActive;
    }

    public int getSaturationLvl() {
        return this.saturationLvl;
    }

    public double getExhaustionLvl() {
        return this.exhaustionLvl;
    }

    public int getTickTimer() {
        return this.tickTimer;
    }

    public int getThirstLvl() {
        return this.thirstLvl;
    }

    public void setExhaustionLvl(double exhaustionLvl) {
        this.exhaustionLvl = exhaustionLvl;
    }

    public void setThirstLvl(int thirstLvl) {
        this.thirstLvl = thirstLvl;
    }

    public void setSaturationLvl(int saturationLvl) {
        this.saturationLvl = saturationLvl;
    }

    public void setTickTimer(int tickTimer) {
        this.tickTimer = tickTimer;
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName());
    }

    @Override
    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, this.tickPeriod);
    }

    @Override
    public void stop() {
        this.thirstManager.setThirst(this.player.getPlayer(), this.thirstLvl);
        this.thirstManager.setExhaustion(this.player.getPlayer(), this.exhaustionLvl);
        this.thirstManager.setSaturation(this.player.getPlayer(), this.saturationLvl);
        this.thirstManager.setTickTimer(this.player.getPlayer(), this.tickTimer);
        tasks.remove(this.id);
        this.cancel();
    }

    private void saveData() {
        RSVPlayer.getPlayers().get(this.id).getTanDataModule().saveData();
    }

    public static Map<UUID, ThirstCalculateTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

