/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LorePresets {
    private static final FileConfiguration CONFIG = RSVPlugin.getLorePresetConfig();

    public static void addRapierLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double percentAbsorbed = section.getDouble("Protection.PercentAbsorbed");
        int durabilityTaken = section.getInt("Protection.DamageDurability");
        double damageBonus = section.getDouble("UnarmoredDamageMultiplier") - 1.0;
        List lines = CONFIG.getStringList("Rapier");
        Map<String, Object> placeholders = Map.of("DAMAGE_ABSORBED", dfpercent.format(percentAbsorbed), "DURABILITY_TAKEN", df.format(durabilityTaken), "DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addKatanaLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("ChestDamageMultiplier") - 1.0;
        List lines = CONFIG.getStringList("Katana");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addGreatswordLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("SweepingDamageMultiplier");
        List lines = CONFIG.getStringList("Greatsword");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addLongswordLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("SweepingDamageMultiplier");
        List lines = CONFIG.getStringList("Longsword");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addSpearLore(List<String> lore) {
        List lines = CONFIG.getStringList("Spear");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addSaberLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double percentAbsorbed = section.getDouble("Protection.PercentAbsorbed");
        int durabilityTaken = section.getInt("Protection.DamageDurability");
        double damageBonus = section.getDouble("ChestDamageMultiplier") - 1.0;
        List lines = CONFIG.getStringList("Saber");
        Map<String, Object> placeholders = Map.of("DAMAGE_ABSORBED", dfpercent.format(percentAbsorbed), "DURABILITY_TAKEN", df.format(durabilityTaken), "DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addBoomerangLore(List<String> lore) {
        List lines = CONFIG.getStringList("Boomerang");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addDaggerLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("BackstabDamageMultiplier") - 1.0;
        List lines = CONFIG.getStringList("Dagger");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addGlaiveLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("SweepingDamageMultiplier");
        List lines = CONFIG.getStringList("Glaive");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addHalberdLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("ShieldBreachChance") - 1.0;
        List lines = CONFIG.getStringList("Halberd");
        Map<String, Object> placeholders = Map.of("SHIELD_BREACH", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addHammerLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        int amplifier = section.getInt("Nausea.Amplifier") + 1;
        int duration = section.getInt("Nausea.Duration");
        List lines = CONFIG.getStringList("Hammer");
        Map<String, Object> placeholders = Map.of("NAUSEA_AMPLIFIER", Utils.toRomanNumeral(amplifier), "NAUSEA_DURATION", df.format((double)duration / 20.0));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addJavelinLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("ThrownAttributes.AttackDamage") / section.getDouble("Attributes.AttackDamage") - 1.0;
        List lines = CONFIG.getStringList("Javelin");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addLanceLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("RidingDamageBonus") - 1.0;
        List lines = CONFIG.getStringList("Lance");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addMaceLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("UndeadDamageMultiplier") - 1.0;
        List lines = CONFIG.getStringList("Mace");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addPikeLore(List<String> lore) {
        List lines = CONFIG.getStringList("Pike");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addQuarterstaffLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("SweepingDamageMultiplier");
        List lines = CONFIG.getStringList("Quarterstaff");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addTomahawkLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("ThrownAttributes.AttackDamage") / section.getDouble("Attributes.AttackDamage") - 1.0;
        List lines = CONFIG.getStringList("Tomahawk");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addThrowingKnifeLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double damageBonus = section.getDouble("ThrownAttributes.AttackDamage") / section.getDouble("Attributes.AttackDamage") - 1.0;
        List lines = CONFIG.getStringList("ThrowingKnife");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", dfpercent.format(damageBonus));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addWarhammerLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat dfpercent = new DecimalFormat("0%", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        double percentAbsorbed = section.getDouble("ArmorPiercing");
        List lines = CONFIG.getStringList("Warhammer");
        Map<String, Object> placeholders = Map.of("ARMOR_PIERCING", dfpercent.format(percentAbsorbed));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addBattleaxeLore(List<String> lore) {
        List lines = CONFIG.getStringList("Battleaxe");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addClubLore(List<String> lore, ConfigurationSection section) {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        int amplifier = section.getInt("Nausea.Amplifier") + 1;
        int duration = section.getInt("Nausea.Duration");
        List lines = CONFIG.getStringList("Club");
        Map<String, Object> placeholders = Map.of("NAUSEA_AMPLIFIER", Utils.toRomanNumeral(amplifier), "NAUSEA_DURATION", df.format((double)duration / 20.0));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addCestusLore(List<String> lore) {
        List lines = CONFIG.getStringList("Cestus");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addCrossbowLore(List<String> lore) {
        List lines = CONFIG.getStringList("Crossbow");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addLongbowLore(List<String> lore) {
        List lines = CONFIG.getStringList("Longbow");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addFlamedDragonboneLore(List<String> lore) {
        List lines = CONFIG.getStringList("FlamedDragonbone");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addIcedDragonboneLore(List<String> lore) {
        List lines = CONFIG.getStringList("IcedDragonbone");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addLightningDragonboneLore(List<String> lore) {
        List lines = CONFIG.getStringList("LightningDragonbone");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addFireDragonsteelLore(List<String> lore) {
        List lines = CONFIG.getStringList("FireDragonsteel");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addIceDragonsteelLore(List<String> lore) {
        List lines = CONFIG.getStringList("IceDragonsteel");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addLightningDragonsteelLore(List<String> lore) {
        List lines = CONFIG.getStringList("LightningDragonsteel");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addDragonSkullLore(ItemStack item, int stage, String breed) {
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = meta.getLore() != null && !meta.getLore().isEmpty() ? meta.getLore() : new ArrayList<String>();
        List lines = CONFIG.getStringList("DragonSkull");
        Map<String, Object> placeholders = Map.of("BREED", StringUtils.capitalize((String)breed.toLowerCase()), "STAGE", String.valueOf(stage));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static void addBlueDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("BlueDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addBronzeDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("BronzeDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addGrayDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("GrayDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addGreenDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("GreenDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addRedDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("RedDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addSapphireDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("SapphireDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addSilverDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("SilverDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addWhiteDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("WhiteDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addAmethystDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("AmethystDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addBlackDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("BlackDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addCopperDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("CopperDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addElectricDragonscaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("ElectricDragonscale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addBlueSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("BlueSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addBronzeSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("BronzeSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addDeepblueSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("DeepBlueSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addGreenSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("GreenSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addPurpleSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("PurpleSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addRedSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("RedSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addTealSeaSerpentScaleLore(List<String> lore) {
        List lines = CONFIG.getStringList("TealSeaSerpentScale");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addDragonProtectionLore(List<String> lore) {
        List lines = CONFIG.getStringList("DragonProtection");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addTideGuardianBreathingLore(List<String> lore) {
        List lines = CONFIG.getStringList("TideGuardianBreathing");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addLegendaryWeaponLore(List<String> lore) {
        List lines = CONFIG.getStringList("LegendaryWeapon");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addFlamedExtraDamageLore(List<String> lore, ConfigurationSection section) {
        List lines = CONFIG.getStringList("FlamedExtraDamage");
        double bonusDamage = section.getDouble("DragonBonusDamage");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", String.valueOf((int)Math.round(bonusDamage)));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addIcedExtraDamageLore(List<String> lore, ConfigurationSection section) {
        List lines = CONFIG.getStringList("IcedExtraDamage");
        double bonusDamage = section.getDouble("DragonBonusDamage");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", String.valueOf((int)Math.round(bonusDamage)));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addLightningExtraDamageLore(List<String> lore, ConfigurationSection section) {
        List lines = CONFIG.getStringList("LightningExtraDamage");
        double bonusDamage = section.getDouble("DragonBonusDamage");
        Map<String, Object> placeholders = Map.of("DAMAGE_BONUS", String.valueOf((int)Math.round(bonusDamage)));
        lore.addAll(Utils.translateMsgs(lines, null, placeholders));
    }

    public static void addWeaponLore(List<String> lore) {
        List lines = CONFIG.getStringList("Weapon");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addHelmetLore(List<String> lore) {
        List lines = CONFIG.getStringList("Helmet");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addChestplateLore(List<String> lore) {
        List lines = CONFIG.getStringList("Chestplate");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addLeggingsLore(List<String> lore) {
        List lines = CONFIG.getStringList("Leggings");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addBootsLore(List<String> lore) {
        List lines = CONFIG.getStringList("Boots");
        lore.addAll(Utils.translateMsgs(lines, null, null));
    }

    public static void addGearLore(List<String> lore, Material material) {
        lore.add("");
        if (Utils.isArmor(material)) {
            if (Utils.isHelmet(material)) {
                LorePresets.addHelmetLore(lore);
            } else if (Utils.isChestplate(material)) {
                LorePresets.addChestplateLore(lore);
            } else if (Utils.isLeggings(material)) {
                LorePresets.addLeggingsLore(lore);
            } else if (Utils.isBoots(material)) {
                LorePresets.addBootsLore(lore);
            }
        } else {
            LorePresets.addWeaponLore(lore);
        }
    }

    public static void addGearStats(List<String> lore, Attribute atr, double value) {
        DecimalFormat df = new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        if (!Utils.doublesEquals(value, 0.0)) {
            switch (atr) {
                case GENERIC_ATTACK_DAMAGE: {
                    lore.add(Utils.translateMsg("&2 " + df.format(value) + " Attack Damage", null, null));
                    break;
                }
                case GENERIC_ATTACK_SPEED: {
                    lore.add(Utils.translateMsg("&2 " + df.format(value) + " Attack Speed", null, null));
                    break;
                }
                case GENERIC_ARMOR: {
                    lore.add(Utils.translateMsg("&9+" + df.format(value) + " Armor", null, null));
                    break;
                }
                case GENERIC_ARMOR_TOUGHNESS: {
                    lore.add(Utils.translateMsg("&9+" + df.format(value) + " Armor Toughness", null, null));
                }
            }
        }
    }

    public static void useLorePreset(List<String> lore, String weaponType, ConfigurationSection section) {
        switch (weaponType) {
            case "RAPIER": {
                LorePresets.addRapierLore(lore, section);
                break;
            }
            case "SABER": {
                LorePresets.addSaberLore(lore, section);
                break;
            }
            case "KATANA": {
                LorePresets.addKatanaLore(lore, section);
                break;
            }
            case "GREATSWORD": {
                LorePresets.addGreatswordLore(lore, section);
                break;
            }
            case "LONGSWORD": {
                LorePresets.addLongswordLore(lore, section);
                break;
            }
            case "SPEAR": {
                LorePresets.addSpearLore(lore);
                break;
            }
            case "GLAIVE": {
                LorePresets.addGlaiveLore(lore, section);
                break;
            }
            case "BOOMERANG": {
                LorePresets.addBoomerangLore(lore);
                break;
            }
            case "DAGGER": {
                LorePresets.addDaggerLore(lore, section);
                break;
            }
            case "HALBERD": {
                LorePresets.addHalberdLore(lore, section);
                break;
            }
            case "HAMMER": {
                LorePresets.addHammerLore(lore, section);
                break;
            }
            case "JAVELIN": {
                LorePresets.addJavelinLore(lore, section);
                break;
            }
            case "LANCE": {
                LorePresets.addLanceLore(lore, section);
                break;
            }
            case "MACE": {
                LorePresets.addMaceLore(lore, section);
                break;
            }
            case "PIKE": {
                LorePresets.addPikeLore(lore);
                break;
            }
            case "QUARTERSTAFF": {
                LorePresets.addQuarterstaffLore(lore, section);
                break;
            }
            case "TOMAHAWK": {
                LorePresets.addTomahawkLore(lore, section);
                break;
            }
            case "THROWING_KNIFE": {
                LorePresets.addThrowingKnifeLore(lore, section);
                break;
            }
            case "WARHAMMER": {
                LorePresets.addWarhammerLore(lore, section);
                break;
            }
            case "BATTLEAXE": {
                LorePresets.addBattleaxeLore(lore);
                break;
            }
            case "CLUB": {
                LorePresets.addClubLore(lore, section);
                break;
            }
            case "CESTUS": {
                LorePresets.addCestusLore(lore);
                break;
            }
            case "LONGBOW": {
                LorePresets.addLongbowLore(lore);
                break;
            }
            case "CROSSBOW": {
                LorePresets.addCrossbowLore(lore);
                break;
            }
            case "FLAMED_DRAGONBONE": {
                LorePresets.addFlamedDragonboneLore(lore);
                break;
            }
            case "ICED_DRAGONBONE": {
                LorePresets.addIcedDragonboneLore(lore);
                break;
            }
            case "LIGHTNING_DRAGONBONE": {
                LorePresets.addLightningDragonboneLore(lore);
                break;
            }
            case "FIRE_DRAGONSTEEL": {
                LorePresets.addFireDragonsteelLore(lore);
                break;
            }
            case "ICE_DRAGONSTEEL": {
                LorePresets.addIceDragonsteelLore(lore);
                break;
            }
            case "LIGHTNING_DRAGONSTEEL": {
                LorePresets.addLightningDragonsteelLore(lore);
                break;
            }
            case "BLUE_DRAGON_SCALE": {
                LorePresets.addBlueDragonscaleLore(lore);
                break;
            }
            case "BRONZE_DRAGON_SCALE": {
                LorePresets.addBronzeDragonscaleLore(lore);
                break;
            }
            case "GRAY_DRAGON_SCALE": {
                LorePresets.addGrayDragonscaleLore(lore);
                break;
            }
            case "GREEN_DRAGON_SCALE": {
                LorePresets.addGreenDragonscaleLore(lore);
                break;
            }
            case "RED_DRAGON_SCALE": {
                LorePresets.addRedDragonscaleLore(lore);
                break;
            }
            case "SAPPHIRE_DRAGON_SCALE": {
                LorePresets.addSapphireDragonscaleLore(lore);
                break;
            }
            case "SILVER_DRAGON_SCALE": {
                LorePresets.addSilverDragonscaleLore(lore);
                break;
            }
            case "WHITE_DRAGON_SCALE": {
                LorePresets.addWhiteDragonscaleLore(lore);
                break;
            }
            case "AMETHYST_DRAGON_SCALE": {
                LorePresets.addAmethystDragonscaleLore(lore);
                break;
            }
            case "BLACK_DRAGON_SCALE": {
                LorePresets.addBlackDragonscaleLore(lore);
                break;
            }
            case "COPPER_DRAGON_SCALE": {
                LorePresets.addCopperDragonscaleLore(lore);
                break;
            }
            case "ELECTRIC_DRAGON_SCALE": {
                LorePresets.addElectricDragonscaleLore(lore);
                break;
            }
            case "BLUE_SEA_SERPENT_SCALE": {
                LorePresets.addBlueSeaSerpentScaleLore(lore);
                break;
            }
            case "BRONZE_SEA_SERPENT_SCALE": {
                LorePresets.addBronzeSeaSerpentScaleLore(lore);
                break;
            }
            case "DEEPBLUE_SEA_SERPENT_SCALE": {
                LorePresets.addDeepblueSeaSerpentScaleLore(lore);
                break;
            }
            case "GREEN_SEA_SERPENT_SCALE": {
                LorePresets.addGreenSeaSerpentScaleLore(lore);
                break;
            }
            case "PURPLE_SEA_SERPENT_SCALE": {
                LorePresets.addPurpleSeaSerpentScaleLore(lore);
                break;
            }
            case "RED_SEA_SERPENT_SCALE": {
                LorePresets.addRedSeaSerpentScaleLore(lore);
                break;
            }
            case "TEAL_SEA_SERPENT_SCALE": {
                LorePresets.addTealSeaSerpentScaleLore(lore);
                break;
            }
            case "DRAGON_PROTECTION": {
                LorePresets.addDragonProtectionLore(lore);
                break;
            }
            case "TIDE_GUARDIAN_BREATHING": {
                LorePresets.addTideGuardianBreathingLore(lore);
                break;
            }
            case "LEGENDARY_WEAPON": {
                LorePresets.addLegendaryWeaponLore(lore);
                break;
            }
            case "FLAMED_EXTRA_DAMAGE": {
                LorePresets.addFlamedExtraDamageLore(lore, section);
                break;
            }
            case "ICED_EXTRA_DAMAGE": {
                LorePresets.addIcedExtraDamageLore(lore, section);
                break;
            }
            case "LIGHTNING_EXTRA_DAMAGE": {
                LorePresets.addLightningExtraDamageLore(lore, section);
            }
        }
    }
}

