/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils.recipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;

public interface RSVRecipe {
    @Nullable
    public static ItemStack getItem(@Nonnull FileConfiguration config, @Nonnull String namePath) {
        String itemName = config.getString(namePath);
        if (itemName.equals(itemName.toUpperCase())) {
            return new ItemStack(Material.valueOf((String)itemName));
        }
        if (RSVItem.isRSVItem(itemName)) {
            return RSVItem.getItem(itemName);
        }
        return null;
    }

    @Nullable
    public static ItemStack getItem(@Nonnull FileConfiguration config, @Nonnull String namePath, @Nonnull String amountPath) {
        ItemStack item = RSVRecipe.getItem(config, namePath);
        if (item != null) {
            item.setAmount(config.getInt(amountPath));
            return item;
        }
        return null;
    }

    @Nullable
    public static ItemStack getResult(@Nonnull FileConfiguration config, @Nonnull String name) {
        return RSVRecipe.getItem(config, name + ".Result.Item", name + ".Result.Amount");
    }

    @Nullable
    public static RecipeChoice getRecipeChoice(@Nonnull String text) {
        Object obj = RSVRecipe.parseIng(text);
        if (obj != null) {
            return RSVRecipe.parseRecChoice(obj);
        }
        return null;
    }

    @Nullable
    public static Object parseIng(@Nonnull String text) {
        if (text.isEmpty()) {
            return null;
        }
        if (text.matches("^\\(([a-zA-Z_,]+)\\)$")) {
            text = text.substring(1, text.length() - 1);
            String[] entries = text.split(",");
            ArrayList<RSVItem> items = new ArrayList<RSVItem>();
            for (String s : entries) {
                if (RSVItem.getItemMap().containsKey(s)) {
                    items.add(RSVItem.getItem(s));
                    continue;
                }
                if (s.matches("^([A-Z_]+)$")) {
                    items.add((RSVItem)Material.valueOf((String)s));
                    continue;
                }
                if (!s.matches("^Tag\\.([A-Z]+)$")) continue;
                items.add((RSVItem)Utils.getTag(s.substring(4)));
            }
            return items;
        }
        if (RSVItem.getItemMap().containsKey(text)) {
            return RSVItem.getItem(text);
        }
        if (text.matches("^([A-Z_]+)$")) {
            return Material.valueOf((String)text);
        }
        if (text.matches("^Tag\\.([A-Z]+)$")) {
            return Utils.getTag(text.substring(4));
        }
        return null;
    }

    @Nullable
    public static RecipeChoice parseRecChoice(@Nonnull Object obj) {
        List list;
        if (obj instanceof List && !(list = (List)obj).isEmpty()) {
            if (list.get(0) instanceof Material) {
                return new RecipeChoice.MaterialChoice(list);
            }
            if (list.get(0) instanceof ItemStack) {
                return new RecipeChoice.ExactChoice(list);
            }
        } else {
            if (obj instanceof Material) {
                return new RecipeChoice.MaterialChoice((Material)obj);
            }
            if (obj instanceof Tag) {
                return new RecipeChoice.MaterialChoice((Tag)obj);
            }
            if (obj instanceof ItemStack) {
                return new RecipeChoice.ExactChoice((ItemStack)obj);
            }
        }
        return null;
    }
}

