/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.val_mobile.baubles.BaubleChange;
import me.val_mobile.baubles.BaubleChangeEvent;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.baubles.BrokenHeartRepairTask;
import me.val_mobile.baubles.EnderCrownTask;
import me.val_mobile.baubles.EndermanAllyUtils;
import me.val_mobile.baubles.MagicMirrorTask;
import me.val_mobile.baubles.PolarizedStoneTask;
import me.val_mobile.baubles.PotionBauble;
import me.val_mobile.baubles.PotionBaubleTask;
import me.val_mobile.baubles.ScarliteRingTask;
import me.val_mobile.baubles.StoneGreaterInertiaTask;
import me.val_mobile.baubles.StoneNegativeGravityTask;
import me.val_mobile.baubles.StoneSeaTask;
import me.val_mobile.baubles.Tickable;
import me.val_mobile.baubles.TickableBaubleManager;
import me.val_mobile.baubles.WormholeMirrorTask;
import me.val_mobile.data.ModuleEvents;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.data.baubles.BaubleInventory;
import me.val_mobile.data.baubles.BaubleSlot;
import me.val_mobile.data.baubles.DataModule;
import me.val_mobile.misc.PlayerItemAcquireEvent;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.PlayerJumpEvent;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class BaubleEvents
extends ModuleEvents
implements Listener {
    private final RSVPlugin plugin;
    private final FileConfiguration config;
    private final BaubleModule module;

    public BaubleEvents(BaubleModule module, RSVPlugin plugin) {
        super(module, plugin);
        this.plugin = plugin;
        this.module = module;
        this.config = module.getUserConfig().getConfig();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        ItemStack cornerItem = player.getOpenInventory().getTopInventory().getItem(0);
        if (!(this.shouldEventBeRan((Entity)player) && RSVItem.isRSVItem(cornerItem) && Objects.equals(RSVItem.getNameFromItem(cornerItem), "gui_glass"))) {
            return;
        }
        if (RSVItem.isRSVItem(droppedItem)) {
            switch (RSVItem.getNameFromItem(droppedItem)) {
                case "gui_glass": 
                case "body_slot": 
                case "ring_slot": 
                case "charm_slot": 
                case "belt_slot": 
                case "amulet_slot": 
                case "head_slot": {
                    event.setCancelled(true);
                    break;
                }
                default: {
                    if (Objects.equals(RSVItem.getModuleNameFromItem(droppedItem), "Baubles")) {
                        Bukkit.getServer().getPluginManager().callEvent((Event)new BaubleChangeEvent(player, droppedItem, BaubleChange.REMOVAL));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (Utils.isItemReal(droppedItem) && droppedItem.getType() == Material.PLAYER_HEAD) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        if (!this.module.getInv().containsPlayer(player)) {
            this.module.getInv().addPlayer(player);
        }
        if (!RSVPlayer.isValidPlayer(player)) {
            return;
        }
        UUID id = event.getPlayer().getUniqueId();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
        Collection<ItemStack> baubles = rsvPlayer.getBaubleDataModule().getBaubleBag().getAllBaubles();
        for (ItemStack item : baubles) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new BaubleChangeEvent(player, item, BaubleChange.ADDITION));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !this.module.getInv().containsPlayer(player)) {
            return;
        }
        this.module.getInv().removePlayer(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !RSVPlayer.isValidPlayer(player) || event.getNewGameMode() != GameMode.ADVENTURE && event.getNewGameMode() != GameMode.SURVIVAL) {
            return;
        }
        UUID id = event.getPlayer().getUniqueId();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
        Collection<ItemStack> baubles = rsvPlayer.getBaubleDataModule().getBaubleBag().getAllBaubles();
        for (ItemStack item : baubles) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new BaubleChangeEvent(player, item, BaubleChange.ADDITION));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.shouldEventBeRan((Entity)player)) {
            if (!this.shouldEventBeRan(event.getFrom())) {
                if (!this.module.getInv().containsPlayer(player)) {
                    this.module.getInv().addPlayer(player);
                }
                if (!RSVPlayer.isValidPlayer(player)) {
                    return;
                }
                UUID id = event.getPlayer().getUniqueId();
                RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
                Collection<ItemStack> baubles = rsvPlayer.getBaubleDataModule().getBaubleBag().getAllBaubles();
                for (ItemStack item : baubles) {
                    Bukkit.getServer().getPluginManager().callEvent((Event)new BaubleChangeEvent(player, item, BaubleChange.ADDITION));
                }
            }
        } else if (this.module.getInv().containsPlayer(player)) {
            this.module.getInv().removePlayer(player);
        }
    }

    @EventHandler
    public void onBaubleChangeEvent(BaubleChangeEvent event) {
        String itemName = event.getBaubleName();
        UUID id = event.getPlayer().getUniqueId();
        if (!RSVPlayer.isValidPlayer(id)) {
            return;
        }
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
        if (event.getChange() == BaubleChange.ADDITION) {
            boolean isValid = true;
            TickableBaubleManager manager = null;
            try {
                manager = TickableBaubleManager.valueOf(itemName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                isValid = false;
            }
            if (isValid) {
                Tickable bauble = manager.getBauble();
                if (bauble != null) {
                    switch (manager) {
                        case POTION_RING_REGENERATION: 
                        case POTION_RING_HASTE: 
                        case POTION_RING_SPEED: 
                        case POTION_RING_STRENGTH: 
                        case POTION_RING_JUMP_BOOST: 
                        case POTION_RING_RESISTANCE: 
                        case MINERS_RING: 
                        case SHIELD_HONOR: 
                        case DRAGONS_EYE: 
                        case PHANTOM_PRISM: 
                        case PRIDE_PENDANT: {
                            if (PotionBaubleTask.hasTask(id, manager.toString().toLowerCase())) break;
                            new PotionBaubleTask(this.module, (PotionBauble)bauble, rsvPlayer, this.plugin).start();
                            break;
                        }
                        case STONE_SEA: {
                            if (!StoneSeaTask.hasTask(id)) {
                                new StoneSeaTask(this.module, rsvPlayer, this.plugin).start();
                            }
                            if (PotionBaubleTask.hasTask(id, manager.toString().toLowerCase())) break;
                            new PotionBaubleTask(this.module, (PotionBauble)bauble, rsvPlayer, this.plugin).start();
                            break;
                        }
                        case SCARLITE_RING: {
                            if (ScarliteRingTask.hasTask(id)) break;
                            new ScarliteRingTask(this.module, rsvPlayer, this.plugin).start();
                            break;
                        }
                        case POLARIZED_STONE: {
                            if (PolarizedStoneTask.hasTask(id)) break;
                            new PolarizedStoneTask(this.module, rsvPlayer, this.plugin).start();
                            break;
                        }
                        case ENDER_QUEENS_CROWN: {
                            if (EnderCrownTask.hasTask(id)) break;
                            new EnderCrownTask(this.module, rsvPlayer, this.plugin).start();
                            break;
                        }
                        case STONE_NEGATIVE_GRAVITY: {
                            if (StoneNegativeGravityTask.hasTask(id)) break;
                            new StoneNegativeGravityTask(this.module, rsvPlayer, this.plugin).start();
                            break;
                        }
                        case STONE_GREATER_INERTIA: {
                            if (StoneGreaterInertiaTask.hasTask(id)) break;
                            new StoneGreaterInertiaTask(this.module, rsvPlayer, this.plugin).start();
                            break;
                        }
                    }
                }
            } else if (itemName.equals("broken_heart")) {
                this.module.getBrokenHeartPlayers().add(id);
            }
        } else if (itemName.equals("broken_heart")) {
            this.module.getBrokenHeartPlayers().remove(id);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!(this.shouldEventBeRan((Entity)player) && this.config.getBoolean("DropBaublesUponDeath.Enabled") && RSVPlayer.isValidPlayer(player))) {
            return;
        }
        if (((Boolean)player.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY)).booleanValue()) {
            if (this.config.getBoolean("DropBaublesUponDeath.IgnoreKeepInventoryGamerule")) {
                RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule().getBaubleBag().removeAndDropAllBaubles(player.getLocation());
            }
        } else {
            RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule().getBaubleBag().removeAndDropAllBaubles(player.getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClick(final InventoryClickEvent event) {
        block48: {
            ItemStack current;
            Player player;
            block49: {
                int rawSlot;
                String currentName;
                block52: {
                    ItemStack cursor;
                    block51: {
                        block50: {
                            player = (Player)event.getWhoClicked();
                            if (!this.shouldEventBeRan((Entity)player) || event.getClickedInventory() == null) {
                                return;
                            }
                            cursor = event.getCursor();
                            ItemStack corner = event.getClickedInventory().getItem(0);
                            current = event.getCurrentItem();
                            if (!RSVItem.isRSVItem(corner) || !RSVItem.getNameFromItem(corner).equals("gui_glass")) {
                                return;
                            }
                            if (!RSVItem.isRSVItem(current)) break block49;
                            currentName = RSVItem.getNameFromItem(current);
                            if (!currentName.equals("gui_glass") && event.getClick() != ClickType.SWAP_OFFHAND) break block50;
                            event.setCancelled(true);
                            break block48;
                        }
                        rawSlot = event.getRawSlot();
                        if (!RSVItem.isRSVItem(cursor)) break block51;
                        String cursorName = RSVItem.getNameFromItem(cursor);
                        if (!RSVItem.getNameFromItem(cursor).equals("gui_glass") && Utils.hasNbtTag(cursor, "rsvbaubleslot") && Utils.hasNbtTag(current, "rsvbaubleslot") && cursor.getAmount() == 1 && !Objects.equals(RSVItem.getNameFromItem(current), RSVItem.getNameFromItem(cursor)) && event.getClick() != ClickType.DOUBLE_CLICK) {
                            String cursorTag = (String)Utils.getNbtTag(cursor, "rsvbaubleslot", PersistentDataType.STRING);
                            switch (cursorName) {
                                case "body_slot": 
                                case "ring_slot": 
                                case "charm_slot": 
                                case "belt_slot": 
                                case "amulet_slot": 
                                case "head_slot": {
                                    event.setCancelled(true);
                                    break;
                                }
                                default: {
                                    BaubleSlot currentSlot = null;
                                    BaubleSlot[] slots = BaubleSlot.values();
                                    block33: for (BaubleSlot s : slots) {
                                        for (int i : s.getValues()) {
                                            if (i != rawSlot) continue;
                                            currentSlot = s;
                                            break block33;
                                        }
                                    }
                                    if (currentSlot == null) {
                                        event.setCancelled(true);
                                        break;
                                    }
                                    if (cursorTag.equals(currentSlot.getTag()) || cursorTag.equals("Any")) {
                                        switch (currentName) {
                                            case "body_slot": 
                                            case "ring_slot": 
                                            case "charm_slot": 
                                            case "belt_slot": 
                                            case "amulet_slot": 
                                            case "head_slot": {
                                                event.setCurrentItem(null);
                                                break;
                                            }
                                        }
                                        Bukkit.getServer().getPluginManager().callEvent((Event)new BaubleChangeEvent(player, cursor, BaubleChange.ADDITION));
                                        break;
                                    }
                                    event.setCancelled(true);
                                    break;
                                }
                            }
                        } else {
                            event.setCancelled(true);
                        }
                        break block48;
                    }
                    if (!Utils.isItemReal(cursor)) break block52;
                    event.setCancelled(true);
                    break block48;
                }
                block30 : switch (currentName) {
                    case "head_slot": 
                    case "body_slot": 
                    case "amulet_slot": 
                    case "ring_slot": 
                    case "charm_slot": 
                    case "belt_slot": {
                        event.setCancelled(true);
                        break block48;
                    }
                    default: {
                        if (event.getClick() == ClickType.NUMBER_KEY) {
                            event.setCancelled(true);
                        } else {
                            BaubleSlot[] baubleSlotArray = BaubleSlot.values();
                            int n = baubleSlotArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                final BaubleSlot baubleslot = baubleSlotArray[n2];
                                for (final int i : baubleslot.getValues()) {
                                    if (i != rawSlot) continue;
                                    new BukkitRunnable(this){

                                        public void run() {
                                            switch (event.getClick()) {
                                                case CONTROL_DROP: 
                                                case DROP: 
                                                case SWAP_OFFHAND: {
                                                    RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule().getBaubleBag().getInventory().setItem(i, baubleslot.getItem());
                                                    break;
                                                }
                                                case MIDDLE: {
                                                    break;
                                                }
                                                default: {
                                                    event.getWhoClicked().setItemOnCursor(current);
                                                    RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule().getBaubleBag().getInventory().setItem(i, baubleslot.getItem());
                                                }
                                            }
                                        }
                                    }.runTaskLater((Plugin)this.plugin, 1L);
                                    break block48;
                                }
                                ++n2;
                                break block30;
                            }
                        }
                        break block48;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            if (Utils.isItemReal(current) && current.getType() == Material.PLAYER_HEAD) {
                Player destination;
                UUID id = ((SkullMeta)current.getItemMeta()).getOwningPlayer().getUniqueId();
                if (!player.getUniqueId().equals(id) && (destination = Bukkit.getPlayer((UUID)id)) != null) {
                    player.teleport((Entity)destination);
                    if (this.config.getBoolean("WormholeInventory.Sound.Enabled")) {
                        String soundName = this.config.getString("WormholeInventory.Sound.Sound");
                        float volume = (float)this.config.getDouble("WormholeInventory.Sound.Volume");
                        float pitch = (float)this.config.getDouble("WormholeInventory.Sound.Pitch");
                        Utils.playSound(Bukkit.getPlayer((UUID)id).getLocation(), soundName, volume, pitch);
                    }
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTarget(EntityTargetEvent event) {
        RSVPlayer rsvPlayer;
        DataModule module;
        Player player;
        Entity aggressor = event.getEntity();
        Entity target = event.getTarget();
        if (!(this.shouldEventBeRan(aggressor) && this.shouldEventBeRan(target) && aggressor instanceof Enderman)) {
            return;
        }
        if (target instanceof Player && RSVPlayer.isValidPlayer(player = (Player)target) && (module = (rsvPlayer = RSVPlayer.getPlayers().get(player.getUniqueId())).getBaubleDataModule()).getBaubleBag().hasBauble("ender_queens_crown") && this.config.getBoolean("Items.ender_queens_crown.PreventEndermenAngering")) {
            event.setCancelled(true);
        }
        if (EndermanAllyUtils.isEndermanAlly(aggressor)) {
            Tameable tameable;
            UUID agOwnerId = EndermanAllyUtils.getOwnerId(aggressor);
            if (EndermanAllyUtils.isEndermanAlly(target) && this.config.getBoolean("Items.ender_queens_crown.PreventFriendlyFireToAllies") && EndermanAllyUtils.getOwnerId(target).equals(agOwnerId)) {
                event.setCancelled(true);
            }
            if (target instanceof Tameable && (tameable = (Tameable)target).getOwner() != null && this.config.getBoolean("Items.ender_queens_crown.PreventFriendlyFireToPets") && tameable.getOwner().getUniqueId().equals(agOwnerId)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        LivingEntity living;
        Player player;
        block9: {
            block8: {
                Entity attacker = event.getDamager();
                Entity defender = event.getEntity();
                if (!this.shouldEventBeRan(attacker) || !this.shouldEventBeRan(defender) || !(attacker instanceof Player)) break block8;
                player = (Player)attacker;
                if (!(defender instanceof LivingEntity)) break block8;
                living = (LivingEntity)defender;
                if (RSVPlayer.isValidPlayer(player)) break block9;
            }
            return;
        }
        double damage = event.getDamage();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        DataModule module = rsvPlayer.getBaubleDataModule();
        BaubleInventory inv = module.getBaubleBag();
        if (inv.hasBauble("wrath_pendant") && Utils.areCriticalHitConditionsMet(player, event.getDamage(), event.getFinalDamage())) {
            ((PotionBauble)TickableBaubleManager.WRATH_PENDANT.getBauble()).ability(player, inv.getBaubleAmount("wrath_pendant"));
        }
        if (inv.hasBauble("poison_stone")) {
            boolean isAffected = false;
            ConfigurationSection section = this.config.getConfigurationSection("Items.poison_stone.Effects");
            Set keys = section.getKeys(false);
            for (String key : keys) {
                if (living.hasPotionEffect(PotionEffectType.getByName((String)key))) {
                    isAffected = true;
                }
                living.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)key), section.getInt(key + ".Duration"), section.getInt(key + ".Amplifier")));
            }
            if (isAffected) {
                damage *= this.config.getDouble("Items.poison_stone.AttackDamageMultiplier");
            }
        }
        event.setDamage(damage);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageMonitor(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || !RSVPlayer.isValidPlayer(player = (Player)entity)) {
            return;
        }
        UUID id = player.getUniqueId();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
        DataModule module = rsvPlayer.getBaubleDataModule();
        BaubleInventory inv = module.getBaubleBag();
        if (!inv.hasBauble("ender_queens_crown") || !EnderCrownTask.hasTask(id)) {
            return;
        }
        EnderCrownTask task = EnderCrownTask.getTasks().get(id);
        if (task.areAlliesEnabled() && task.canSpawnAllies(true)) {
            task.spawnAllies();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        ItemStack item;
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player && this.shouldEventBeRan((Entity)(player = (Player)entity)) && RSVPlayer.isValidPlayer(player))) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        PlayerInventory inv = player.getInventory();
        ItemStack itemOffHand = inv.getItemInOffHand();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        DataModule module = rsvPlayer.getBaubleDataModule();
        BaubleInventory baubleInv = module.getBaubleBag();
        String offHandName = "";
        if (RSVItem.isRSVItem(itemOffHand)) {
            offHandName = RSVItem.getNameFromItem(itemOffHand);
        }
        double damage = event.getDamage();
        boolean cobaltShield = baubleInv.hasBauble("cobalt_shield") || offHandName.equals("cobalt_shield");
        boolean obsShield = baubleInv.hasBauble("obsidian_shield") || offHandName.equals("obsidian_shield");
        boolean ankhShield = baubleInv.hasBauble("ankh_shield") || offHandName.equals("ankh_shield");
        double kbMultiplier = -1.0;
        if (baubleInv.hasBauble("stone_greater_inertia")) {
            kbMultiplier = this.config.getDouble("Items.stone_greater_inertia.KnockbackPercent");
        }
        if (cobaltShield || obsShield || ankhShield || baubleInv.hasBauble("stone_inertia_null")) {
            kbMultiplier = 0.0;
        }
        if (kbMultiplier >= 0.0) {
            Utils.setKbMultiplier((Entity)player, kbMultiplier);
        }
        switch (cause) {
            case FIRE: 
            case FIRE_TICK: {
                if (baubleInv.hasBauble("obsidian_skull")) {
                    damage *= this.config.getDouble("Items.obsidian_skull.HeatDamageMultiplier");
                }
                if (obsShield) {
                    damage *= this.config.getDouble("Items.obsidian_shield.HeatDamageMultiplier");
                }
                if (!ankhShield) break;
                damage *= this.config.getDouble("Items.ankh_shield.HeatDamageMultiplier");
                break;
            }
            case ENTITY_EXPLOSION: 
            case BLOCK_EXPLOSION: {
                if (!baubleInv.hasBauble("shield_honor")) break;
                damage *= this.config.getDouble("Items.shield_honor.ExplosionDamageMultiplier");
                break;
            }
            case FALL: {
                double minFallDistance = 0.0;
                double damageMultiplier = 1.0;
                if (baubleInv.hasBauble("balloon")) {
                    minFallDistance = this.config.getDouble("Items.balloon.MinFallDistance");
                    damageMultiplier *= this.config.getDouble("Items.balloon.FallDamageMultiplier");
                }
                if (baubleInv.hasBauble("stone_greater_inertia")) {
                    minFallDistance += this.config.getDouble("Items.stone_greater_inertia.MinFallDistance");
                    damageMultiplier *= this.config.getDouble("Items.stone_greater_inertia.FallDamageMultiplier");
                }
                damage *= damageMultiplier;
                if ((double)player.getFallDistance() <= minFallDistance) {
                    event.setCancelled(true);
                }
                if (!baubleInv.hasBauble("lucky_horseshoe") && !baubleInv.hasBauble("stone_inertia_null")) break;
                event.setCancelled(true);
                break;
            }
            case CONTACT: {
                if (!baubleInv.hasBauble("phytoprostasia_amulet")) break;
                event.setCancelled(true);
            }
        }
        if (baubleInv.hasBauble("cross_necklace")) {
            player.setNoDamageTicks(this.config.getInt("Items.cross_necklace.InvFrameLength"));
        }
        if (player.getHealth() - event.getFinalDamage() <= 0.0 && baubleInv.hasBauble("broken_heart") && Utils.getCustomDurability(item = baubleInv.getItem("broken_heart")) >= 1) {
            Utils.changeDurability(item, -1, false, false, (Entity)player);
            if (this.config.getBoolean("Items.broken_heart.PlayTotemEffect")) {
                player.playEffect(EntityEffect.TOTEM_RESURRECT);
            }
            event.setCancelled(true);
        }
        event.setDamage(damage);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSleep(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK || !RSVPlayer.isValidPlayer(player)) {
            return;
        }
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        DataModule dataModule = rsvPlayer.getBaubleDataModule();
        if (dataModule.getBaubleBag().hasBauble("broken_heart") && !BrokenHeartRepairTask.hasTask(player.getUniqueId())) {
            new BrokenHeartRepairTask(this.plugin, this.module, rsvPlayer).start();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSkip(TimeSkipEvent event) {
        World world = event.getWorld();
        if (!this.shouldEventBeRan(world) || event.getSkipReason() != TimeSkipEvent.SkipReason.NIGHT_SKIP || !this.config.getBoolean("Items.broken_heart.SleepRepair.Enabled")) {
            return;
        }
        Collection<UUID> ids = this.module.getBrokenHeartPlayers();
        for (UUID id : ids) {
            if (!RSVPlayer.isValidPlayer(id)) continue;
            RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
            DataModule dataModule = rsvPlayer.getBaubleDataModule();
            if (dataModule.getBaubleBag().hasBauble("broken_heart")) {
                Utils.changeDurability(dataModule.getBaubleBag().getItem("broken_heart"), 1, false, false, (Entity)rsvPlayer.getPlayer());
            }
            if (!BrokenHeartRepairTask.hasTask(id)) continue;
            BrokenHeartRepairTask.getTasks().get(id).stop();
        }
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !RSVPlayer.isValidPlayer(player)) {
            return;
        }
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        DataModule module = rsvPlayer.getBaubleDataModule();
        BaubleInventory baubleInv = module.getBaubleBag();
        double jumpVelocity = 0.42;
        if (player.hasPotionEffect(PotionEffectType.JUMP)) {
            PotionEffect jumpBoost = player.getPotionEffect(PotionEffectType.JUMP);
            jumpVelocity += ((double)jumpBoost.getAmplifier() + 1.0) * 0.1;
        }
        if (baubleInv.hasBauble("balloon")) {
            jumpVelocity *= this.config.getDouble("Items.balloon.JumpVelocityMultiplier");
        }
        if (baubleInv.hasBauble("stone_greater_inertia")) {
            jumpVelocity *= this.config.getDouble("Items.stone_greater_inertia.JumpVelocityMultiplier");
        }
        if (!Utils.doublesEquals(jumpVelocity, 0.42)) {
            player.setVelocity(player.getVelocity().setY(jumpVelocity));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraft(CraftItemEvent event) {
        ShapedRecipe shaped;
        ShapelessRecipe shapeless;
        Player player = (Player)event.getView().getPlayer();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        Object object = event.getRecipe();
        if (object instanceof ShapelessRecipe && (shapeless = (ShapelessRecipe)object).getKey().getNamespace().equals("realisticsurvival")) {
            block17 : switch (shapeless.getKey().getKey()) {
                case "spectral_silt_broken_heart": 
                case "spectral_silt_balloon": 
                case "spectral_silt_cobalt_shield": 
                case "spectral_silt_obsidian_shield": 
                case "spectral_silt_magic_mirror": 
                case "spectral_silt_wormhole_mirror": 
                case "spectral_silt_lucky_horseshoe": 
                case "spectral_silt_sunglasses": 
                case "spectral_silt_cross_necklace": 
                case "spectral_silt_sin_pendant": 
                case "spectral_silt_flare_gun": 
                case "spectral_silt_cracked_black_dragonscale": 
                case "spectral_silt_diamond_block": 
                case "spectral_silt_emerald_block": 
                case "spectral_silt_cross_phantom_prism": {
                    ItemStack[] matrix;
                    CraftingInventory inv = event.getInventory();
                    for (ItemStack item : matrix = inv.getMatrix()) {
                        ItemStack[] contents;
                        if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).equals("disintegration_tablet")) continue;
                        for (ItemStack i : contents = player.getInventory().getContents()) {
                            if (Utils.isItemReal(i)) continue;
                            player.getInventory().addItem(new ItemStack[]{item});
                            break block17;
                        }
                        player.getWorld().dropItemNaturally(player.getLocation(), item);
                        break block17;
                    }
                    break;
                }
            }
        }
        if ((object = event.getRecipe()) instanceof ShapedRecipe && (shaped = (ShapedRecipe)object).getKey().getNamespace().equals("realisticsurvival") && shaped.getKey().getKey().equals("spectral_silt_flare")) {
            ItemStack[] matrix;
            CraftingInventory inv = event.getInventory();
            block22: for (ItemStack item : matrix = inv.getMatrix()) {
                ItemStack[] contents;
                if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).equals("disintegration_tablet")) continue;
                for (ItemStack i : contents = player.getInventory().getContents()) {
                    if (Utils.isItemReal(i)) continue;
                    player.getInventory().addItem(new ItemStack[]{item});
                    break block22;
                }
                player.getWorld().dropItemNaturally(player.getLocation(), item);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionEffect(EntityPotionEffectEvent event) {
        boolean sunglasses;
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player && this.shouldEventBeRan((Entity)(player = (Player)entity)) && RSVPlayer.isValidPlayer(player))) {
            return;
        }
        PotionEffect newEffect = event.getNewEffect();
        ItemStack itemOffHand = player.getInventory().getItemInOffHand();
        ItemStack helmet = player.getInventory().getHelmet();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        DataModule module = rsvPlayer.getBaubleDataModule();
        BaubleInventory baubleInv = module.getBaubleBag();
        String offHandName = "";
        String helmetName = "";
        if (RSVItem.isRSVItem(itemOffHand)) {
            offHandName = RSVItem.getNameFromItem(itemOffHand);
        }
        if (RSVItem.isRSVItem(helmet)) {
            helmetName = RSVItem.getNameFromItem(helmet);
        }
        boolean ankhShield = baubleInv.hasBauble("ankh_shield") || offHandName.equals("ankh_shield");
        boolean bl = sunglasses = baubleInv.hasBauble("sunglasses") || helmetName.equals("sunglasses");
        if (newEffect == null) {
            return;
        }
        switch (newEffect.getType().getName()) {
            case "HUNGER": {
                if (!baubleInv.hasBauble("forbidden_fruit") && !baubleInv.hasBauble("ankh_charm") && !ankhShield) break;
                event.setCancelled(true);
                break;
            }
            case "SLOW": {
                if (!baubleInv.hasBauble("ring_overclocking") && !baubleInv.hasBauble("ring_free_action") && !baubleInv.hasBauble("ankh_charm") && !ankhShield) break;
                event.setCancelled(true);
                break;
            }
            case "POISON": {
                if (!baubleInv.hasBauble("bezoar") && !baubleInv.hasBauble("mixed_color_dragonscale") && !baubleInv.hasBauble("ankh_charm") && !ankhShield) break;
                event.setCancelled(true);
                break;
            }
            case "WITHER": {
                if (!baubleInv.hasBauble("black_dragonscale_bauble") && !baubleInv.hasBauble("mixed_color_dragonscale") && !baubleInv.hasBauble("ankh_charm") && !baubleInv.hasBauble("wither_ring") && !ankhShield) break;
                event.setCancelled(true);
                break;
            }
            case "SLOW_DIGGING": {
                if (!baubleInv.hasBauble("vitamins") && !baubleInv.hasBauble("ankh_charm") && !ankhShield) break;
                event.setCancelled(true);
                break;
            }
            case "BLINDNESS": 
            case "DARKNESS": {
                if (!sunglasses && !baubleInv.hasBauble("ankh_charm") && !ankhShield) break;
                event.setCancelled(true);
                break;
            }
            case "LEVITATION": {
                if (!baubleInv.hasBauble("shulker_heart") && !baubleInv.hasBauble("ring_free_action") && !baubleInv.hasBauble("ankh_charm") && !ankhShield) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !RSVPlayer.isValidPlayer(player)) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack itemMainHand = player.getInventory().getItemInMainHand();
            if (!RSVItem.isRSVItem(itemMainHand)) {
                return;
            }
            switch (RSVItem.getNameFromItem(itemMainHand)) {
                case "bauble_bag": {
                    DataModule module = RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule();
                    player.openInventory(module.getBaubleBag().getInventory());
                    break;
                }
                case "magic_mirror": {
                    if (MagicMirrorTask.hasTask(player.getUniqueId())) break;
                    player.openInventory(this.module.getInv().getInventory());
                    Location loc = player.getBedSpawnLocation() == null ? player.getWorld().getSpawnLocation() : player.getBedSpawnLocation();
                    player.teleport(loc);
                    if (this.config.getBoolean("Items.magic_mirror.Sound.Enabled")) {
                        String soundName = this.config.getString("Items.magic_mirror.Sound.Sound");
                        float volume = (float)this.config.getDouble("Items.magic_mirror.Sound.Volume");
                        float pitch = (float)this.config.getDouble("Items.magic_mirror.Sound.Pitch");
                        Utils.playSound(loc, soundName, volume, pitch);
                    }
                    new MagicMirrorTask(player, this.plugin).start();
                    break;
                }
                case "wormhole_mirror": {
                    if (WormholeMirrorTask.hasTask(player.getUniqueId())) break;
                    player.openInventory(this.module.getInv().getInventory());
                    new WormholeMirrorTask(this.module, player, this.plugin).start();
                    break;
                }
            }
        } else if (event.getAction() == Action.LEFT_CLICK_AIR) {
            UUID id = player.getUniqueId();
            RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
            DataModule module = rsvPlayer.getBaubleDataModule();
            if (module.getBaubleBag().hasBauble("stone_negative_gravity")) {
                Vector velocity = player.getVelocity();
                double increment = this.config.getDouble("Items.stone_negative_gravity.Flight.Increment");
                if (player.isSneaking()) {
                    double temp = velocity.getY() - increment;
                    if (temp >= this.config.getDouble("Items.stone_negative_gravity.Flight.MaxDownwardVelocity")) {
                        player.setVelocity(velocity.setY(velocity.getY() - increment));
                    }
                } else {
                    double temp = velocity.getY() + increment;
                    if (temp <= this.config.getDouble("Items.stone_negative_gravity.Flight.MaxUpwardVelocity")) {
                        player.setVelocity(velocity.setY(velocity.getY() + increment));
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRegenerate(EntityRegainHealthEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player && this.shouldEventBeRan((Entity)(player = (Player)entity)) && RSVPlayer.isValidPlayer(player) && player.getHealth() + event.getAmount() >= player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())) {
            return;
        }
        UUID id = player.getUniqueId();
        RSVPlayer rsvplayer = RSVPlayer.getPlayers().get(id);
        BaubleInventory inv = rsvplayer.getBaubleDataModule().getBaubleBag();
        if (inv.hasBauble("pride_pendant") && !PotionBaubleTask.hasTask(id, "pride_pendant")) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new BaubleChangeEvent(player, inv.getItem("pride_pendant"), BaubleChange.ADDITION));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !RSVPlayer.isValidPlayer(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (RSVItem.isRSVItem(item)) {
            if (RSVItem.getNameFromItem(item).equals("recall_potion")) {
                Location loc = player.getBedSpawnLocation() == null ? player.getWorld().getSpawnLocation() : player.getBedSpawnLocation();
                player.teleport(loc);
                if (this.config.getBoolean("Items.recall_potion.Sound.Enabled")) {
                    String soundName = this.config.getString("Items.recall_potion.Sound.Sound");
                    float volume = (float)this.config.getDouble("Items.recall_potion.Sound.Volume");
                    float pitch = (float)this.config.getDouble("Items.recall_potion.Sound.Pitch");
                    Utils.playSound(loc, soundName, volume, pitch);
                }
            } else if (RSVItem.getNameFromItem(item).equals("wormhole_potion")) {
                player.openInventory(this.module.getInv().getInventory());
            }
        }
        UUID id = player.getUniqueId();
        RSVPlayer rsvPlayer = RSVPlayer.getPlayers().get(id);
        BaubleInventory inv = rsvPlayer.getBaubleDataModule().getBaubleBag();
        if (inv.hasBauble("gluttony_pendant")) {
            ((PotionBauble)TickableBaubleManager.GLUTTONY_PENDANT.getBauble()).ability(player, inv.getBaubleAmount("gluttony_pendant"));
        }
    }

    @EventHandler
    public void onItemAcquire(PlayerItemAcquireEvent event) {
        ItemStack item = event.getItem();
        EquipmentSlot loc = event.getLocation();
        if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).equals("stone_negative_gravity") || loc != EquipmentSlot.HAND && loc != EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (RSVPlayer.isValidPlayer(player) && player.isOnline() && !StoneNegativeGravityTask.hasTask(player.getUniqueId())) {
            new StoneNegativeGravityTask(this.module, RSVPlayer.getPlayers().get(player.getUniqueId()), this.plugin).start();
        }
    }
}

