/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;

public abstract class RSVModule {
    private static final Map<String, RSVModule> modules = new HashMap<String, RSVModule>();
    private final boolean configEnabled;
    private final boolean isGloballyEnabled;
    @Nonnull
    private final String name;
    @Nonnull
    private final Set<String> allowedWorlds = new HashSet<String>();
    @Nullable
    private ModuleItems moduleItems;
    @Nullable
    private ModuleRecipes moduleRecipes;
    @Nullable
    private RSVConfig userConfig;
    @Nullable
    private RSVConfig itemConfig;
    @Nullable
    private RSVConfig recipesConfig;
    @Nonnull
    private final Map<RSVModule, String> dependencies;
    @Nonnull
    private final Map<RSVModule, String> softDependencies;

    public RSVModule(@Nonnull String name, @Nonnull RSVPlugin plugin, @Nonnull Map<RSVModule, String> dependencies, @Nonnull Map<RSVModule, String> softDependencies) {
        FileConfiguration config = plugin.getConfig();
        this.name = name;
        this.dependencies = dependencies;
        this.softDependencies = softDependencies;
        this.configEnabled = config.getBoolean(name + ".Enabled");
        boolean bl = this.isGloballyEnabled = this.configEnabled && this.areDependenciesEnabled();
        if (this.isGloballyEnabled) {
            ConfigurationSection section = config.getConfigurationSection(name + ".Worlds");
            Set keys = section.getKeys(false);
            List<String> worlds = Utils.getAllWorldNames();
            boolean autoEnable = config.getBoolean("AutomaticallyEnableWorlds");
            for (String key : keys) {
                if (worlds.contains(key)) continue;
                config.set(name + ".Worlds." + key, null);
            }
            for (String worldName : worlds) {
                if (keys.contains(worldName)) {
                    if (!config.getBoolean(name + ".Worlds." + worldName)) continue;
                    this.allowedWorlds.add(worldName);
                    continue;
                }
                config.createSection(name + ".Worlds." + worldName);
                config.set(name + ".Worlds." + worldName, (Object)autoEnable);
                this.allowedWorlds.add(worldName);
            }
            this.getSoftDependencyErrorMessages().forEach(s -> plugin.getLogger().warning((String)s));
        } else if (this.configEnabled) {
            this.getDependencyErrorMessages().forEach(s -> plugin.getLogger().warning((String)s));
        }
        try {
            config.save(plugin.getConfigFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        modules.put(name, this);
    }

    public abstract void initialize();

    public abstract void shutdown();

    public boolean isGloballyEnabled() {
        return this.isGloballyEnabled;
    }

    public boolean isEnabled(@Nullable World world) {
        return this.isGloballyEnabled && (world == null || this.allowedWorlds.contains(world.getName()));
    }

    public boolean isEnabled(@Nullable Entity entity) {
        return this.isGloballyEnabled && (entity == null || this.allowedWorlds.contains(entity.getWorld().getName()));
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<String> getAllowedWorlds() {
        return this.allowedWorlds;
    }

    @Nullable
    public RSVConfig getUserConfig() {
        return this.userConfig;
    }

    public void setUserConfig(@Nullable RSVConfig config) {
        this.userConfig = config;
    }

    @Nullable
    public RSVConfig getItemConfig() {
        return this.itemConfig;
    }

    public void setItemConfig(@Nullable RSVConfig config) {
        this.itemConfig = config;
    }

    @Nullable
    public RSVConfig getRecipeConfig() {
        return this.recipesConfig;
    }

    public void setRecipeConfig(@Nullable RSVConfig config) {
        this.recipesConfig = config;
    }

    public void setModuleItems(@Nullable ModuleItems moduleItems) {
        this.moduleItems = moduleItems;
    }

    public void setModuleRecipes(@Nullable ModuleRecipes moduleRecipes) {
        this.moduleRecipes = moduleRecipes;
    }

    @Nullable
    public ModuleItems getModuleItems() {
        return this.moduleItems;
    }

    @Nullable
    public ModuleRecipes getModuleRecipes() {
        return this.moduleRecipes;
    }

    @Nonnull
    public static Map<String, RSVModule> getModules() {
        return modules;
    }

    public boolean areDependenciesEnabled() {
        for (Map.Entry<RSVModule, String> entry : this.dependencies.entrySet()) {
            if (entry.getKey() != null && entry.getKey().isGloballyEnabled) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getDependencyErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<RSVModule, String> entry : this.dependencies.entrySet()) {
            if (entry.getKey() != null && (entry.getKey().isGloballyEnabled || entry.getValue() == null)) continue;
            messages.add(Utils.translateMsg("[" + this.name + "] " + entry.getValue(), null, null));
        }
        return messages;
    }

    public Collection<String> getSoftDependencyErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<RSVModule, String> entry : this.softDependencies.entrySet()) {
            if (entry.getKey() != null && (entry.getKey().isGloballyEnabled || entry.getValue() == null)) continue;
            messages.add(Utils.translateMsg("[" + this.name + "] " + entry.getValue(), null, null));
        }
        return messages;
    }

    @Nullable
    public static RSVModule getModule(@Nonnull String name) {
        return modules.getOrDefault(name, null);
    }

    public boolean isConfigEnabled() {
        return this.configEnabled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RSVModule) {
            RSVModule module = (RSVModule)obj;
            return this.name.equals(module.name);
        }
        return false;
    }
}

