/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.integrations;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class CompatiblePlugin {
    private static final Map<String, CompatiblePlugin> plugins = new HashMap<String, CompatiblePlugin>();
    protected final FileConfiguration intConfig;
    protected final String name;
    protected final boolean isIntegrated;

    public CompatiblePlugin(@Nonnull RSVPlugin plugin, @Nonnull String name) {
        this.name = name;
        this.intConfig = plugin.getIntegrationsConfig();
        boolean bl = this.isIntegrated = this.intConfig.getBoolean(name + ".Enabled") && Bukkit.getServer().getPluginManager().isPluginEnabled(name) && this.otherLoadOptions();
        if (this.isIntegrated && this.intConfig.getBoolean("EnableIntegrationMessage")) {
            String message = Utils.translateMsg(plugin.getConfig().getString("Integration"), null, Map.of("PLUGIN", name));
            plugin.getLogger().info(message);
        }
        plugins.put(name, this);
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    public final boolean isIntegrated() {
        return this.isIntegrated;
    }

    public abstract boolean otherLoadOptions();

    @Nullable
    public static CompatiblePlugin getPlugin(@Nonnull String name) {
        return plugins.getOrDefault(name, null);
    }

    public static boolean isIntegrated(@Nonnull String name) {
        if (plugins.containsKey(name)) {
            return plugins.get(name) != null && plugins.get(name).isIntegrated();
        }
        return false;
    }
}

