/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.integrations;

import javax.annotation.Nonnull;
import me.casperge.realisticseasons.api.SeasonsAPI;
import me.val_mobile.data.RSVModule;
import me.val_mobile.integrations.CompatiblePlugin;
import me.val_mobile.rsv.RSVPlugin;
import org.bukkit.entity.Player;

public class RealisticSeasons
extends CompatiblePlugin {
    public static final String NAME = "RealisticSeasons";

    public RealisticSeasons(RSVPlugin plugin) {
        super(plugin, NAME);
    }

    @Override
    public boolean otherLoadOptions() {
        return me.casperge.realisticseasons.RealisticSeasons.getInstance().getTemperatureManager().getTempData().isEnabled() && RSVModule.getModule("ToughAsNails").isGloballyEnabled();
    }

    public int getTemperature(@Nonnull Player player) {
        int temp = SeasonsAPI.getInstance().getTemperature(player);
        if (me.casperge.realisticseasons.RealisticSeasons.getInstance().getTemperatureManager().hasFahrenheitEnabled(player)) {
            temp = (int)Math.round(0.5555555555555556 * (double)(temp - 32));
        }
        return temp;
    }

    public boolean hasTemperatureEnabled(Player player) {
        return me.casperge.realisticseasons.RealisticSeasons.getInstance().getTemperatureManager().hasTemperature(player);
    }

    public double getDefaultTemperature() {
        return this.intConfig.getDouble("RealisticSeasons.DefaultTemperature");
    }

    public double getColdMultiplier() {
        return this.intConfig.getDouble("RealisticSeasons.ColdMultiplier");
    }

    public double getHotMultiplier() {
        return this.intConfig.getDouble("RealisticSeasons.HotMultiplier");
    }

    public boolean disableHypothermiaCompletely() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hypothermia.DisableCompletely");
    }

    public boolean disableHypothermiaDamage() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hypothermia.DisableDamage");
    }

    public boolean disableHypothermiaPotions() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hypothermia.DisablePotionEffects");
    }

    public boolean disableHypothermiaTinting() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.VisualEffects.DisableColdScreenTinting");
    }

    public boolean disableHyperthermiaCompletely() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hyperthermia.DisableCompletely");
    }

    public boolean disableHyperthermiaDamage() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hyperthermia.DisableDamage");
    }

    public boolean disableHyperthermiaIgnite() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hyperthermia.DisableIgnite");
    }

    public boolean disableHyperthermiaPotions() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.Hyperthermia.DisablePotionEffects");
    }

    public boolean disableHyperthermiaTinting() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.VisualEffects.DisableHotScreenTinting");
    }

    public boolean disableColdBreath() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.VisualEffects.DisableColdBreath");
    }

    public boolean disableSweating() {
        return this.isIntegrated && this.intConfig.getBoolean("RealisticSeasons.VisualEffects.DisableSweating");
    }
}

