/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import me.val_mobile.data.ModuleEvents;
import me.val_mobile.data.RSVModule;
import me.val_mobile.misc.EntityItemAcquireEvent;
import me.val_mobile.misc.PlayerItemAcquireEvent;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanweaponry.EntityLongAttackTask;
import me.val_mobile.spartanweaponry.EntityPrepareThrowTask;
import me.val_mobile.spartanweaponry.SwModule;
import me.val_mobile.spartanweaponry.SweepAttackTask;
import me.val_mobile.spartanweaponry.ThrowWeaponTask;
import me.val_mobile.spartanweaponry.TwoHandedTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class SwEvents
extends ModuleEvents
implements Listener {
    private final RSVPlugin plugin;

    public SwEvents(SwModule module, RSVPlugin plugin) {
        super(module, plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityItemAcquire(EntityItemAcquireEvent event) {
        ItemStack item = event.getItem();
        EquipmentSlot loc = event.getLocation();
        LivingEntity entity = event.getEntity();
        if (entity.getEquipment() == null) {
            return;
        }
        if (!RSVItem.isRSVItem(item) || loc != EquipmentSlot.HAND && loc != EquipmentSlot.OFF_HAND) {
            return;
        }
        if (loc == EquipmentSlot.HAND && !Utils.isItemReal(entity.getEquipment().getItemInOffHand())) {
            return;
        }
        if (loc == EquipmentSlot.OFF_HAND && !Utils.isItemReal(entity.getEquipment().getItemInMainHand())) {
            return;
        }
        String name = RSVItem.getNameFromItem(item);
        if (!name.contains("_")) {
            return;
        }
        String type = name.substring(name.lastIndexOf("_") + 1);
        RSVModule module = RSVModule.getModule(RSVItem.getModuleNameFromItem(item));
        UUID id = entity.getUniqueId();
        if ((switch (type) {
            case "longsword", "katana", "warhammer", "battleaxe", "glaive" -> {
                if (!TwoHandedTask.hasTask(id)) {
                    new TwoHandedTask(module, this.plugin, entity, name).start();
                }
                yield false;
            }
            case "greatsword", "halberd", "pike" -> {
                if (!TwoHandedTask.hasTask(id)) {
                    new TwoHandedTask(module, this.plugin, entity, name).start();
                }
                if (!EntityLongAttackTask.hasTask(id) && loc == EquipmentSlot.HAND) {
                    new EntityLongAttackTask(RSVModule.getModule(RSVItem.getModuleNameFromItem(item)), this.plugin, entity, item, null).start();
                }
                yield false;
            }
            case "spear", "lance" -> {
                if (!EntityLongAttackTask.hasTask(id) && loc == EquipmentSlot.HAND) {
                    new EntityLongAttackTask(RSVModule.getModule(RSVItem.getModuleNameFromItem(item)), this.plugin, entity, item, null).start();
                }
                yield false;
            }
            case "dagger", "tomahawk", "javelin", "boomerang", "throwing_knife" -> true;
            default -> name.endsWith("throwing_knife");
        }) && !EntityPrepareThrowTask.hasTask(id)) {
            new EntityPrepareThrowTask(RSVModule.getModule(RSVItem.getModuleNameFromItem(item)), this.plugin, entity, item).start();
        }
    }

    @EventHandler
    public void onPlayerItemAcquire(PlayerItemAcquireEvent event) {
        ItemStack item = event.getItem();
        EquipmentSlot loc = event.getLocation();
        Player player = event.getPlayer();
        if (!RSVItem.isRSVItem(item) || loc != EquipmentSlot.HAND && loc != EquipmentSlot.OFF_HAND) {
            return;
        }
        if (loc == EquipmentSlot.HAND && !Utils.isItemReal(player.getInventory().getItemInOffHand())) {
            return;
        }
        if (loc == EquipmentSlot.OFF_HAND && !Utils.isItemReal(player.getInventory().getItemInMainHand())) {
            return;
        }
        String name = RSVItem.getNameFromItem(item);
        String type = name.substring(name.lastIndexOf("_") + 1);
        RSVModule module = RSVModule.getModule(RSVItem.getModuleNameFromItem(item));
        switch (type) {
            case "longsword": 
            case "katana": 
            case "greatsword": 
            case "warhammer": 
            case "halberd": 
            case "pike": 
            case "battleaxe": 
            case "glaive": {
                UUID id = player.getUniqueId();
                if (TwoHandedTask.hasTask(id)) break;
                new TwoHandedTask(module, this.plugin, (LivingEntity)player, name).start();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onShootBow(EntityShootBowEvent event) {
        ItemStack bow = event.getBow();
        if (!this.shouldEventBeRan((Entity)event.getEntity()) || !RSVItem.isRSVItem(bow)) {
            return;
        }
        Entity proj = event.getProjectile();
        String moduleName = RSVItem.getModuleNameFromItem(bow);
        if (!moduleName.equals("SpartanWeaponry") && !moduleName.equals("SpartanandFire")) {
            return;
        }
        FileConfiguration config = moduleName.equals("SpartanWeaponry") ? RSVModule.getModule("SpartanWeaponry").getUserConfig().getConfig() : RSVModule.getModule("SpartanandFire").getUserConfig().getConfig();
        String name = RSVItem.getNameFromItem(bow);
        if (!name.contains("_") || name.endsWith("_") || name.startsWith("_")) {
            return;
        }
        String type = name.substring(name.lastIndexOf("_") + 1);
        if (type.equals("longbow") || type.equals("crossbow")) {
            double multiplier = config.getDouble("Items." + name + ".ArrowVelocityMultiplier");
            proj.setVelocity(proj.getVelocity().multiply(multiplier));
            Utils.addNbtTag(proj, "rsvbow", name, PersistentDataType.STRING);
            event.setProjectile(proj);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        LivingEntity living;
        String moduleName;
        ItemStack itemMainHand;
        LivingEntity livingAttacker;
        Entity defender = event.getEntity();
        Entity attacker = event.getDamager();
        if (!this.shouldEventBeRan(defender) || !this.shouldEventBeRan(attacker)) {
            return;
        }
        double damage = event.getDamage();
        if (attacker instanceof AbstractArrow || attacker instanceof Firework) {
            ItemStack itemMainHand2;
            LivingEntity living2;
            ProjectileSource projectileSource;
            Projectile arrow = (Projectile)event.getDamager();
            if (arrow.getShooter() != null && (projectileSource = arrow.getShooter()) instanceof LivingEntity && (living2 = (LivingEntity)projectileSource).getEquipment() != null && RSVItem.isRSVItem(itemMainHand2 = living2.getEquipment().getItemInMainHand())) {
                FileConfiguration config = RSVModule.getModule(RSVItem.getModuleNameFromItem(itemMainHand2)).getUserConfig().getConfig();
                String name = RSVItem.getNameFromItem(itemMainHand2);
                String type = name.substring(name.lastIndexOf("_") + 1);
                if (type.equals("longbow") || type.equals("crossbow")) {
                    double multiplier = config.getDouble("Items." + name + ".AttackDamageMultiplier");
                    damage *= multiplier;
                }
            }
        } else if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).getEquipment() != null && RSVItem.isRSVItem(itemMainHand = livingAttacker.getEquipment().getItemInMainHand()) && ((moduleName = RSVItem.getModuleNameFromItem(itemMainHand)).equals("SpartanWeaponry") || moduleName.equals("SpartanandFire"))) {
            String type;
            FileConfiguration config = RSVModule.getModule(moduleName).getUserConfig().getConfig();
            String name = RSVItem.getNameFromItem(itemMainHand);
            switch (type = name.substring(name.lastIndexOf("_") + 1)) {
                case "rapier": {
                    if (Utils.hasArmor(defender)) break;
                    damage *= config.getDouble("Items." + name + ".UnarmoredDamageMultiplier");
                    break;
                }
                case "katana": {
                    if (Utils.hasChestplate(defender)) break;
                    damage *= config.getDouble("Items." + name + ".ChestDamageMultiplier");
                    break;
                }
                case "dagger": {
                    if (!Utils.wasBackstabbed(attacker, defender)) break;
                    damage *= config.getDouble("Items." + name + ".BackstabDamageMultiplier");
                    break;
                }
                case "lance": {
                    double sweepMultiplier = config.getDouble("Items." + name + ".SweepingDamageMultiplier");
                    double ridingMultiplier = config.getDouble("Items." + name + ".RidingDamageBonus");
                    if (attacker.getVehicle() != null) {
                        damage *= ridingMultiplier;
                    }
                    List entities = defender.getNearbyEntities(1.0, 0.25, 1.0);
                    if (!config.getBoolean("Items." + name + ".Sweep")) break;
                    new SweepAttackTask(this.plugin, entities, attacker, defender, damage * sweepMultiplier, config.getBoolean("PreventSweepAttackingPets")).start();
                    break;
                }
                case "greatsword": 
                case "longsword": 
                case "saber": 
                case "glaive": 
                case "quarterstaff": {
                    List entities = defender.getNearbyEntities(1.0, 0.25, 1.0);
                    double multiplier = config.getDouble("Items." + name + ".SweepingDamageMultiplier");
                    if (!config.getBoolean("Items." + name + ".Sweep")) break;
                    new SweepAttackTask(this.plugin, entities, attacker, defender, damage * multiplier, config.getBoolean("PreventSweepAttackingPets")).start();
                    break;
                }
                case "hammer": {
                    if (defender instanceof LivingEntity) {
                        LivingEntity living3 = (LivingEntity)defender;
                        int duration = config.getInt("Items." + name + ".Nausea.Duration");
                        int amplifier = config.getInt("Items." + name + ".Nausea.Amplifier");
                        PotionEffect nausea = new PotionEffect(PotionEffectType.CONFUSION, duration, amplifier);
                        if (living3.getEquipment() != null) {
                            if (!Utils.isItemReal(living3.getEquipment().getHelmet())) {
                                living3.addPotionEffect(nausea);
                            }
                        } else {
                            living3.addPotionEffect(nausea);
                        }
                    }
                    double kbMultiplier = config.getDouble("Items." + name + ".KnockbackMultiplier");
                    Utils.setKbMultiplier(defender, kbMultiplier);
                    break;
                }
                case "warhammer": {
                    double armorPiercing = config.getDouble("Items." + name + ".ArmorPiercing");
                    double dif = event.getFinalDamage() - event.getDamage();
                    damage += dif * armorPiercing;
                    break;
                }
                case "club": {
                    if (!(defender instanceof LivingEntity)) break;
                    LivingEntity living4 = (LivingEntity)defender;
                    int duration = config.getInt("Items." + name + ".Nausea.Duration");
                    int amplifier = config.getInt("Items." + name + ".Nausea.Amplifier");
                    PotionEffect nausea = new PotionEffect(PotionEffectType.CONFUSION, duration, amplifier);
                    if (living4.getEquipment() != null) {
                        if (Utils.isItemReal(living4.getEquipment().getHelmet())) break;
                        living4.addPotionEffect(nausea);
                        break;
                    }
                    living4.addPotionEffect(nausea);
                    break;
                }
                case "halberd": {
                    Player player;
                    int shieldCooldown = config.getInt("Items." + name + ".ShieldBreach.Cooldown");
                    double chance = config.getDouble("Items." + name + ".ShieldBreach.Chance");
                    if (!(defender instanceof Player) || !(player = (Player)defender).isBlocking() || !Utils.roll(chance)) break;
                    player.setCooldown(Material.SHIELD, shieldCooldown);
                    break;
                }
                case "mace": {
                    if (!(defender instanceof LivingEntity) || !Utils.isUndead(defender)) break;
                    damage *= config.getDouble("Items." + name + ".UndeadDamageMultiplier");
                    break;
                }
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK && !config.getBoolean("Items." + name + ".Sweep")) {
                event.setCancelled(true);
            }
        }
        if (defender instanceof LivingEntity && (living = (LivingEntity)defender).getEquipment() != null && RSVItem.isRSVItem(itemMainHand = living.getEquipment().getItemInMainHand())) {
            FileConfiguration config = RSVModule.getModule(RSVItem.getModuleNameFromItem(itemMainHand)).getUserConfig().getConfig();
            String name = RSVItem.getNameFromItem(itemMainHand);
            String type = name.substring(name.lastIndexOf("_") + 1);
            if (type.equals("saber") || type.equals("rapier")) {
                double multiplier = 1.0 - config.getDouble("Items." + name + ".Protection.PercentAbsorbed");
                int decrement = config.getInt("Items." + name + ".Protection.DamageDurability");
                damage *= multiplier;
                Utils.changeDurability(itemMainHand, -decrement, true, true, defender);
            }
        }
        event.setDamage(damage);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTarget(EntityTargetEvent event) {
        String type;
        LivingEntity living;
        Entity target;
        block24: {
            block23: {
                Entity entity = event.getEntity();
                target = event.getTarget();
                if (target == null || !this.shouldEventBeRan(entity) || !this.shouldEventBeRan(target) || !(entity instanceof LivingEntity)) break block23;
                living = (LivingEntity)entity;
                if (!(entity instanceof Player) && living.getEquipment() != null) break block24;
            }
            return;
        }
        ItemStack itemMainHand = living.getEquipment().getItemInMainHand();
        if (!RSVItem.isRSVItem(itemMainHand)) {
            return;
        }
        String name = RSVItem.getNameFromItem(itemMainHand);
        if (!name.contains("_")) {
            return;
        }
        if ((switch (type = name.substring(name.lastIndexOf("_") + 1)) {
            case "greatsword", "spear", "halberd", "pike", "lance" -> {
                if (!EntityLongAttackTask.hasTask(living.getUniqueId())) {
                    new EntityLongAttackTask(RSVModule.getModule(RSVItem.getModuleNameFromItem(itemMainHand)), this.plugin, living, itemMainHand, target).start();
                }
                yield false;
            }
            case "dagger", "tomahawk", "javelin", "boomerang", "throwing_knife" -> true;
            default -> name.endsWith("throwing_knife");
        }) && !EntityPrepareThrowTask.hasTask(living.getUniqueId())) {
            new EntityPrepareThrowTask(RSVModule.getModule(RSVItem.getModuleNameFromItem(itemMainHand)), this.plugin, living, itemMainHand).start();
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        ItemStack itemMainHand = player.getInventory().getItemInMainHand();
        if (!RSVItem.isRSVItem(itemMainHand)) {
            return;
        }
        String name = RSVItem.getNameFromItem(itemMainHand);
        if (!name.contains("_")) {
            return;
        }
        String type = name.substring(name.lastIndexOf("_") + 1);
        RSVModule module = RSVModule.getModule(RSVItem.getModuleNameFromItem(itemMainHand));
        if (module.getUserConfig() == null) {
            return;
        }
        FileConfiguration config = module.getUserConfig().getConfig();
        boolean isThrowing = false;
        switch (type) {
            case "greatsword": 
            case "spear": 
            case "halberd": 
            case "pike": 
            case "lance": {
                Entity defender;
                double range = config.getDouble("Items." + name + ".Reach");
                Location eye = player.getEyeLocation();
                Predicate<Entity> filter = entity -> !entity.getUniqueId().equals(player.getUniqueId());
                RayTraceResult result = player.getWorld().rayTrace(eye, eye.getDirection(), range, FluidCollisionMode.NEVER, false, 0.0, filter);
                if (result == null || (defender = result.getHitEntity()) == null) break;
                Utils.attack((LivingEntity)player, defender);
                break;
            }
            case "dagger": 
            case "tomahawk": 
            case "javelin": 
            case "boomerang": 
            case "throwing_knife": {
                isThrowing = !player.isSneaking();
                break;
            }
            default: {
                boolean bl = isThrowing = name.endsWith("throwing_knife") && !player.isSneaking();
            }
        }
        if (!isThrowing) {
            return;
        }
        boolean rotateWeapon = config.getBoolean("Items." + name + ".ThrownAttributes.Rotate");
        boolean returnWeaponCollideBlocks = config.getBoolean("Items." + name + ".ThrownAttributes.ReturnAfterHittingBlock");
        boolean returnWeaponCollideEntities = config.getBoolean("Items." + name + ".ThrownAttributes.ReturnAfterHittingEntity");
        boolean returnWeaponTooFar = config.getBoolean("Items." + name + ".ThrownAttributes.ReturnAfterTravelingMaxDistance");
        boolean piercing = config.getBoolean("Items." + name + ".ThrownAttributes.Piercing");
        double maxDistance = config.getDouble("Items." + name + ".ThrownAttributes.MaxDistance");
        Location loc = player.getEyeLocation().add(player.getLocation().getDirection());
        Vector velocity = loc.getDirection().normalize().multiply(config.getDouble("Items." + name + ".ThrownAttributes.Velocity"));
        Utils.changeDurability(itemMainHand, -1, true, true, (Entity)player);
        if (Utils.isItemReal(itemMainHand) && Utils.getDurability(itemMainHand) >= 0) {
            new ThrowWeaponTask(module, this.plugin, (LivingEntity)player, itemMainHand, maxDistance, rotateWeapon, piercing, returnWeaponCollideBlocks, returnWeaponCollideEntities, returnWeaponTooFar, velocity).start();
        }
        player.getInventory().setItemInMainHand(null);
    }
}

