/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.data.toughasnails.DataModule;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TemperatureCalculateTask;
import me.val_mobile.utils.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TempManager {
    private final TanModule module;

    public TempManager(TanModule module) {
        this.module = module;
    }

    public boolean isTempEnabled(@Nullable Player player) {
        return this.module.isTempGloballyEnabled() && RSVPlayer.isValidPlayer(player) && this.module.isEnabled((Entity)player) && RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule() != null;
    }

    public double getTemperature(@Nullable Player player) {
        if (this.isTempEnabled(player)) {
            if (TemperatureCalculateTask.hasTask(player.getUniqueId())) {
                return TemperatureCalculateTask.getTasks().get(player.getUniqueId()).getTemp();
            }
            DataModule module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule();
            if (module != null) {
                return module.getTemperature();
            }
        }
        return 0.0;
    }

    public void setTemperature(@Nullable Player player, double temperature) {
        if (this.isTempEnabled(player)) {
            DataModule module;
            temperature = Utils.clamp(temperature, 0.0, 25.0);
            if (TemperatureCalculateTask.hasTask(player.getUniqueId())) {
                TemperatureCalculateTask.getTasks().get(player.getUniqueId()).setTemp(temperature);
            }
            if ((module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule()) != null) {
                module.setTemperature(temperature);
            }
        }
    }

    public void addTemperature(@Nullable Player player, double addition) {
        if (this.isTempEnabled(player)) {
            DataModule module;
            double temperature = Utils.clamp(this.getTemperature(player) + addition, 0.0, 25.0);
            if (TemperatureCalculateTask.hasTask(player.getUniqueId())) {
                TemperatureCalculateTask.getTasks().get(player.getUniqueId()).setTemp(temperature);
            }
            if ((module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule()) != null) {
                module.setTemperature(temperature);
            }
        }
    }
}

