/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.Arrays;
import java.util.List;
import me.val_mobile.iceandfire.Dragon;
import me.val_mobile.iceandfire.DragonBreed;
import me.val_mobile.iceandfire.DragonGender;
import me.val_mobile.iceandfire.DragonVariant;
import me.val_mobile.utils.Utils;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public abstract class Dragon_v1_21_R5
extends EntityEnderDragon
implements Dragon {
    private final DragonBreed breed;
    private int stage;
    private int age;
    private final DragonGender gender;
    private final DragonVariant variant;

    public Dragon_v1_21_R5(EntityTypes<? extends EntityEnderDragon> entityType, World world, DragonBreed breed) {
        super(entityType, world);
        List<DragonVariant> enabledVariants = DragonVariant.getEnabledVariants(breed);
        this.variant = enabledVariants.get(Utils.getRandomNum(0, enabledVariants.size() - 1));
        this.breed = breed;
        this.stage = Utils.getRandomNum(1, 5);
        this.age = Utils.getRandomNum(this.stage * 100, this.stage * 100 + 99);
        this.gender = Utils.getRandomNum(0, 1) == 1 ? DragonGender.MALE : DragonGender.FEMALE;
        this.setup();
    }

    public Dragon_v1_21_R5(Location loc, DragonBreed breed) {
        super(EntityTypes.P, (World)((CraftWorld)loc.getWorld()).getHandle());
        this.a_(loc.getX(), loc.getY(), loc.getZ());
        List<DragonVariant> enabledVariants = DragonVariant.getEnabledVariants(breed);
        this.variant = enabledVariants.get(Utils.getRandomNum(0, enabledVariants.size() - 1));
        this.breed = breed;
        this.stage = Utils.getRandomNum(1, 5);
        this.age = Utils.getRandomNum(this.stage * 100, this.stage * 100 + 99);
        this.gender = Utils.getRandomNum(0, 1) == 1 ? DragonGender.MALE : DragonGender.FEMALE;
        this.setup();
    }

    public Dragon_v1_21_R5(Location loc, DragonBreed breed, DragonVariant variant) {
        super(EntityTypes.P, (World)((CraftWorld)loc.getWorld()).getHandle());
        this.a_(loc.getX(), loc.getY(), loc.getZ());
        this.variant = variant.isEnabled() && Arrays.asList(breed.getVariants()).contains((Object)variant) ? variant : null;
        this.breed = breed;
        this.stage = Utils.getRandomNum(1, 5);
        this.age = Utils.getRandomNum(this.stage * 100, this.stage * 100 + 99);
        this.gender = Utils.getRandomNum(0, 1) == 1 ? DragonGender.MALE : DragonGender.FEMALE;
        this.setup();
    }

    public Dragon_v1_21_R5(Location loc, DragonBreed breed, int stage) {
        super(EntityTypes.P, (World)((CraftWorld)loc.getWorld()).getHandle());
        this.a_(loc.getX(), loc.getY(), loc.getZ());
        List<DragonVariant> enabledVariants = DragonVariant.getEnabledVariants(breed);
        this.variant = enabledVariants.get(Utils.getRandomNum(0, enabledVariants.size() - 1));
        this.breed = breed;
        this.stage = stage;
        this.age = Utils.getRandomNum(stage * 100, stage * 100 + 99);
        this.gender = Utils.getRandomNum(0, 1) == 1 ? DragonGender.MALE : DragonGender.FEMALE;
        this.setup();
    }

    public Dragon_v1_21_R5(Location loc, DragonBreed breed, DragonVariant variant, int stage) {
        super(EntityTypes.P, (World)((CraftWorld)loc.getWorld()).getHandle());
        this.a_(loc.getX(), loc.getY(), loc.getZ());
        this.variant = variant.isEnabled() && Arrays.asList(breed.getVariants()).contains((Object)variant) ? variant : null;
        this.breed = breed;
        this.stage = stage;
        this.age = Utils.getRandomNum(stage * 100, stage * 100 + 99);
        this.gender = Utils.getRandomNum(0, 1) == 1 ? DragonGender.MALE : DragonGender.FEMALE;
        this.setup();
    }

    @Override
    public void addEntityToWorld(org.bukkit.World world) {
        ((CraftWorld)world).addEntity((net.minecraft.world.entity.Entity)this, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public Entity getEntity() {
        return this.getBukkitEntity();
    }

    @Override
    public DragonBreed getBreed() {
        return this.breed;
    }

    @Override
    public DragonVariant getVariant() {
        return this.variant;
    }

    @Override
    public int getStage() {
        return this.stage;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public DragonGender getGender() {
        return this.gender;
    }

    @Override
    public void setStage(int stage) {
        this.stage = stage;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }
}

