/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.ToolHandler;
import me.val_mobile.utils.v1_17;
import org.bukkit.Material;
import org.bukkit.Tag;

public class ToolUtils {
    final String[] wood = new String[]{"BIRCH", "ACACIA", "OAK", "DARK_OAK", "SPRUCE", "JUNGLE"};
    final String[] weapons = new String[]{"BOW", "CROSSBOW", "TRIDENT", "NETHERITE_SWORD", "DIAMOND_SWORD", "GOLDEN_SWORD", "IRON_SWORD", "STONE_SWORD", "WOODEN_SWORD"};
    final String[] instaBreakableByHand = new String[]{"COMPARATOR", "REPEATER", "REDSTONE_WIRE", "REDSTONE_TORCH", "REDSTONE_WALL_TORCH", "TORCH", "SOUL_TORCH", "WALL_TORCH", "SOUL_WALL_TORCH", "SCAFFOLDING", "SLIME_BLOCK", "HONEY_BLOCK", "TNT", "TRIPWIRE", "TRIPWIRE_HOOK", "GRASS", "TALL_GRASS", "HANGING_ROOTS", "KELP", "NETHER_SPROUTS", "PINK_PETALS", "SPORE_BLOSSOM", "SWEET_BERRY_BUSH`", "PITCHER_PLANT", "PITCHER_POD", "SUGAR_CANE", "LILY_PAD", "OAK_SAPLING", "SPRUCE_SAPLING", "BIRCH_SAPLING", "JUNGLE_SAPLING", "ACACIA_SAPLING", "DARK_OAK_SAPLING", "MANGROVE_PROPAGULE", "CHERRY_SAPLING", "PALE_OAK_SAPLING", "BROWN_MUSHROOM", "RED_MUSHROOM", "CRIMSON_FUNGUS", "WARPED_FUNGUS", "CRIMSON_ROOTS", "WARPED_ROOTS", "WEEPING VINES", "TWISTING_VINES", "DEAD_BUSH", "WHEAT", "CARROTS", "POTATOES", "BEETROOTS", "PUMPKIN_STEM", "MELON_STEM", "NETHER_WART", "FERN", "LARGE_FERN", "FLOWER_POT", "DECORATED_POT", "FROGSPAWN", "AZALEA", "DANDELION", "POPPY", "BLUE_ORCHID", "ALLIUM", "AZURE_BLUET", "RED_TULIP", "ORANGE_TULIP", "WHITE_TULIP", "PINK_TULIP", "OXEYE_DAISY", "CORNFLOWER", "LILY_OF_THE_VALLEY", "WITHER_ROSE", "SUNFLOWER", "LILAC", "ROSE_BUSH", "PEONY", "POTTED_DANDELION", "POTTED_POPPY", "POTTED_BLUE_ORCHID", "POTTED_ALLIUM", "POTTED_AZURE_BLUET", "POTTED_RED_TULIP", "POTTED_ORANGE_TULIP", "POTTED_WHITE_TULIP", "POTTED_PINK_TULIP", "POTTED_OXEYE_DAISY", "POTTED_CORNFLOWER", "POTTED_LILY_OF_THE_VALLEY", "POTTED_WITHER_ROSE", "POTTED_SUNFLOWER", "POTTED_LILAC", "POTTED_ROSE_BUSH", "POTTED_PEONY", "POTTED_FERN", "TUBE_CORAL", "BRAIN_CORAL", "BUBBLE_CORAL", "FIRE_CORAL", "HORN_CORAL", "DEAD_TUBE_CORAL", "DEAD_BRAIN_CORAL", "DEAD_BUBBLE_CORAL", "DEAD_FIRE_CORAL", "DEAD_HORN_CORAL", "FIRE", "SOUL_FIRE"};
    final String[] hoes = new String[]{"NETHERITE_HOE", "DIAMOND_HOE", "GOLDEN_HOE", "IRON_HOE", "STONE_HOE", "WOODEN_HOE"};
    final String[] pickaxes = new String[]{"NETHERITE_PICKAXE", "DIAMOND_PICKAXE", "GOLDEN_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "WOODEN_PICKAXE"};
    final String[] axes = new String[]{"NETHERITE_AXE", "DIAMOND_AXE", "GOLDEN_AXE", "IRON_AXE", "STONE_AXE", "WOODEN_AXE"};
    final String[] shovels = new String[]{"NETHERITE_SHOVEL", "DIAMOND_SHOVEL", "GOLDEN_SHOVEL", "IRON_SHOVEL", "STONE_SHOVEL", "WOODEN_SHOVEL"};
    final String[] swords = new String[]{"NETHERITE_SWORD", "DIAMOND_SWORD", "GOLDEN_SWORD", "IRON_SWORD", "STONE_SWORD", "WOODEN_SWORD"};
    final Material[] defaultMats = new Material[]{Material.DIAMOND_PICKAXE, Material.DIAMOND_AXE, Material.DIAMOND_HOE, Material.DIAMOND_SHOVEL, Material.GOLDEN_PICKAXE, Material.GOLDEN_AXE, Material.GOLDEN_HOE, Material.GOLDEN_SHOVEL, Material.IRON_PICKAXE, Material.IRON_AXE, Material.IRON_HOE, Material.IRON_SHOVEL, Material.STONE_PICKAXE, Material.STONE_AXE, Material.STONE_HOE, Material.STONE_SHOVEL, Material.WOODEN_PICKAXE, Material.WOODEN_AXE, Material.WOODEN_HOE, Material.WOODEN_SHOVEL, Material.SHEARS};
    final String[] netheriteTools = new String[]{"NETHERITE_PICKAXE", "NETHERITE_AXE", "NETHERITE_HOE", "NETHERITE_SHOVEL"};
    private final RSVPlugin plugin;

    public ToolUtils(RSVPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Main must not be null");
        Objects.requireNonNull(plugin.getToolHandler(), "ToolsHandler must be instantiated before ToolUtils!");
        ToolHandler handler = plugin.getToolHandler();
        for (String weapon : this.weapons) {
            if (Material.getMaterial((String)weapon) == null) continue;
            handler.weapons.add(Material.getMaterial((String)weapon));
        }
        for (String s : this.instaBreakableByHand) {
            this.addToMap(s, handler.instaBreakableByHand);
        }
        for (String s : this.hoes) {
            this.addToMap(s, handler.hoes);
        }
        for (String s : this.pickaxes) {
            this.addToMap(s, handler.pickaxes);
        }
        for (String s : this.axes) {
            this.addToMap(s, handler.axes);
        }
        for (String s : this.shovels) {
            this.addToMap(s, handler.shovels);
        }
        for (String s : this.swords) {
            this.addToMap(s, handler.swords);
        }
        handler.allTools.addAll(Arrays.asList(this.defaultMats));
        for (String s : this.netheriteTools) {
            if (Material.getMaterial((String)s) == null) continue;
            handler.allTools.add(Material.getMaterial((String)s));
        }
        try {
            for (Material mat : v1_17.getPickaxeMaterials()) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addToMap(String name, List<Material> list) {
        Material mat = Material.getMaterial((String)name);
        if (mat != null) {
            list.add(mat);
        }
    }

    private void tagToMap(Tag<Material> tag, ToolHandler.Tool tool) {
        this.tagToMap(Objects.requireNonNull(tag, "Tag must not be null"), Objects.requireNonNull(tool, "Tool must not be null"), null);
    }

    private void tagToMap(Tag<Material> tag, ToolHandler.Tool tool, String match) {
        Objects.requireNonNull(tag, "Tag must not be null");
        Objects.requireNonNull(tool, "Tool must not be null");
        for (Material mat : tag.getValues()) {
            if (match == null) {
                this.addToMap(mat, tool);
                continue;
            }
            if (!mat.name().contains(match)) continue;
            this.addToMap(mat, tool);
        }
    }

    private void addToMap(String matName, ToolHandler.Tool tool) {
        Material mat = Material.getMaterial((String)matName);
        if (mat == null) {
            return;
        }
        this.addToMap(mat, tool);
    }

    private void addToMap(Material mat, ToolHandler.Tool tool) {
        Objects.requireNonNull(Objects.requireNonNull(this.plugin.getToolHandler(), (String)"ToolHandler must not be null").toolMap, "ToolMap must not be null").put(Objects.requireNonNull(mat, "Material must not be null"), Objects.requireNonNull(tool, "Tool must not be null"));
    }

    public void initMap() {
        this.initFallbackMaterials();
        this.tagToMap((Tag<Material>)Tag.ANVIL, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.ICE, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.LEAVES, ToolHandler.Tool.SHEARS);
        this.tagToMap((Tag<Material>)Tag.LOGS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.PLANKS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.RAILS, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.WOOL, ToolHandler.Tool.SHEARS);
        this.tagToMap((Tag<Material>)Tag.BUTTONS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.BUTTONS, ToolHandler.Tool.PICKAXE, "STONE");
        this.tagToMap((Tag<Material>)Tag.DOORS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.DOORS, ToolHandler.Tool.PICKAXE, "IRON");
        this.tagToMap((Tag<Material>)Tag.TRAPDOORS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.TRAPDOORS, ToolHandler.Tool.PICKAXE, "IRON");
        this.tagToMap((Tag<Material>)Tag.SLABS, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.WOODEN_SLABS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.STAIRS, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.WOODEN_STAIRS, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.SAND, ToolHandler.Tool.SHOVEL);
        this.tagToMap((Tag<Material>)Tag.STONE_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SEAGRASS, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.TALL_SEAGRASS, ToolHandler.Tool.SHEARS);
        this.tagToMap((Tag<Material>)Tag.BAMBOO_PLANTABLE_ON, ToolHandler.Tool.SHOVEL);
        this.tagToMap((Tag<Material>)Tag.SIGNS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.WALLS, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.FENCES, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.FENCES, ToolHandler.Tool.PICKAXE, "NETHER");
        this.tagToMap((Tag<Material>)Tag.FENCES, ToolHandler.Tool.PICKAXE, "BRICK");
        for (Material mat : Tag.BAMBOO_PLANTABLE_ON.getValues()) {
            this.addToMap(mat, ToolHandler.Tool.SHOVEL);
        }
        this.tagToMap((Tag<Material>)Tag.BEEHIVES, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.SHULKER_BOXES, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.CROPS, ToolHandler.Tool.NONE);
        this.tagToMap((Tag<Material>)Tag.FLOWERS, ToolHandler.Tool.NONE);
        this.tagToMap((Tag<Material>)Tag.CRIMSON_STEMS, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.FENCE_GATES, ToolHandler.Tool.AXE);
        this.tagToMap((Tag<Material>)Tag.NYLIUM, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.PRESSURE_PLATES, ToolHandler.Tool.PICKAXE);
        this.tagToMap((Tag<Material>)Tag.WOODEN_PRESSURE_PLATES, ToolHandler.Tool.AXE);
        this.addToMap(Material.WARPED_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.CRIMSON_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.BONE_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BASALT, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.POLISHED_BASALT, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GLOWSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_GOLD_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SPONGE, ToolHandler.Tool.HOE);
        this.addToMap(Material.WET_SPONGE, ToolHandler.Tool.HOE);
        this.addToMap(Material.PISTON, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STICKY_PISTON, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.PISTON_HEAD, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.MOVING_PISTON, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CHORUS_PLANT, ToolHandler.Tool.AXE);
        this.addToMap(Material.CHORUS_FLOWER, ToolHandler.Tool.AXE);
        this.addToMap(Material.CARVED_PUMPKIN, ToolHandler.Tool.AXE);
        this.addToMap(Material.HAY_BLOCK, ToolHandler.Tool.HOE);
        this.addToMap(Material.OBSERVER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_WART_BLOCK, ToolHandler.Tool.HOE);
        this.addToMap(Material.WARPED_WART_BLOCK, ToolHandler.Tool.HOE);
        this.addToMap(Material.MAGMA_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.TARGET, ToolHandler.Tool.HOE);
        this.addToMap(Material.SHROOMLIGHT, ToolHandler.Tool.HOE);
        this.addToMap(Material.BELL, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONECUTTER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SMITHING_TABLE, ToolHandler.Tool.AXE);
        this.addToMap(Material.LECTERN, ToolHandler.Tool.AXE);
        this.addToMap(Material.GRINDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.FLETCHING_TABLE, ToolHandler.Tool.AXE);
        this.addToMap(Material.CARTOGRAPHY_TABLE, ToolHandler.Tool.AXE);
        this.addToMap(Material.BLAST_FURNACE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SMOKER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BARREL, ToolHandler.Tool.AXE);
        this.addToMap(Material.COMPOSTER, ToolHandler.Tool.AXE);
        this.addToMap(Material.LOOM, ToolHandler.Tool.AXE);
        this.addToMap(Material.DRIED_KELP_BLOCK, ToolHandler.Tool.HOE);
        this.addToMap(Material.ACACIA_BUTTON, ToolHandler.Tool.AXE);
        this.addToMap(Material.ACACIA_FENCE, ToolHandler.Tool.AXE);
        this.addToMap(Material.ACACIA_FENCE_GATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.ACACIA_LEAVES, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.ACACIA_PRESSURE_PLATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.ACACIA_SLAB, ToolHandler.Tool.AXE);
        this.addToMap(Material.ACACIA_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.ANCIENT_DEBRIS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.ANDESITE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BASALT, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BIRCH_BUTTON, ToolHandler.Tool.AXE);
        this.addToMap(Material.BIRCH_FENCE, ToolHandler.Tool.AXE);
        this.addToMap(Material.BIRCH_FENCE_GATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.BIRCH_LEAVES, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.BIRCH_PRESSURE_PLATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.BIRCH_SLAB, ToolHandler.Tool.AXE);
        this.addToMap(Material.BIRCH_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.BLACKSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BLACKSTONE_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BLACKSTONE_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BLACK_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BLACK_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.BLUE_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BLUE_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.BOOKSHELF, ToolHandler.Tool.AXE);
        this.addToMap(Material.BREWING_STAND, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BRICK_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BRICK_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BROWN_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.BROWN_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.BROWN_MUSHROOM_BLOCK, ToolHandler.Tool.AXE);
        this.addToMap(Material.CAMPFIRE, ToolHandler.Tool.AXE);
        this.addToMap(Material.CAULDRON, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CHAIN, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CHEST, ToolHandler.Tool.AXE);
        this.addToMap(Material.CHISELED_RED_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CHISELED_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CHISELED_STONE_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CLAY, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.COAL_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.COAL_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.COARSE_DIRT, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.COBBLESTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.COBBLESTONE_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.COBBLESTONE_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.COBWEB, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.COCOA, ToolHandler.Tool.AXE);
        this.addToMap(Material.CRACKED_STONE_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CRAFTING_TABLE, ToolHandler.Tool.AXE);
        this.addToMap(Material.CRYING_OBSIDIAN, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CUT_RED_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CUT_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CYAN_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.CYAN_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.DARK_OAK_BUTTON, ToolHandler.Tool.AXE);
        this.addToMap(Material.DARK_OAK_FENCE, ToolHandler.Tool.AXE);
        this.addToMap(Material.DARK_OAK_FENCE_GATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.DARK_OAK_LEAVES, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.DARK_OAK_PRESSURE_PLATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.DARK_OAK_SLAB, ToolHandler.Tool.AXE);
        this.addToMap(Material.DARK_OAK_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.DARK_PRISMARINE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DARK_PRISMARINE_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DARK_PRISMARINE_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DAYLIGHT_DETECTOR, ToolHandler.Tool.AXE);
        this.addToMap(Material.DIAMOND_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DIAMOND_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DIORITE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DIRT, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.DISPENSER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.DROPPER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.EMERALD_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.EMERALD_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.ENCHANTING_TABLE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.ENDER_CHEST, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.END_STONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.FARMLAND, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.FURNACE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GILDED_BLACKSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GOLD_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GOLD_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GRANITE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GRASS_BLOCK, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.DIRT_PATH, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.GRAVEL, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.GRAY_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GRAY_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.GREEN_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.GREEN_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.HEAVY_WEIGHTED_PRESSURE_PLATE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.HOPPER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.IRON_BARS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.IRON_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.IRON_DOOR, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.IRON_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.IRON_TRAPDOOR, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.JACK_O_LANTERN, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUKEBOX, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUNGLE_BUTTON, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUNGLE_FENCE, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUNGLE_FENCE_GATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUNGLE_LEAVES, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.JUNGLE_PRESSURE_PLATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUNGLE_SLAB, ToolHandler.Tool.AXE);
        this.addToMap(Material.JUNGLE_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.LADDER, ToolHandler.Tool.AXE);
        this.addToMap(Material.LANTERN, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LAPIS_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LAPIS_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LIGHT_BLUE_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LIGHT_BLUE_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.LIGHT_GRAY_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LIGHT_GRAY_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.LIGHT_WEIGHTED_PRESSURE_PLATE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LIME_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.LIME_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.LODESTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.MAGENTA_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.MAGENTA_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.MELON, ToolHandler.Tool.AXE);
        this.addToMap(Material.MOSSY_COBBLESTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.MOSSY_STONE_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.MUSHROOM_STEM, ToolHandler.Tool.AXE);
        this.addToMap(Material.MYCELIUM, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.NETHERITE_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHERRACK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_BRICK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_BRICK_FENCE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_BRICK_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_BRICK_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NETHER_QUARTZ_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.NOTE_BLOCK, ToolHandler.Tool.AXE);
        this.addToMap(Material.OAK_BUTTON, ToolHandler.Tool.AXE);
        this.addToMap(Material.OAK_FENCE, ToolHandler.Tool.AXE);
        this.addToMap(Material.OAK_FENCE_GATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.OAK_LEAVES, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.OAK_PRESSURE_PLATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.OAK_SLAB, ToolHandler.Tool.AXE);
        this.addToMap(Material.OAK_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.OBSIDIAN, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.ORANGE_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.ORANGE_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.PINK_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.PINK_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.PODZOL, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.POLISHED_ANDESITE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.POLISHED_DIORITE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.POLISHED_GRANITE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.PUMPKIN, ToolHandler.Tool.AXE);
        this.addToMap(Material.PURPLE_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.PURPLE_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.QUARTZ_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.QUARTZ_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.REDSTONE_BLOCK, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.REDSTONE_ORE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.RED_MUSHROOM_BLOCK, ToolHandler.Tool.AXE);
        this.addToMap(Material.RED_NETHER_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_NETHER_BRICK_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_NETHER_BRICK_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_SAND, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.RED_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_SANDSTONE_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RED_SANDSTONE_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.RESPAWN_ANCHOR, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SAND, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SANDSTONE_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SANDSTONE_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SEA_LANTERN, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SMOOTH_QUARTZ, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SMOOTH_RED_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SMOOTH_SANDSTONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SMOOTH_STONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SNOW, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.SNOW_BLOCK, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.SOUL_CAMPFIRE, ToolHandler.Tool.AXE);
        this.addToMap(Material.SOUL_LANTERN, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SOUL_SAND, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.SOUL_SOIL, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.SPAWNER, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.SPRUCE_BUTTON, ToolHandler.Tool.AXE);
        this.addToMap(Material.SPRUCE_FENCE, ToolHandler.Tool.AXE);
        this.addToMap(Material.SPRUCE_FENCE_GATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.SPRUCE_LEAVES, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.SPRUCE_PRESSURE_PLATE, ToolHandler.Tool.AXE);
        this.addToMap(Material.SPRUCE_STAIRS, ToolHandler.Tool.AXE);
        this.addToMap(Material.STONE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONE_BRICKS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONE_BRICK_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONE_BRICK_STAIRS, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONE_BUTTON, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONE_PRESSURE_PLATE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.STONE_SLAB, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.TERRACOTTA, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.TRAPPED_CHEST, ToolHandler.Tool.AXE);
        this.addToMap(Material.VINE, ToolHandler.Tool.SHEARS);
        this.addToMap(Material.WHITE_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.WHITE_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        this.addToMap(Material.YELLOW_CONCRETE, ToolHandler.Tool.PICKAXE);
        this.addToMap(Material.YELLOW_CONCRETE_POWDER, ToolHandler.Tool.SHOVEL);
        try {
            for (Material mat : Material.values()) {
                String n = mat.name();
                if (n.contains("AMETHYST")) {
                    this.addToMap(n, ToolHandler.Tool.PICKAXE);
                }
                if (n.endsWith("_ORE")) {
                    this.addToMap(n, ToolHandler.Tool.PICKAXE);
                }
                if (n.contains("BASALT")) {
                    this.addToMap(n, ToolHandler.Tool.PICKAXE);
                }
                if (n.contains("DEEPSLATE")) {
                    this.addToMap(n, ToolHandler.Tool.PICKAXE);
                }
                if (n.contains("SCULK")) {
                    this.addToMap(n, ToolHandler.Tool.HOE);
                }
                if (!n.contains("BAMBOO")) continue;
                this.addToMap(n, ToolHandler.Tool.AXE);
            }
            this.addToMap(Material.GLOW_LICHEN, ToolHandler.Tool.SHEARS);
            this.addToMap(Material.CALCITE, ToolHandler.Tool.PICKAXE);
            this.addToMap(Material.ROOTED_DIRT, ToolHandler.Tool.SHOVEL);
            this.addToMap("MANGROVE_ROOTS", ToolHandler.Tool.AXE);
            this.addToMap("MUDDY_MANGROVE_ROOTS", ToolHandler.Tool.SHOVEL);
            this.addToMap("MUD", ToolHandler.Tool.SHOVEL);
            this.addToMap("PACKED_MUD", ToolHandler.Tool.PICKAXE);
            this.addToMap("CHISELED_BOOKSHELF", ToolHandler.Tool.AXE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initFallbackMaterials() {
        for (Material mat : Material.values()) {
            if (!mat.isBlock()) continue;
            String n = mat.name();
            if (n.contains("GLASS")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            for (String woodType : this.wood) {
                if (!n.contains(woodType) || !n.contains("STAIRS") && !n.contains("LOG") && !n.contains("PLANK")) continue;
                this.addToMap(mat, ToolHandler.Tool.AXE);
            }
            if (n.contains("STONE") || n.contains("BRICK")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("BLACKSTONE")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("NETHER_BRICK")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("TERRACOTTA")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("PURPUR")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("INFESTED")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("ENDSTONE_BRICK")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("QUARTZ")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("CORAL_BLOCK")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("PRISMARINE")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("FENCE_GATE")) {
                this.addToMap(mat, ToolHandler.Tool.AXE);
                continue;
            }
            if (n.contains("PRESSURE_PLATE")) {
                if (n.contains("STONE") || n.contains("IRON") || n.contains("GOLD")) {
                    this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                    continue;
                }
                this.addToMap(mat, ToolHandler.Tool.AXE);
                continue;
            }
            if (n.contains("SHULKER_BOX")) {
                this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                continue;
            }
            if (n.contains("FENCE")) {
                if (n.contains("NETHER") || n.contains("BRICK")) {
                    this.addToMap(mat, ToolHandler.Tool.PICKAXE);
                    continue;
                }
                this.addToMap(mat, ToolHandler.Tool.AXE);
                continue;
            }
            if (n.contains("SIGN")) {
                this.addToMap(mat, ToolHandler.Tool.AXE);
                continue;
            }
            if (n.equals("LEAVES") || n.equals("WOOL")) {
                this.addToMap(mat, ToolHandler.Tool.SHEARS);
                continue;
            }
            if (!n.equals("WORKBENCH")) continue;
            this.addToMap(mat, ToolHandler.Tool.AXE);
        }
    }
}

