/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils.recipe;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import me.val_mobile.utils.recipe.BrewClock;
import me.val_mobile.utils.recipe.RSVRecipe;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class RSVBrewingRecipe
implements Recipe,
RSVRecipe {
    private final RSVPlugin plugin;
    protected final ItemStack result;
    protected final ItemStack potion;
    protected final ItemStack ingredient;
    protected final ItemStack fuel;
    protected final int fuelPower;
    protected final int fuelCharge;
    protected final String name;
    protected BrewClock clock;
    protected final int duration;
    protected final boolean perfect;

    public RSVBrewingRecipe(@Nonnull FileConfiguration config, @Nonnull String name, @Nonnull RSVPlugin plugin) {
        this.name = name;
        this.fuelPower = config.getInt(name + ".FuelPower");
        this.fuelCharge = config.getInt(name + ".FuelCharge");
        this.perfect = config.getBoolean(name + ".Perfect");
        this.ingredient = RSVRecipe.getItem(config, name + ".Ingredient");
        this.fuel = RSVRecipe.getItem(config, name + ".Fuel");
        this.potion = RSVRecipe.getItem(config, name + ".Potion");
        this.result = RSVRecipe.getResult(config, name);
        this.duration = config.getInt(name + ".Duration");
        this.plugin = plugin;
    }

    @Nonnull
    public ItemStack getIngredient() {
        return this.ingredient;
    }

    @Nonnull
    public ItemStack getPotion() {
        return this.potion;
    }

    @Nonnull
    public ItemStack getFuel() {
        return this.fuel;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public BrewClock getClock() {
        return this.clock;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setClock(@Nonnull BrewClock clock) {
        this.clock = clock;
    }

    public boolean isValidRecipe(@Nonnull BrewerInventory inv) {
        ItemStack invFuel = inv.getFuel();
        ItemStack invIng = inv.getIngredient();
        if (Utils.isItemReal(invFuel) && Utils.isItemReal(invIng)) {
            return invFuel.isSimilar(this.fuel) && invIng.isSimilar(this.ingredient);
        }
        return false;
    }

    public void startBrewing(BrewerInventory inventory) {
        this.clock = new BrewClock(this, inventory, this.duration, this.plugin);
    }

    @Nonnegative
    public int getFuelPower() {
        return this.fuelPower;
    }

    @Nonnegative
    public int getFuelCharge() {
        return this.fuelCharge;
    }

    @Nonnull
    public ItemStack getResult() {
        return this.result;
    }
}

