/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Tab
implements TabCompleter {
    private final Set<String> firstArgs = new HashSet<String>();
    private final Set<String> mobs = new HashSet<String>();
    private final Set<String> items = RSVItem.getItemMap().keySet();
    private final Set<String> temperature = new HashSet<String>(26);
    private final Set<String> thirst = new HashSet<String>(21);
    private final Set<String> worlds = new HashSet<String>();
    private final FileConfiguration config;

    public Tab(RSVPlugin plugin) {
        this.config = plugin.getCommandsConfig();
    }

    public List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command cmd, @Nonnull String label, @Nonnull String[] args) {
        if (label.equalsIgnoreCase("RealisticSurvival") || label.equalsIgnoreCase("rsv")) {
            int i;
            ArrayList<String> result = new ArrayList<String>();
            if (this.firstArgs.isEmpty()) {
                this.firstArgs.addAll(Set.of("reload", "give", "spawnitem", "summon", "thirst", "temperature", "resetitem", "updateitem", "help", "version"));
            }
            if (this.mobs.isEmpty()) {
                this.mobs.addAll(Set.of("fire_dragon", "ice_dragon", "lightning_dragon", "sea_serpent", "siren"));
            }
            if (this.temperature.isEmpty()) {
                for (i = 0; i < 26; ++i) {
                    this.temperature.add(String.valueOf(i));
                }
            }
            if (this.thirst.isEmpty()) {
                for (i = 0; i < 21; ++i) {
                    this.thirst.add(String.valueOf(i));
                }
            }
            this.worlds.clear();
            Bukkit.getWorlds().forEach(world -> this.worlds.add(world.getName()));
            if (args.length == 1) {
                for (String a : this.firstArgs) {
                    if (!a.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    result.add(a);
                }
                return result;
            }
            if (args.length == 2) {
                switch (args[0].toLowerCase()) {
                    case "give": 
                    case "thirst": 
                    case "temperature": 
                    case "resetitem": 
                    case "updateitem": {
                        if (!(sender instanceof Player)) break;
                        Player player = (Player)sender;
                        result.add(player.getName());
                        break;
                    }
                    case "spawnitem": {
                        for (String item2 : this.items) {
                            if (!item2.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                            result.add(item2);
                        }
                        break;
                    }
                    case "summon": {
                        for (String mob : this.mobs) {
                            if (!mob.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                            result.add(mob);
                        }
                        break;
                    }
                }
                return result;
            }
            if (args.length == 3) {
                switch (args[0].toLowerCase()) {
                    case "give": {
                        RSVItem.getItemMap().keySet().stream().filter(item -> item.toLowerCase().startsWith(args[2].toLowerCase())).forEach(result::add);
                        break;
                    }
                    case "temperature": {
                        this.temperature.stream().filter(temp -> temp.toLowerCase().startsWith(args[2].toLowerCase())).forEach(result::add);
                        break;
                    }
                    case "thirst": {
                        this.thirst.stream().filter(th -> th.toLowerCase().startsWith(args[2].toLowerCase())).forEach(result::add);
                        break;
                    }
                    case "spawnitem": {
                        result.add(Utils.translateMsg(this.config.getString("Count"), sender, null));
                        break;
                    }
                    case "resetitem": 
                    case "updateitem": {
                        result.add("all");
                    }
                }
                return result;
            }
            if (args.length > 3) {
                if (args.length == 6 && (args[0].equalsIgnoreCase("spawnitem") || args[0].equalsIgnoreCase("summon"))) {
                    for (String a : this.worlds) {
                        if (!a.toLowerCase().startsWith(args[5].toLowerCase())) continue;
                        result.add(a);
                    }
                }
                return result;
            }
            return null;
        }
        return null;
    }
}

