/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.ArrayList;
import java.util.List;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.DragonBreed;

public enum DragonVariant {
    GRAY("Dragon.FireDragon.Enabled.Variants.Blue"),
    EMERALD("Dragon.FireDragon.Enabled.Variants.Emerald"),
    RED("Dragon.FireDragon.Enabled.Variants.Red"),
    BRONZE("Dragon.FireDragon.Enabled.Variants.Bronze"),
    SAPPHIRE("Dragon.IceDragon.Enabled.Variants.Sapphire"),
    BLUE("Dragon.IceDragon.Enabled.Variants.Blue"),
    SILVER("Dragon.IceDragon.Enabled.Variants.Silver"),
    WHITE("Dragon.IceDragon.Enabled.Variants.White"),
    AMETHYST("Dragon.LightningDragon.Enabled.Variants.Amethyst"),
    BLACK("Dragon.LightningDragon.Enabled.Variants.Black"),
    ELECTRIC_BLUE("Dragon.LightningDragon.Enabled.Variants.ElectricBlue"),
    COPPER("Dragon.LightningDragon.Enabled.Variants.Copper");

    private final boolean enabled;

    private DragonVariant(String configPath) {
        this.enabled = RSVModule.getModule("IceandFire").getUserConfig().getConfig().getBoolean(configPath);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static List<DragonVariant> getEnabledVariants(DragonBreed breed) {
        DragonVariant[] variants = breed.getVariants();
        ArrayList<DragonVariant> valid = new ArrayList<DragonVariant>();
        for (DragonVariant variant : variants) {
            if (!variant.isEnabled()) continue;
            valid.add(variant);
        }
        return valid;
    }

    public String toString() {
        return this.name().charAt(0) + this.name().substring(1).toLowerCase();
    }
}

