/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.ntp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.val_mobile.ntp.NtpModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CeramicBucketMeltTask
extends BukkitRunnable {
    private static final Map<UUID, CeramicBucketMeltTask> tasks = new HashMap<UUID, CeramicBucketMeltTask>();
    private final Player player;
    private final UUID id;
    private final RSVPlugin plugin;
    private final int duration;
    private final Set<String> allowedWorlds;
    private final double soundChance;
    private final boolean emitSound;
    private final String sound;
    private final float volume;
    private final float pitch;
    private final double particleChance;
    private final boolean emitParticles;
    private final int minCount;
    private final int maxCount;
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;
    private final double extra;
    private final Particle particle;
    private Particle.DustOptions dust;
    private final boolean shouldPourLava;
    private final boolean shouldOnlyReplacePassableBlocks;
    private int ticks = 0;

    public CeramicBucketMeltTask(RSVPlugin plugin, NtpModule module, Player player) {
        this.player = player;
        this.id = player.getUniqueId();
        this.plugin = plugin;
        FileConfiguration config = module.getUserConfig().getConfig();
        this.allowedWorlds = module.getAllowedWorlds();
        this.duration = config.getInt("Pottery.CeramicLavaBucketMelting.Time");
        this.soundChance = config.getDouble("Pottery.CeramicLavaBucketMelting.BurningSound.Chance");
        this.emitSound = config.getBoolean("Pottery.CeramicLavaBucketMelting.BurningSound.Enabled");
        this.sound = config.getString("Pottery.CeramicLavaBucketMelting.BurningSound.Sound");
        this.volume = (float)config.getDouble("Pottery.CeramicLavaBucketMelting.BurningSound.Volume");
        this.pitch = (float)config.getDouble("Pottery.CeramicLavaBucketMelting.BurningSound.Pitch");
        this.particleChance = config.getDouble("Pottery.CeramicLavaBucketMelting.EmitParticles.Chance");
        this.emitParticles = config.getBoolean("Pottery.CeramicLavaBucketMelting.EmitParticles.Enabled");
        this.minCount = config.getInt("Pottery.CeramicLavaBucketMelting.EmitParticles.MinCount");
        this.maxCount = config.getInt("Pottery.CeramicLavaBucketMelting.EmitParticles.MaxCount");
        this.xOffset = config.getDouble("Pottery.CeramicLavaBucketMelting.EmitParticles.x-Offset");
        this.yOffset = config.getDouble("Pottery.CeramicLavaBucketMelting.EmitParticles.y-Offset");
        this.zOffset = config.getDouble("Pottery.CeramicLavaBucketMelting.EmitParticles.z-Offset");
        this.extra = config.getDouble("Pottery.CeramicLavaBucketMelting.EmitParticles.Extra");
        this.particle = Particle.valueOf((String)config.getString("Pottery.CeramicLavaBucketMelting.EmitParticles.Particle"));
        if (this.particle == Particle.REDSTONE) {
            String color = config.getString("Pottery.CeramicLavaBucketMelting.EmitParticles.DustOptionColor");
            float size = (float)config.getDouble("Pottery.CeramicLavaBucketMelting.EmitParticles.DustOptionSize");
            if (color.contains("|")) {
                int first = color.indexOf("|");
                int second = color.lastIndexOf("|");
                int red = Integer.parseInt(color.substring(0, first));
                int green = Integer.parseInt(color.substring(first + 1, second));
                int blue = Integer.parseInt(color.substring(second + 1));
                this.dust = new Particle.DustOptions(Color.fromRGB((int)red, (int)green, (int)blue), size);
            } else {
                this.dust = new Particle.DustOptions(Utils.valueOfColor(color), size);
            }
        }
        this.shouldPourLava = config.getBoolean("Pottery.CeramicLavaBucketMelting.PourLava.Enabled");
        this.shouldOnlyReplacePassableBlocks = config.getBoolean("Pottery.CeramicLavaBucketMelting.PourLava.OnlyReplacePassableBlocks");
        tasks.put(this.id, this);
    }

    public void run() {
        if (this.player == null) {
            this.stop();
        } else if (this.player.isOnline() && this.allowedWorlds.contains(this.player.getWorld().getName()) && RSVItem.isHoldingItem("ceramic_lava_bucket", this.player)) {
            ++this.ticks;
            if (this.ticks > this.duration) {
                Block block;
                if (this.shouldPourLava && (block = this.player.getLocation().getBlock()).isPassable() && this.shouldOnlyReplacePassableBlocks) {
                    block.setType(Material.LAVA);
                }
                if (RSVItem.isHoldingItemInMainHand("ceramic_lava_bucket", this.player)) {
                    this.player.getInventory().setItemInMainHand(null);
                }
                if (RSVItem.isHoldingItemInOffHand("ceramic_lava_bucket", this.player)) {
                    this.player.getInventory().setItemInOffHand(null);
                }
                this.stop();
            } else {
                if (this.emitSound && Utils.roll(this.soundChance)) {
                    Utils.playSound(this.player.getLocation(), this.sound, this.volume, this.pitch);
                }
                if (this.emitParticles && Utils.roll(this.particleChance)) {
                    this.player.spawnParticle(this.particle, this.player.getLocation(), Utils.getRandomNum(this.minCount, this.maxCount), this.xOffset, this.yOffset, this.zOffset, this.extra, (Object)this.dust);
                }
            }
        } else {
            this.stop();
        }
    }

    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static Map<UUID, CeramicBucketMeltTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

