/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.rsv;

import java.io.File;
import java.util.Collection;
import javax.annotation.Nonnull;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.commands.Commands;
import me.val_mobile.commands.Tab;
import me.val_mobile.data.MiscItems;
import me.val_mobile.data.MiscRecipes;
import me.val_mobile.data.PluginConfig;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.iceandfire.IceFireModule;
import me.val_mobile.integrations.PAPI;
import me.val_mobile.integrations.RealisticSeasons;
import me.val_mobile.misc.BStats;
import me.val_mobile.misc.ItemAcquireEvents;
import me.val_mobile.misc.MiscEvents;
import me.val_mobile.misc.ResourcePackEvents;
import me.val_mobile.misc.UpdateChecker;
import me.val_mobile.ntp.NtpModule;
import me.val_mobile.spartanandfire.SfModule;
import me.val_mobile.spartanweaponry.SwModule;
import me.val_mobile.tan.TanModule;
import me.val_mobile.utils.ToolHandler;
import me.val_mobile.utils.ToolUtils;
import me.val_mobile.utils.Utils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RSVPlugin
extends JavaPlugin {
    public static final String NAME = "RealisticSurvival";
    private static RSVPlugin plugin;
    private static Utils util;
    private ToolUtils toolUtils;
    private ToolHandler toolHandler;
    private PluginConfig config;
    private static RSVConfig lorePresetConfig;
    private RSVConfig miscItemsConfig;
    private RSVConfig miscRecipesConfig;
    private MiscRecipes miscRecipes;
    private MiscItems miscItems;
    private RSVConfig integrationsConfig;
    private RSVConfig commandsConfig;

    public void onEnable() {
        TanModule tanModule;
        SfModule sfModule;
        NtpModule ntpModule;
        BaubleModule baubleModule;
        SwModule swModule;
        plugin = this;
        this.config = new PluginConfig(this);
        lorePresetConfig = new RSVConfig(this, "lorepresets.yml");
        this.miscItemsConfig = new RSVConfig(this, "resources/misc_items.yml");
        this.miscRecipesConfig = new RSVConfig(this, "resources/misc_recipes.yml");
        this.integrationsConfig = new RSVConfig(this, "integrations.yml");
        this.commandsConfig = new RSVConfig(this, "commands.yml");
        util = new Utils(this);
        new UpdateChecker(this, 93795).checkUpdate();
        PluginManager pm = this.getServer().getPluginManager();
        this.toolHandler = new ToolHandler();
        this.toolUtils = new ToolUtils(this);
        this.toolUtils.initMap();
        this.miscItems = new MiscItems(this);
        this.miscRecipes = new MiscRecipes(this);
        IceFireModule ifModule = new IceFireModule(this);
        if (ifModule.isGloballyEnabled()) {
            ifModule.initialize();
        }
        if ((swModule = new SwModule(this)).isGloballyEnabled()) {
            swModule.initialize();
        }
        if ((baubleModule = new BaubleModule(this)).isGloballyEnabled()) {
            baubleModule.initialize();
        }
        if ((ntpModule = new NtpModule(this)).isGloballyEnabled()) {
            ntpModule.initialize();
        }
        if ((sfModule = new SfModule(this)).isGloballyEnabled()) {
            sfModule.initialize();
        }
        if ((tanModule = new TanModule(this)).isGloballyEnabled()) {
            tanModule.initialize();
        }
        new BukkitRunnable(this){

            public void run() {
                RealisticSeasons rs = new RealisticSeasons(RSVPlugin.getPlugin());
                PAPI papi = new PAPI(RSVPlugin.getPlugin());
            }
        }.runTaskLater((Plugin)this, 1L);
        if (this.config.getConfig().getBoolean("ResourcePack.Enabled")) {
            pm.registerEvents((Listener)new ResourcePackEvents(this), (Plugin)this);
        }
        if (this.config.getConfig().getBoolean("BStats")) {
            new BStats(this).recordData();
        }
        pm.registerEvents((Listener)new MiscEvents(this), (Plugin)this);
        pm.registerEvents((Listener)new ItemAcquireEvents(this), (Plugin)this);
        this.getCommand(NAME).setExecutor((CommandExecutor)new Commands(this));
        this.getCommand(NAME).setTabCompleter((TabCompleter)new Tab(this));
    }

    public void onDisable() {
        Collection<RSVPlayer> players = RSVPlayer.getPlayers().values();
        Collection<RSVModule> modules = RSVModule.getModules().values();
        for (RSVPlayer player : players) {
            player.saveData();
        }
        for (RSVModule module : modules) {
            if (!module.isGloballyEnabled()) continue;
            module.shutdown();
        }
    }

    public void onLoad() {
    }

    public FileConfiguration getConfig() {
        return this.config == null ? null : this.config.getConfig();
    }

    @Nonnull
    public static RSVPlugin getPlugin() {
        return plugin;
    }

    @Nonnull
    public static Utils getUtil() {
        return util;
    }

    @Nonnull
    public File getConfigFile() {
        return this.config.getFile();
    }

    @Nonnull
    public static FileConfiguration getLorePresetConfig() {
        return lorePresetConfig.getConfig();
    }

    @Nonnull
    public FileConfiguration getMiscItemsConfig() {
        return this.miscItemsConfig.getConfig();
    }

    @Nonnull
    public FileConfiguration getMiscRecipesConfig() {
        return this.miscRecipesConfig.getConfig();
    }

    @Nonnull
    public FileConfiguration getIntegrationsConfig() {
        return this.integrationsConfig.getConfig();
    }

    @Nonnull
    public FileConfiguration getCommandsConfig() {
        return this.commandsConfig.getConfig();
    }

    @Nonnull
    public MiscItems getMiscItems() {
        return this.miscItems;
    }

    @Nonnull
    public MiscRecipes getMiscRecipes() {
        return this.miscRecipes;
    }

    @Nonnull
    public ToolHandler getToolHandler() {
        return this.toolHandler;
    }

    @Nonnull
    public ToolUtils getToolUtils() {
        return this.toolUtils;
    }
}

