/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.RSVTask;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class DehydrationTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, DehydrationTask> tasks = new HashMap<UUID, DehydrationTask>();
    private final ThirstManager manager;
    private final UUID id;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final Collection<String> allowedWorlds;
    private final double damage;
    private final TanModule module;
    private final double maxThirst;
    private final boolean damageEnabled;
    private final boolean potionEffectsEnabled;
    private final double damageCutoff;
    private final Collection<PotionEffect> potionEffects = new ArrayList<PotionEffect>();

    public DehydrationTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.manager = module.getThirstManager();
        this.module = module;
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.maxThirst = this.config.getDouble("Thirst.Dehydration.Thirst");
        this.damage = this.config.getDouble("Thirst.Dehydration.Damage.Amount");
        this.damageEnabled = this.config.getBoolean("Thirst.Dehydration.Damage.Enabled");
        this.potionEffectsEnabled = this.config.getBoolean("Thirst.Dehydration.PotionEffects.Enabled");
        this.damageCutoff = this.config.getDouble("Thirst.Dehydration.Damage.Cutoff");
        ConfigurationSection section = this.config.getConfigurationSection("Thirst.Dehydration.PotionEffects.Effects");
        Set keys = section.getKeys(false);
        for (String key : keys) {
            int dur = section.getInt(key + ".Duration");
            int amp = section.getInt(key + ".Amplifier");
            this.potionEffects.add(new PotionEffect(PotionEffectType.getByName((String)key), dur, amp));
        }
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            if (!player.hasPermission("realisticsurvival.toughasnails.resistance.thirst.damage") && this.damageEnabled && player.getHealth() >= this.damageCutoff) {
                if (player.getHealth() - this.damage <= 0.0) {
                    this.module.getDehydrationDeath().add(this.id);
                }
                player.damage(this.damage);
            }
            if (!player.hasPermission("realisticsurvival.toughasnails.resistance.thirst.potioneffects") && this.potionEffectsEnabled) {
                player.addPotionEffects(this.potionEffects);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && !player.isDead() && this.allowedWorlds.contains(player.getWorld().getName()) && (double)this.manager.getThirst(player) < this.maxThirst;
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Thirst.Dehydration.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, DehydrationTask> getTasks() {
        return tasks;
    }
}

