/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TemperatureCalculateTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVTask;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ThermometerTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, ThermometerTask> tasks = new HashMap<UUID, ThermometerTask>();
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final TemperatureCalculateTask task;
    private final Location originalCompassTarget;

    public ThermometerTask(RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.config = RSVModule.getModule("ToughAsNails").getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.allowedWorlds = RSVModule.getModule("ToughAsNails").getAllowedWorlds();
        this.task = TemperatureCalculateTask.getTasks().get(this.id);
        this.originalCompassTarget = player.getPlayer().getCompassTarget();
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            double equilibriumTemp = this.task.getEquilibriumTemp();
            if (equilibriumTemp > 25.0) {
                equilibriumTemp = 25.0;
            }
            if (equilibriumTemp < 0.0) {
                equilibriumTemp = 0.0;
            }
            Location loc = player.getEyeLocation();
            double rad = Math.PI * (12.5 - equilibriumTemp) / 25.0;
            Vector dir = loc.getDirection().normalize();
            dir.rotateAroundY(rad).multiply(1000);
            loc.add(dir);
            player.setCompassTarget(loc);
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName()) && this.task != null && RSVItem.isHoldingItem("thermometer", player);
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Items.thermometer.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 1L, tickPeriod);
    }

    @Override
    public void stop() {
        if (this.player.getPlayer() != null && this.originalCompassTarget != null) {
            this.player.getPlayer().setCompassTarget(this.originalCompassTarget);
        }
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, ThermometerTask> getTasks() {
        return tasks;
    }
}

