/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CharacterValues {
    private final FileConfiguration tanConfig;
    private final FileConfiguration ifConfig;

    public CharacterValues() {
        RSVModule tanModule = RSVModule.getModule("ToughAsNails");
        RSVModule ifModule = RSVModule.getModule("IceandFire");
        this.tanConfig = tanModule.isGloballyEnabled() ? tanModule.getUserConfig().getConfig() : null;
        this.ifConfig = ifModule.isGloballyEnabled() ? ifModule.getUserConfig().getConfig() : null;
    }

    @Nonnull
    public String getTemperatureOnlyActionbar(@Nullable Player player, @Nonnegative int temperature) {
        String s = this.tanConfig.getString("CharacterOverrides.TemperatureActionbar");
        return Utils.translateMsg(s, (CommandSender)player, Map.of("TEMP", this.getTemperature(player, temperature)));
    }

    @Nonnull
    public String getThirstOnlyActionbar(@Nullable Player player, @Nonnegative int thirst, boolean isUnderwater, boolean parasitesActive) {
        String s = this.tanConfig.getString("CharacterOverrides.ThirstActionbar");
        return Utils.translateMsg(s, (CommandSender)player, Map.of("THIRST", this.getThirst(player, thirst, isUnderwater, parasitesActive)));
    }

    @Nonnull
    public String getTemperatureThirstActionbar(@Nullable Player player, @Nonnegative int temperature, @Nonnegative int thirst, boolean isUnderwater, boolean parasitesActive) {
        String s = this.tanConfig.getString("CharacterOverrides.TemperatureThirstActionbar");
        return Utils.translateMsg(s, (CommandSender)player, Map.of("TEMP", this.getTemperature(player, temperature), "THIRST", this.getThirst(player, thirst, isUnderwater, parasitesActive)));
    }

    @Nonnull
    public String getThirst(@Nullable Player player, @Nonnegative int thirst, boolean isUnderwater, boolean parasitesActive) {
        int numEmpty;
        int numHalf;
        String FULL_THIRST_DROP;
        String HALF_THIRST_DROP;
        String EMPTY_THIRST_DROP = Utils.translateMsg(isUnderwater ? this.tanConfig.getString("CharacterOverrides.UnderwaterEmptyThirstDrop") : this.tanConfig.getString("CharacterOverrides.AboveWaterEmptyThirstDrop"), (CommandSender)player, null);
        if (parasitesActive) {
            HALF_THIRST_DROP = Utils.translateMsg(isUnderwater ? this.tanConfig.getString("CharacterOverrides.ParasitesUnderwaterHalfThirstDrop") : this.tanConfig.getString("CharacterOverrides.ParasitesAboveWaterHalfThirstDrop"), (CommandSender)player, null);
            FULL_THIRST_DROP = Utils.translateMsg(isUnderwater ? this.tanConfig.getString("CharacterOverrides.ParasitesUnderwaterFullThirstDrop") : this.tanConfig.getString("CharacterOverrides.ParasitesAboveWaterFullThirstDrop"), (CommandSender)player, null);
        } else {
            HALF_THIRST_DROP = Utils.translateMsg(isUnderwater ? this.tanConfig.getString("CharacterOverrides.UnderwaterHalfThirstDrop") : this.tanConfig.getString("CharacterOverrides.AboveWaterHalfThirstDrop"), (CommandSender)player, null);
            FULL_THIRST_DROP = Utils.translateMsg(isUnderwater ? this.tanConfig.getString("CharacterOverrides.UnderwaterFullThirstDrop") : this.tanConfig.getString("CharacterOverrides.AboveWaterFullThirstDrop"), (CommandSender)player, null);
        }
        thirst = thirst < 0 ? 0 : Math.min(thirst, 20);
        StringBuilder s = new StringBuilder();
        if (thirst % 2 == 0) {
            numHalf = 0;
            numEmpty = (20 - thirst) / 2;
        } else {
            numHalf = 1;
            numEmpty = (19 - thirst) / 2;
        }
        s.append(FULL_THIRST_DROP.repeat((20 - numHalf - numEmpty * 2) / 2));
        if (numHalf == 1) {
            s.insert(0, HALF_THIRST_DROP);
        }
        for (int i = 0; i < numEmpty; ++i) {
            s.insert(0, EMPTY_THIRST_DROP);
        }
        return s.toString();
    }

    @Nonnull
    public String getThirstDrop(@Nullable Player player, int i) {
        return switch (i) {
            case 0 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.AboveWaterEmptyThirstDrop"), (CommandSender)player, null);
            case 1 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.AboveWaterHalfThirstDrop"), (CommandSender)player, null);
            case 2 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.AboveWaterFullThirstDrop"), (CommandSender)player, null);
            default -> "";
        };
    }

    @Nonnull
    public String getIceVignette(@Nullable Player player, int temperature) {
        return switch (temperature) {
            case 0 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.FreezingView"), (CommandSender)player, null);
            case 1 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.IceVignette5"), (CommandSender)player, null);
            case 2 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.IceVignette4"), (CommandSender)player, null);
            case 3 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.IceVignette3"), (CommandSender)player, null);
            case 4 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.IceVignette2"), (CommandSender)player, null);
            case 5 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.IceVignette1"), (CommandSender)player, null);
            default -> "";
        };
    }

    @Nonnull
    public String getFireVignette(@Nullable Player player, int temperature) {
        return switch (temperature) {
            case 20 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.FireVignette1"), (CommandSender)player, null);
            case 21 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.FireVignette2"), (CommandSender)player, null);
            case 22 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.FireVignette3"), (CommandSender)player, null);
            case 23 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.FireVignette4"), (CommandSender)player, null);
            case 24 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.FireVignette5"), (CommandSender)player, null);
            case 25 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.BurningView"), (CommandSender)player, null);
            default -> "";
        };
    }

    @Nonnull
    public String getThirstVignette(@Nullable Player player, int thirst) {
        return switch (thirst) {
            case 0 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.DehydratedView"), (CommandSender)player, null);
            case 1 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.ThirstVignette5"), (CommandSender)player, null);
            case 2 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.ThirstVignette4"), (CommandSender)player, null);
            case 3 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.ThirstVignette3"), (CommandSender)player, null);
            case 4 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.ThirstVignette2"), (CommandSender)player, null);
            case 5 -> Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.ThirstVignette1"), (CommandSender)player, null);
            default -> "";
        };
    }

    @Nonnull
    public String getTemperature(@Nullable Player player, int i) {
        if (i < 0 || i > 25) {
            return "";
        }
        return Utils.translateMsg(this.tanConfig.getString("CharacterOverrides.Temperature" + i), (CommandSender)player, null);
    }

    @Nonnull
    public String getSirenView(@Nullable Player player) {
        return Utils.translateMsg(this.ifConfig.getString("Siren.ChangeScreen.Character"), (CommandSender)player, null);
    }
}

