/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Material;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class Ingredient {
    private final List<RSVItem> items = new ArrayList<RSVItem>();
    private final Set<Material> materials = new HashSet<Material>();

    public Ingredient(@Nonnull String raw) {
        if (!raw.isEmpty()) {
            if (raw.matches("^\\(([a-zA-Z_,]+)\\)$")) {
                String[] entries;
                raw = raw.substring(1, raw.length() - 1);
                block10: for (String s : entries = raw.split(",")) {
                    IngredientType type = this.parseIngredientType(s);
                    if (type == null) {
                        throw new IllegalArgumentException("Could not parse string " + s + " valid ingredient.");
                    }
                    switch (type.ordinal()) {
                        case 0: {
                            this.items.add(RSVItem.getItem(s));
                            continue block10;
                        }
                        case 1: {
                            this.materials.add(Material.valueOf((String)s));
                            continue block10;
                        }
                        case 2: {
                            this.materials.addAll(Utils.getTag(s.substring(4)).getValues());
                            continue block10;
                        }
                        default: {
                            throw new IllegalArgumentException("Could not parse string into valid ingredient.");
                        }
                    }
                }
            } else {
                IngredientType type = this.parseIngredientType(raw);
                if (type == null) {
                    throw new IllegalArgumentException("Could not parse string " + raw + " into valid ingredient.");
                }
                switch (type.ordinal()) {
                    case 0: {
                        this.items.add(RSVItem.getItem(raw));
                        break;
                    }
                    case 1: {
                        this.materials.add(Material.valueOf((String)raw));
                        break;
                    }
                    case 2: {
                        this.materials.addAll(Utils.getTag(raw.substring(4)).getValues());
                        break;
                    }
                }
            }
        }
    }

    public static boolean isValid(@Nullable String raw) {
        if (raw == null || raw.isEmpty()) {
            return false;
        }
        if (raw.matches("^\\(([a-zA-Z_,]+)\\)$")) {
            String[] entries;
            raw = raw.substring(1, raw.length() - 1);
            for (String s : entries = raw.split(",")) {
                if (!(s.matches("^Tag\\.([A-Z]+)$") ? Utils.getTag(s.substring(4)) == null : !Utils.isInEnum(s, Material.class) && !RSVItem.isRSVItem(s))) continue;
                return false;
            }
            return true;
        }
        if (raw.matches("^Tag\\.([A-Z]+)$")) {
            return Utils.getTag(raw.substring(4)) != null;
        }
        return Utils.isInEnum(raw, Material.class) || RSVItem.isRSVItem(raw);
    }

    public List<RSVItem> getItems() {
        return this.items;
    }

    public Set<Material> getMaterials() {
        return this.materials;
    }

    public void add(@Nullable Collection<?> col) {
        if (col != null && !col.isEmpty()) {
            for (Object obj : col) {
                ItemStack item;
                if (obj instanceof Material) {
                    Material mat = (Material)obj;
                    this.materials.add(mat);
                    continue;
                }
                if (!(obj instanceof ItemStack) || !RSVItem.isRSVItem(item = (ItemStack)obj)) continue;
                this.items.add(RSVItem.getItem(RSVItem.getNameFromItem(item)));
            }
        }
    }

    public void add(@Nullable Material material) {
        if (material != null) {
            this.materials.add(material);
        }
    }

    public void add(@Nullable ItemStack item) {
        if (RSVItem.isRSVItem(item)) {
            RSVItem rsvItem = RSVItem.getItem(RSVItem.getNameFromItem(item));
            this.items.add(rsvItem);
        }
    }

    public final boolean test(@Nullable Material material) {
        return this.materials.contains(material);
    }

    public final boolean test(@Nullable ItemStack item) {
        if (!Utils.isItemReal(item)) {
            return false;
        }
        if (RSVItem.isRSVItem(item)) {
            for (RSVItem i : this.items) {
                if (!Utils.isItemReal(i) || !Objects.equals(RSVItem.getNameFromItem(item), i.getName())) continue;
                return true;
            }
            return false;
        }
        return this.test(item.getType());
    }

    public final boolean test(@Nullable CraftingInventory inv) {
        if (inv == null) {
            return false;
        }
        for (RSVItem i : this.items) {
            if (!Utils.isItemReal(i) || !inv.contains((ItemStack)i)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IngredientType parseIngredientType(@Nullable String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        if (raw.matches("^Tag\\.([A-Z]+)$") && Utils.getTag(raw.substring(4)) != null) {
            return IngredientType.TAG;
        }
        if (Utils.isInEnum(raw, Material.class)) {
            return IngredientType.MATERIAL;
        }
        if (RSVItem.isRSVItem(raw)) {
            return IngredientType.ITEM;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Ingredient) {
            Ingredient ing = (Ingredient)obj;
            return Objects.equals(this.getItems(), ing.getItems()) && Objects.equals(this.getMaterials(), ing.getMaterials());
        }
        return false;
    }

    public static enum IngredientType {
        ITEM,
        MATERIAL,
        TAG;

    }
}

