/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.Tag;

public class TagUtils {
    private static TagUtils instance;
    private final Map<String, Tag<Material>> map;

    public TagUtils(Class<?> clazz) {
        this.map = TagUtils.getStaticTagMaterialFields(clazz);
    }

    @Nonnull
    public static Map<String, Tag<Material>> getStaticTagMaterialFields(@Nonnull Class<?> clazz) {
        HashMap<String, Tag<Material>> tagMaterialMap = new HashMap<String, Tag<Material>>();
        try {
            Field[] fields;
            for (Field field : fields = clazz.getFields()) {
                Object value;
                ParameterizedType parameterizedType;
                Type type;
                if ((field.getModifiers() & 8) == 0 || !((type = field.getGenericType()) instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().equals(Tag.class) || !parameterizedType.getActualTypeArguments()[0].equals(Material.class) || !((value = field.get(null)) instanceof Tag)) continue;
                tagMaterialMap.put(field.getName(), (Tag<Material>)((Tag)value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tagMaterialMap;
    }

    public static Tag<Material> getTag(Class<?> clazz, String name) {
        return TagUtils.getInstance(clazz).map.get(name);
    }

    public static TagUtils getInstance(Class<?> clazz) {
        if (instance == null) {
            instance = new TagUtils(clazz);
        }
        return instance;
    }
}

