/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data.toughasnails;

import java.io.IOException;
import java.util.UUID;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVDataModule;
import me.val_mobile.data.RSVModule;
import me.val_mobile.tan.TanModule;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DataModule
implements RSVDataModule {
    private final UUID id;
    private final FileConfiguration userConfig;
    private final RSVConfig playerDataConfig;
    private double temperature;
    private int thirst;
    private double thirstExhaustion;
    private int thirstSaturation;
    private int thirstTickTimer;

    public void setTemperature(double temperature) {
        String tempPath;
        this.temperature = temperature;
        FileConfiguration config = this.playerDataConfig.getConfig();
        if (!config.contains(tempPath = String.valueOf(this.id) + ".Temperature")) {
            config.createSection(tempPath);
        }
        config.set(tempPath, (Object)temperature);
        this.saveFile(config);
    }

    public void setThirst(int thirst) {
        String thirstPath;
        this.thirst = thirst;
        FileConfiguration config = this.playerDataConfig.getConfig();
        if (!config.contains(thirstPath = String.valueOf(this.id) + ".Thirst")) {
            config.createSection(thirstPath);
        }
        config.set(thirstPath, (Object)thirst);
        this.saveFile(config);
    }

    public void setThirstExhaustion(double thirstExhaustion) {
        String exhaustionPath;
        this.thirstExhaustion = thirstExhaustion;
        FileConfiguration config = this.playerDataConfig.getConfig();
        if (!config.contains(exhaustionPath = String.valueOf(this.id) + ".ThirstExhaustion")) {
            config.createSection(exhaustionPath);
        }
        config.set(exhaustionPath, (Object)thirstExhaustion);
        this.saveFile(config);
    }

    public void setThirstSaturation(double thirstSaturation) {
        String saturationPath;
        this.thirstExhaustion = thirstSaturation;
        FileConfiguration config = this.playerDataConfig.getConfig();
        if (!config.contains(saturationPath = String.valueOf(this.id) + ".ThirstSaturation")) {
            config.createSection(saturationPath);
        }
        config.set(saturationPath, (Object)thirstSaturation);
        this.saveFile(config);
    }

    public void setThirstTickTimer(int thirstTickTimer) {
        String tickTimerPath;
        this.thirstTickTimer = thirstTickTimer;
        FileConfiguration config = this.playerDataConfig.getConfig();
        if (!config.contains(tickTimerPath = String.valueOf(this.id) + ".ThirstTickTimer")) {
            config.createSection(tickTimerPath);
        }
        config.set(tickTimerPath, (Object)thirstTickTimer);
        this.saveFile(config);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public int getThirst() {
        return this.thirst;
    }

    public double getThirstExhaustion() {
        return this.thirstExhaustion;
    }

    public int getThirstSaturation() {
        return this.thirstSaturation;
    }

    public int getThirstTickTimer() {
        return this.thirstTickTimer;
    }

    public DataModule(Player player) {
        TanModule module = (TanModule)RSVModule.getModule("ToughAsNails");
        this.userConfig = module.getUserConfig().getConfig();
        this.playerDataConfig = module.getPlayerDataConfig();
        this.id = player.getUniqueId();
    }

    @Override
    public void retrieveData() {
        FileConfiguration config = this.playerDataConfig.getConfig();
        String tempPath = String.valueOf(this.id) + ".Temperature";
        String thirstPath = String.valueOf(this.id) + ".Thirst";
        String saturationPath = String.valueOf(this.id) + ".ThirstSaturation";
        String exhaustionPath = String.valueOf(this.id) + ".ThirstExhaustion";
        String tickTimerPath = String.valueOf(this.id) + ".ThirstTickTimer";
        double defaultTemp = this.userConfig.getDouble("Temperature.DefaultTemperature");
        int defaultThirst = this.userConfig.getInt("Thirst.DefaultThirst");
        int defaultSaturation = this.userConfig.getInt("Thirst.DefaultSaturation");
        double defaultExhaustion = this.userConfig.getDouble("Thirst.DefaultExhaustion");
        int defaultTickTimer = this.userConfig.getInt("Thirst.DefaultExhaustionTickTimer");
        if (!config.contains(this.id.toString())) {
            config.createSection(this.id.toString());
        }
        if (config.contains(tempPath)) {
            this.temperature = config.getDouble(tempPath);
        } else {
            this.temperature = defaultTemp;
            config.createSection(tempPath);
            config.set(tempPath, (Object)this.temperature);
        }
        if (config.contains(thirstPath)) {
            this.thirst = config.getInt(thirstPath);
        } else {
            this.thirst = defaultThirst;
            config.createSection(thirstPath);
            config.set(tempPath, (Object)this.thirst);
        }
        if (config.contains(saturationPath)) {
            this.thirstSaturation = config.getInt(saturationPath);
        } else {
            this.thirstSaturation = defaultSaturation;
            config.createSection(saturationPath);
            config.set(saturationPath, (Object)this.thirstSaturation);
        }
        if (config.contains(exhaustionPath)) {
            this.thirstExhaustion = config.getDouble(exhaustionPath);
        } else {
            this.thirstExhaustion = defaultExhaustion;
            config.createSection(exhaustionPath);
            config.set(exhaustionPath, (Object)this.thirstExhaustion);
        }
        if (config.contains(tickTimerPath)) {
            this.thirstTickTimer = config.getInt(tickTimerPath);
        } else {
            this.thirstTickTimer = defaultTickTimer;
            config.createSection(tickTimerPath);
            config.set(tickTimerPath, (Object)this.thirstTickTimer);
        }
        this.saveFile(config);
    }

    @Override
    public void saveData() {
        FileConfiguration config = this.playerDataConfig.getConfig();
        String tempPath = String.valueOf(this.id) + ".Temperature";
        String thirstPath = String.valueOf(this.id) + ".Thirst";
        String saturationPath = String.valueOf(this.id) + ".ThirstSaturation";
        String exhaustionPath = String.valueOf(this.id) + ".ThirstExhaustion";
        String tickTimer = String.valueOf(this.id) + ".ThirstTickTimer";
        if (!config.contains(this.id.toString())) {
            config.createSection(this.id.toString());
        }
        if (!config.contains(tempPath)) {
            config.createSection(tempPath);
        }
        if (!config.contains(thirstPath)) {
            config.createSection(thirstPath);
        }
        if (!config.contains(saturationPath)) {
            config.createSection(saturationPath);
        }
        if (!config.contains(exhaustionPath)) {
            config.createSection(exhaustionPath);
        }
        if (!config.contains(tickTimer)) {
            config.createSection(tickTimer);
        }
        config.set(tempPath, (Object)this.temperature);
        config.set(thirstPath, (Object)this.thirst);
        config.set(saturationPath, (Object)this.thirstSaturation);
        config.set(exhaustionPath, (Object)this.thirstExhaustion);
        config.set(tickTimer, (Object)this.thirstTickTimer);
        this.saveFile(config);
    }

    public void saveFile(FileConfiguration config) {
        try {
            config.save(this.playerDataConfig.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

