/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import javax.annotation.Nonnull;
import me.val_mobile.iceandfire.Dragon;
import me.val_mobile.iceandfire.DragonUtils;
import me.val_mobile.iceandfire.ExplosionAttack;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class FireExplosionAttack
extends ExplosionAttack {
    public FireExplosionAttack(EnderDragon dragon, Location target, RSVPlugin plugin) {
        super(dragon, target, plugin);
    }

    public FireExplosionAttack(Dragon dragon, Location target, RSVPlugin plugin) {
        super(dragon, target, plugin);
    }

    @Override
    public void grief(Location center, int radius) {
        World world = center.getWorld();
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    if (Math.hypot(Math.hypot(x, y), z) > (double)radius) continue;
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    Location secondLoc = center.clone().add((double)x, (double)(y - 1), (double)z);
                    Block block = loc.getBlock();
                    Material blockMaterial = block.getType();
                    Block secondBlock = secondLoc.getBlock();
                    if (block.isEmpty() || !blockMaterial.isOccluding()) {
                        if (block.isLiquid() || secondBlock.isEmpty()) continue;
                        world.getBlockAt(loc).setType(Material.valueOf((String)this.config.getString("Dragon.FireDragon.ExplosionAttack.LayerBlock")));
                        continue;
                    }
                    if (this.immuneBlocks.contains(blockMaterial.toString()) || block.isLiquid()) continue;
                    world.getBlockAt(loc).setType(this.getBurntMaterial(blockMaterial));
                }
            }
        }
        world.createExplosion(center, (float)(this.config.getDouble("Dragon.FireDragon.ExplosionAttack.Explosion.Power") * this.config.getDouble("Dragon.FireDragon.ExplosionAttack.StageMultipliers.Stage" + DragonUtils.getStage(this.dragon))), this.config.getBoolean("Dragon.FireDragon.ExplosionAttack.SetFire"), this.config.getBoolean("Dragon.FireDragon.ExplosionAttack.BreakBlocks"), (Entity)this.dragon);
    }

    @Nonnull
    public Material getBurntMaterial(@Nonnull Material material) {
        Material burnt;
        if (this.specialBlocks.containsKey(material.toString())) {
            String[] mats = (String[])this.specialBlocks.get(material.toString());
            burnt = Material.valueOf((String)mats[Utils.getRandomNum(0, mats.length - 1)]);
        } else {
            burnt = material.isFuel() ? Material.valueOf((String)this.config.getString("Dragon.FireDragon.ExplosionAttack.BurntBlock")) : Material.valueOf((String)this.config.getString("Dragon.FireDragon.ExplosionAttack.CharredBlock"));
        }
        return burnt;
    }
}

