/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.iceandfire.IceFireModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TideGuardianTask
extends BukkitRunnable {
    private static final Map<UUID, TideGuardianTask> tasks = new HashMap<UUID, TideGuardianTask>();
    private final FileConfiguration config;
    private final Player player;
    private final RSVPlugin plugin;
    private boolean containsTideArmor = false;
    private final Collection<String> allowedWorlds;
    private final int maxStrAmp;
    private final int maxStrDur;
    private final int maxBreathingAmp;
    private final int maxBreathingDur;
    private final boolean strEnabled;
    private final boolean breathingEnabled;
    private final boolean strRequiresWater;
    private final boolean breathingRequiresWater;

    public TideGuardianTask(IceFireModule module, Player player, RSVPlugin plugin) {
        this.player = player;
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.allowedWorlds = module.getAllowedWorlds();
        this.strEnabled = this.config.getBoolean("Abilities.TideGuardian.Strength.Enabled");
        this.strRequiresWater = this.config.getBoolean("Abilities.TideGuardian.Strength.MustSubmerge");
        this.maxStrAmp = this.config.getInt("Abilities.TideGuardian.Strength.MaxAmplifier");
        this.maxStrDur = this.config.getInt("Abilities.TideGuardian.Strength.MaxDuration");
        this.breathingEnabled = this.config.getBoolean("Abilities.TideGuardian.WaterBreathing.Enabled");
        this.breathingRequiresWater = this.config.getBoolean("Abilities.TideGuardian.WaterBreathing.MustSubmerge");
        this.maxBreathingAmp = this.config.getInt("Abilities.TideGuardian.WaterBreathing.MaxAmplifier");
        this.maxBreathingDur = this.config.getInt("Abilities.TideGuardian.WaterBreathing.MaxDuration");
        tasks.put(player.getUniqueId(), this);
    }

    public void run() {
        ItemStack[] items = this.player.getInventory().getArmorContents();
        int breathingDur = 0;
        int breathingAmp = 0;
        int strDur = 0;
        int strAmp = 0;
        for (ItemStack item : items) {
            String itemName;
            if (!RSVItem.isRSVItem(item) || !(itemName = RSVItem.getNameFromItem(item)).contains("tide_guardian_")) continue;
            this.containsTideArmor = true;
            breathingDur += this.config.getInt("Items." + itemName + ".WaterBreathing.Duration");
            breathingAmp += this.config.getInt("Items." + itemName + ".WaterBreathing.Amplifier");
            strDur += this.config.getInt("Items." + itemName + ".Strength.Duration");
            strAmp += this.config.getInt("Items." + itemName + ".Strength.Amplifier");
        }
        if (this.containsTideArmor && !this.player.isDead() && this.player.isOnline() && this.allowedWorlds.contains(this.player.getWorld().getName())) {
            breathingAmp = Math.min(this.maxBreathingAmp, breathingAmp);
            breathingDur = Math.min(this.maxBreathingDur, breathingDur);
            strAmp = Math.min(this.maxStrAmp, strAmp);
            strDur = Math.min(this.maxStrDur, breathingDur);
            if (this.breathingEnabled) {
                if (this.breathingRequiresWater) {
                    if (this.player.isInWater()) {
                        this.player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, breathingDur, breathingAmp));
                    }
                } else {
                    this.player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, breathingDur, breathingAmp));
                }
            }
            if (this.breathingEnabled) {
                if (this.strEnabled) {
                    if (this.player.isInWater()) {
                        this.player.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, strDur, strAmp));
                    }
                } else {
                    this.player.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, strDur, strAmp));
                }
            }
        } else {
            tasks.remove(this.player.getUniqueId());
            this.cancel();
        }
        this.containsTideArmor = false;
    }

    public void start() {
        int tickPeriod = this.config.getInt("Abilities.TideGuardian.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public Map<UUID, TideGuardianTask> getTasks() {
        return tasks;
    }
}

