/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.ntp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.val_mobile.ntp.NtpModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FireStarterTask
extends BukkitRunnable {
    private static final Map<UUID, FireStarterTask> tasks = new HashMap<UUID, FireStarterTask>();
    private final Collection<Item> ingredients;
    private final Player player;
    private final Set<String> allowedWorlds;
    private final UUID id;
    private final RSVPlugin plugin;
    private final Location loc;
    private final int duration;
    private final boolean isSoulCampfire;
    private final double soundChance;
    private final boolean emitSound;
    private final String sound;
    private final float volume;
    private final float pitch;
    private final double particleChance;
    private final boolean emitParticles;
    private final Particle particle;
    private final int minCount;
    private final int maxCount;
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;
    private final double extra;
    private Particle.DustOptions dust;
    private int ticks = 0;

    public FireStarterTask(RSVPlugin plugin, NtpModule module, Player player, Location loc, Collection<Item> ingredients, boolean isSoulCampfire) {
        this.ingredients = ingredients;
        this.loc = loc;
        this.id = player.getUniqueId();
        this.plugin = plugin;
        this.player = player;
        FileConfiguration config = module.getUserConfig().getConfig();
        this.allowedWorlds = module.getAllowedWorlds();
        this.duration = config.getInt("FireStarter.Time");
        this.isSoulCampfire = isSoulCampfire;
        this.soundChance = config.getDouble("FireStarter.BurningSound.Chance");
        this.emitSound = config.getBoolean("FireStarter.BurningSound.Enabled");
        this.sound = config.getString("FireStarter.BurningSound.Sound");
        this.volume = (float)config.getDouble("FireStarter.BurningSound.Volume");
        this.pitch = (float)config.getDouble("FireStarter.BurningSound.Pitch");
        this.particleChance = config.getDouble("FireStarter.EmitParticles.Chance");
        this.emitParticles = config.getBoolean("FireStarter.EmitParticles.Enabled");
        this.minCount = config.getInt("FireStarter.EmitParticles.MinCount");
        this.maxCount = config.getInt("FireStarter.EmitParticles.MaxCount");
        this.xOffset = config.getDouble("FireStarter.EmitParticles.x-Offset");
        this.yOffset = config.getDouble("FireStarter.EmitParticles.y-Offset");
        this.zOffset = config.getDouble("FireStarter.EmitParticles.z-Offset");
        this.extra = config.getDouble("FireStarter.EmitParticles.Extra");
        this.particle = Particle.valueOf((String)config.getString("FireStarter.EmitParticles.Particle"));
        if (this.particle == Particle.REDSTONE) {
            String color = config.getString("FireStarter.EmitParticles.DustOptionColor");
            float size = (float)config.getDouble("FireStarter.EmitParticles.DustOptionSize");
            if (color.contains("|")) {
                int first = color.indexOf("|");
                int second = color.lastIndexOf("|");
                int red = Integer.parseInt(color.substring(0, first));
                int green = Integer.parseInt(color.substring(first + 1, second));
                int blue = Integer.parseInt(color.substring(second + 1));
                this.dust = new Particle.DustOptions(Color.fromRGB((int)red, (int)green, (int)blue), size);
            } else {
                this.dust = new Particle.DustOptions(Utils.valueOfColor(color), size);
            }
        }
        tasks.put(this.id, this);
    }

    public void run() {
        if (this.player == null) {
            this.stop();
        } else if (this.player.isOnline() && this.allowedWorlds.contains(this.player.getWorld().getName()) && this.loc.getBlock().isPassable() && RSVItem.isHoldingItem("fire_starter", this.player) && this.validateItems() && this.player.isSneaking()) {
            ++this.ticks;
            if (this.ticks > this.duration) {
                this.loc.getWorld().getBlockAt(this.loc).setType(this.isSoulCampfire ? Material.SOUL_CAMPFIRE : Material.CAMPFIRE);
                this.ingredients.forEach(Entity::remove);
                this.stop();
            } else {
                if (this.emitSound && Utils.roll(this.soundChance)) {
                    Utils.playSound(this.loc, this.sound, this.volume, this.pitch);
                }
                if (this.emitParticles && Utils.roll(this.particleChance)) {
                    this.loc.getWorld().spawnParticle(this.particle, this.loc, Utils.getRandomNum(this.minCount, this.maxCount), this.xOffset, this.yOffset, this.zOffset, this.extra, (Object)this.dust);
                }
            }
        } else {
            this.stop();
        }
    }

    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public static Map<UUID, FireStarterTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public boolean validateItems() {
        for (Item item : this.ingredients) {
            if (item != null && item.isValid()) continue;
            return false;
        }
        return true;
    }
}

