/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanandfire;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ElectrocuteTask
extends BukkitRunnable {
    private static final Map<UUID, ElectrocuteTask> tasks = new HashMap<UUID, ElectrocuteTask>();
    private final Damageable entity;
    private final RSVPlugin plugin;
    private final FileConfiguration config;
    private final double shockDamage;
    private int shockAmount;
    private final int tickPeriod;

    public ElectrocuteTask(RSVPlugin plugin, int stage, Damageable entity) {
        this.entity = entity;
        this.plugin = plugin;
        this.config = RSVModule.getModule("IceandFire").getUserConfig().getConfig();
        this.shockDamage = this.config.getDouble("Dragon.LightningDragon.ElectrocuteAbility.ShockDamage.Stage" + stage);
        this.shockAmount = this.config.getInt("Dragon.LightningDragon.ElectrocuteAbility.ShockAmount.Stage" + stage);
        this.tickPeriod = this.config.getInt("Dragon.LightningDragon.ElectrocuteAbility.TickPeriod");
        tasks.put(entity.getUniqueId(), this);
    }

    public ElectrocuteTask(RSVPlugin plugin, RSVModule module, String itemName, Damageable entity) {
        this.entity = entity;
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.shockDamage = this.config.getDouble("Items." + itemName + ".ElectrocuteAbility.ShockDamage");
        this.shockAmount = this.config.getInt("Items." + itemName + ".ElectrocuteAbility.ShockAmount");
        this.tickPeriod = this.config.getInt("Items." + itemName + ".ElectrocuteAbility.TickPeriod");
        tasks.put(entity.getUniqueId(), this);
    }

    public void run() {
        if (this.shockAmount > 0 || this.entity.isDead()) {
            this.entity.damage(this.shockDamage);
            --this.shockAmount;
        } else {
            tasks.remove(this.entity.getUniqueId());
            this.cancel();
        }
    }

    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, this.tickPeriod);
    }

    public static Map<UUID, ElectrocuteTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

