/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.integrations.CompatiblePlugin;
import me.val_mobile.integrations.RealisticSeasons;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.utils.RSVTask;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class HyperthermiaTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, HyperthermiaTask> tasks = new HashMap<UUID, HyperthermiaTask>();
    private final TanModule module;
    private final FileConfiguration config;
    private final UUID id;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final Collection<String> allowedWorlds;
    private final boolean damageEnabled;
    private final boolean damageImmunityEnabled;
    private final double damageCutoff;
    private final double damage;
    private final boolean potionEffectsEnabled;
    private final boolean potionImmunityEnabled;
    private final boolean igniteEnabled;
    private final int igniteTicks;
    private final boolean igniteImmunityEnabled;
    private final double minTemperature;
    private final RealisticSeasons rs;
    private final Collection<PotionEffect> potionEffects = new ArrayList<PotionEffect>();

    public HyperthermiaTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.module = module;
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.damageEnabled = this.config.getBoolean("Temperature.Hyperthermia.Damage.Enabled");
        this.damageImmunityEnabled = this.config.getBoolean("Temperature.Hyperthermia.Damage.FireResistanceImmunity");
        this.damage = this.config.getDouble("Temperature.Hyperthermia.Damage.Amount");
        this.damageCutoff = this.config.getDouble("Temperature.Hyperthermia.Damage.Cutoff");
        this.potionEffectsEnabled = this.config.getBoolean("Temperature.Hyperthermia.PotionEffects.Enabled");
        this.potionImmunityEnabled = this.config.getBoolean("Temperature.Hyperthermia.PotionEffects.FireResistanceImmunity");
        this.igniteEnabled = this.config.getBoolean("Temperature.Hyperthermia.Ignite.Enabled");
        this.igniteTicks = this.config.getInt("Temperature.Hyperthermia.Ignite.FireTicks");
        this.igniteImmunityEnabled = this.config.getBoolean("Temperature.Hyperthermia.Ignite.FireResistanceImmunity");
        this.minTemperature = this.config.getDouble("Temperature.Hyperthermia.Temperature");
        this.rs = (RealisticSeasons)CompatiblePlugin.getPlugin("RealisticSeasons");
        ConfigurationSection section = this.config.getConfigurationSection("Temperature.Hyperthermia.PotionEffects.Effects");
        Set keys = section.getKeys(false);
        for (String key : keys) {
            int dur = section.getInt(key + ".Duration");
            int amp = section.getInt(key + ".Amplifier");
            this.potionEffects.add(new PotionEffect(PotionEffectType.getByName((String)key), dur, amp));
        }
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            if (!(player.hasPermission("realisticsurvival.toughasnails.resistance.hot.damage") || !this.damageEnabled || this.rs.disableHyperthermiaDamage() || !(player.getHealth() >= this.damageCutoff) || this.damageImmunityEnabled && player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE))) {
                if (player.getHealth() - this.damage <= 0.0) {
                    this.module.getHyperthermiaDeath().add(this.id);
                }
                player.damage(this.damage);
            }
            if (!(player.hasPermission("realisticsurvival.toughasnails.resistance.hot.potioneffects") || !this.potionEffectsEnabled || this.rs.disableHyperthermiaPotions() || this.potionImmunityEnabled && player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE))) {
                player.addPotionEffects(this.potionEffects);
            }
            if (!(player.hasPermission("realisticsurvival.toughasnails.resistance.hot.combustion") || !this.igniteEnabled || this.rs.disableHyperthermiaIgnite() || player.getFireTicks() >= this.igniteTicks || this.igniteImmunityEnabled && player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE))) {
                player.setFireTicks(this.igniteTicks);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && !player.isDead() && this.allowedWorlds.contains(player.getWorld().getName()) && this.module.getTempManager().getTemperature(player) > this.minTemperature;
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Temperature.Hyperthermia.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, HyperthermiaTask> getTasks() {
        return tasks;
    }
}

