/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SweatTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, SweatTask> tasks = new HashMap<UUID, SweatTask>();
    private final TempManager manager;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final double chance;
    private final double minTemperature;
    private final int minCount;
    private final int maxCount;
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;
    private final double extra;
    private final Particle particle;
    private Particle.DustOptions dust;

    public SweatTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.manager = module.getTempManager();
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.chance = this.config.getDouble("Temperature.Sweating.Chance");
        this.minTemperature = this.config.getDouble("Temperature.Sweating.MinimumTemperature");
        this.minCount = this.config.getInt("Temperature.Sweating.MinCount");
        this.maxCount = this.config.getInt("Temperature.Sweating.MaxCount");
        this.xOffset = this.config.getDouble("Temperature.Sweating.x-Offset");
        this.yOffset = this.config.getDouble("Temperature.Sweating.y-Offset");
        this.zOffset = this.config.getDouble("Temperature.Sweating.z-Offset");
        this.extra = this.config.getDouble("Temperature.Sweating.Extra");
        this.particle = Particle.valueOf((String)this.config.getString("Temperature.Sweating.Particle"));
        if (this.particle == Particle.REDSTONE) {
            String color = this.config.getString("Temperature.Sweating.DustOptionColor");
            float size = (float)this.config.getDouble("Temperature.Sweating.DustOptionSize");
            if (color.contains("|")) {
                int first = color.indexOf("|");
                int second = color.lastIndexOf("|");
                int red = Integer.parseInt(color.substring(0, first));
                int green = Integer.parseInt(color.substring(first + 1, second));
                int blue = Integer.parseInt(color.substring(second + 1));
                this.dust = new Particle.DustOptions(Color.fromRGB((int)red, (int)green, (int)blue), size);
            } else {
                this.dust = new Particle.DustOptions(Utils.valueOfColor(color), size);
            }
        }
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            if (!player.hasPermission("realisticsurvival.toughasnails.resistance.hot.sweat") && Utils.roll(this.chance)) {
                Vector dir = player.getLocation().clone().subtract(0.0, 0.5, 0.0).getDirection().normalize().multiply(0.5);
                player.spawnParticle(this.particle, player.getEyeLocation().add(dir), Utils.getRandomNum(this.minCount, this.maxCount), this.xOffset, this.yOffset, this.zOffset, this.extra, (Object)this.dust);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && !player.isDead() && this.allowedWorlds.contains(player.getWorld().getName()) && this.manager.getTemperature(player) > this.minTemperature;
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Temperature.Sweating.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, SweatTask> getTasks() {
        return tasks;
    }
}

