/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.val_mobile.data.ModuleEvents;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.data.baubles.DataModule;
import me.val_mobile.misc.PlayerItemAcquireEvent;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.DehydrationTask;
import me.val_mobile.tan.HyperthermiaTask;
import me.val_mobile.tan.HypothermiaTask;
import me.val_mobile.tan.ParasiteTask;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.TemperatureCalculateTask;
import me.val_mobile.tan.TemperatureEnvironmentTask;
import me.val_mobile.tan.ThermometerTask;
import me.val_mobile.tan.ThirstCalculateTask;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.DisplayTask;
import me.val_mobile.utils.PlayerJumpEvent;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;
import org.bukkit.util.RayTraceResult;

public class TanEvents
extends ModuleEvents
implements Listener {
    private final RSVPlugin plugin;
    private final FileConfiguration config;
    private final boolean tempEnabled;
    private final TanModule module;
    private final boolean thirstEnabled;
    private final TempManager tempManager;
    private final ThirstManager thirstManager;

    public TanEvents(TanModule module, RSVPlugin plugin) {
        super(module, plugin);
        this.module = module;
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.tempEnabled = module.isTempGloballyEnabled();
        this.thirstEnabled = module.isThirstGloballyEnabled();
        this.tempManager = module.getTempManager();
        this.thirstManager = module.getThirstManager();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !this.tempEnabled && !this.thirstEnabled || !RSVPlayer.isValidPlayer(player)) {
            return;
        }
        RSVPlayer rsvplayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        if (this.tempEnabled) {
            if (!TemperatureCalculateTask.hasTask(player.getUniqueId())) {
                new TemperatureCalculateTask(this.module, this.plugin, rsvplayer).start();
            }
            if (RSVItem.isHoldingItem("thermometer", player) && !ThermometerTask.hasTask(player.getUniqueId())) {
                new ThermometerTask(this.plugin, rsvplayer).start();
            }
        }
        if (this.thirstEnabled && !ThirstCalculateTask.hasTask(player.getUniqueId())) {
            new ThirstCalculateTask(this.module, this.plugin, rsvplayer).start();
        }
        if (!DisplayTask.hasTask(player.getUniqueId())) {
            new DisplayTask(this.plugin, rsvplayer).start();
        }
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player) || !this.thirstManager.isThirstEnabled(player)) {
            return;
        }
        if (player.isSprinting()) {
            this.thirstManager.addExhaustion(player, this.config.getDouble("Thirst.ExhaustionLevelIncrease.JumpingWhileSprinting"));
        } else {
            this.thirstManager.addExhaustion(player, this.config.getDouble("Thirst.ExhaustionLevelIncrease.Jumping"));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        int num;
        List deathMessages;
        Player player = event.getEntity();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        UUID id = player.getUniqueId();
        if (this.thirstEnabled) {
            this.thirstManager.setThirst(player, this.config.getInt("Thirst.DefaultThirst"));
            this.thirstManager.setSaturation(player, this.config.getInt("Thirst.DefaultSaturation"));
            if (this.module.getDehydrationDeath().contains(id)) {
                if (this.config.getBoolean("DehydrationDeath.Enabled")) {
                    deathMessages = this.config.getStringList("DehydrationDeath.Messages");
                    num = Utils.getRandomNum(0, deathMessages.size() - 1);
                    event.setDeathMessage(Utils.translateMsg((String)deathMessages.get(num), (CommandSender)player, Map.of("PLAYER_NAME", player.getDisplayName())));
                }
                this.module.getDehydrationDeath().remove(id);
            } else if (this.module.getParasiteDeath().contains(id)) {
                if (this.config.getBoolean("ParasiteDeath.Enabled")) {
                    deathMessages = this.config.getStringList("ParasiteDeath.Messages");
                    num = Utils.getRandomNum(0, deathMessages.size() - 1);
                    event.setDeathMessage(Utils.translateMsg((String)deathMessages.get(num), (CommandSender)player, Map.of("PLAYER_NAME", player.getDisplayName())));
                }
                this.module.getParasiteDeath().remove(id);
            }
        }
        if (this.tempEnabled) {
            this.tempManager.setTemperature(player, this.config.getDouble("Temperature.DefaultTemperature"));
            if (this.module.getHyperthermiaDeath().contains(id)) {
                if (this.config.getBoolean("HyperthermiaDeath.Enabled")) {
                    deathMessages = this.config.getStringList("HyperthermiaDeath.Messages");
                    num = Utils.getRandomNum(0, deathMessages.size() - 1);
                    event.setDeathMessage(Utils.translateMsg((String)deathMessages.get(num), (CommandSender)player, Map.of("PLAYER_NAME", player.getDisplayName())));
                }
                this.module.getHyperthermiaDeath().remove(id);
            } else if (this.module.getHypothermiaDeath().contains(id)) {
                if (this.config.getBoolean("HypothermiaDeath.Enabled")) {
                    deathMessages = this.config.getStringList("HypothermiaDeath.Messages");
                    num = Utils.getRandomNum(0, deathMessages.size() - 1);
                    event.setDeathMessage(Utils.translateMsg((String)deathMessages.get(num), (CommandSender)player, Map.of("PLAYER_NAME", player.getDisplayName())));
                }
                this.module.getHypothermiaDeath().remove(id);
            }
        }
        if (HypothermiaTask.hasTask(id)) {
            HypothermiaTask.getTasks().get(id).cancel();
            HypothermiaTask.getTasks().remove(id);
        }
        if (HyperthermiaTask.hasTask(id)) {
            HyperthermiaTask.getTasks().get(id).cancel();
            HyperthermiaTask.getTasks().remove(id);
        }
        if (DehydrationTask.hasTask(id)) {
            DehydrationTask.getTasks().get(id).cancel();
            DehydrationTask.getTasks().remove(id);
        }
        if (ParasiteTask.hasTask(id)) {
            ParasiteTask.getTasks().get(id).cancel();
            ParasiteTask.getTasks().remove(id);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        UUID id = player.getUniqueId();
        if (DisplayTask.hasTask(id)) {
            DisplayTask.getTasks().get(id).setParasitesActive(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode mode = event.getNewGameMode();
        if (!this.shouldEventBeRan((Entity)player) || !RSVPlayer.isValidPlayer(player) || mode != GameMode.SURVIVAL && mode != GameMode.ADVENTURE || !this.tempEnabled && !this.thirstEnabled) {
            return;
        }
        RSVPlayer rsvplayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        if (this.tempEnabled && !TemperatureCalculateTask.hasTask(player.getUniqueId())) {
            new TemperatureCalculateTask(this.module, this.plugin, rsvplayer).start();
        }
        if (this.thirstEnabled && !ThirstCalculateTask.hasTask(player.getUniqueId())) {
            new ThirstCalculateTask(this.module, this.plugin, rsvplayer).start();
        }
        if (!DisplayTask.hasTask(player.getUniqueId())) {
            new DisplayTask(this.plugin, rsvplayer).start();
        }
    }

    @EventHandler
    public void onDrink(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        GameMode mode = player.getGameMode();
        if (!this.thirstManager.isThirstEnabled(player) || mode != GameMode.SURVIVAL && mode != GameMode.ADVENTURE) {
            return;
        }
        Action action = event.getAction();
        boolean parasites = false;
        switch (action) {
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: {
                String name;
                ItemStack item;
                RayTraceResult test;
                Block block;
                Location playerLoc = player.getLocation();
                Location eye = player.getEyeLocation().add(player.getLocation().getDirection());
                if (this.config.getBoolean("Thirst.SaturationRestoration.Drinking.Enabled") && player.isSneaking()) {
                    double maxDistance = this.config.getDouble("Thirst.SaturationRestoration.Drinking.MaxDistance");
                    RayTraceResult result = player.getWorld().rayTraceBlocks(player.getEyeLocation(), eye.getDirection(), maxDistance, FluidCollisionMode.ALWAYS, true);
                    if (result != null && result.getHitBlock() != null && (block = result.getHitBlock()).getType() == Material.WATER && Utils.isSourceLiquid(block)) {
                        int thirstPoints = this.config.getInt("Thirst.SaturationRestoration.Drinking.ThirstPoints");
                        int saturationPoints = this.config.getInt("Thirst.SaturationRestoration.Drinking.SaturationPoints");
                        this.thirstManager.addThirst(player, thirstPoints);
                        this.thirstManager.addSaturation(player, saturationPoints);
                        if (this.config.getBoolean("Thirst.SaturationRestoration.Drinking.Sound.Enabled")) {
                            String soundName = this.config.getString("Thirst.SaturationRestoration.Drinking.Sound.Sound");
                            float volume = (float)this.config.getDouble("Thirst.SaturationRestoration.Drinking.Sound.Volume");
                            float pitch = (float)this.config.getDouble("Thirst.SaturationRestoration.Drinking.Sound.Pitch");
                            Utils.playSound(playerLoc, soundName, volume, pitch);
                        }
                        Location waterSourceLoc = block.getLocation();
                        World world = waterSourceLoc.getWorld();
                        int airAmount = 0;
                        int caveAirAmount = 0;
                        for (int x = -3; x < 2; ++x) {
                            for (int y = -3; y < 2; ++y) {
                                for (int z = -3; z < 2; ++z) {
                                    Block air = world.getBlockAt(x + (int)waterSourceLoc.getX(), y + (int)waterSourceLoc.getY(), z + (int)waterSourceLoc.getZ());
                                    if (air.getType() == Material.AIR) {
                                        ++airAmount;
                                        continue;
                                    }
                                    if (air.getType() != Material.CAVE_AIR) continue;
                                    ++caveAirAmount;
                                }
                            }
                        }
                        if (caveAirAmount > airAmount) {
                            if (this.config.getBoolean("Thirst.Parasites.CaveWater.Enabled") && Utils.roll(this.config.getDouble("Thirst.Parasites.CaveWater.Chance"))) {
                                parasites = true;
                            }
                        } else {
                            Biome biome = block.getBiome();
                            switch (biome) {
                                case RIVER: 
                                case FROZEN_RIVER: {
                                    if (!this.config.getBoolean("Thirst.Parasites.RiverWater.Enabled") || !Utils.roll(this.config.getDouble("Thirst.Parasites.RiverWater.Chance"))) break;
                                    parasites = true;
                                    break;
                                }
                                case OCEAN: 
                                case COLD_OCEAN: 
                                case DEEP_LUKEWARM_OCEAN: 
                                case LUKEWARM_OCEAN: 
                                case DEEP_OCEAN: 
                                case DEEP_COLD_OCEAN: 
                                case DEEP_FROZEN_OCEAN: 
                                case FROZEN_OCEAN: 
                                case DEEP_WARM_OCEAN: 
                                case WARM_OCEAN: {
                                    if (!this.config.getBoolean("Thirst.Parasites.SeaWater.Enabled") || !Utils.roll(this.config.getDouble("Thirst.Parasites.SeaWater.Chance"))) break;
                                    parasites = true;
                                    break;
                                }
                                default: {
                                    if (!this.config.getBoolean("Thirst.Parasites.RegularWater.Enabled") || !Utils.roll(this.config.getDouble("Thirst.Parasites.RegularWater.Chance"))) break;
                                    parasites = true;
                                }
                            }
                        }
                    }
                }
                if ((test = player.getWorld().rayTraceBlocks(player.getEyeLocation(), eye.getDirection(), 5.0, FluidCollisionMode.ALWAYS, true)) == null || (block = test.getHitBlock()) == null || !RSVItem.isRSVItem(item = event.getItem()) || !(name = RSVItem.getNameFromItem(item)).equals("canteen_empty") && !name.equals("canteen_filled")) break;
                if (block.getType() == Material.WATER && Utils.isSourceLiquid(block)) {
                    EquipmentSlot hand;
                    if (this.canFill(item, "Unpurified Water") && (hand = Utils.getSlotContainingRsvItem(player, name)) != null) {
                        if (hand == EquipmentSlot.HAND) {
                            player.getInventory().setItemInMainHand(this.fillCanteen(item, "Unpurified Water", 1));
                        } else {
                            player.getInventory().setItemInOffHand(this.fillCanteen(item, "Unpurified Water", 1));
                        }
                    }
                    event.setCancelled(true);
                    break;
                }
                if (block.getType() != Material.CAULDRON && !block.getType().toString().equals("WATER_CAULDRON")) break;
                event.setCancelled(true);
                break;
            }
            case LEFT_CLICK_AIR: {
                if (!this.config.getBoolean("Thirst.SaturationRestoration.Raining.Enabled") || !player.getWorld().hasStorm() || !Utils.canRain(player.getLocation()) || !Utils.isExposedToSky(player) || !((double)Math.abs(player.getLocation().getPitch() + 90.0f) < 0.01)) break;
                Location loc = player.getLocation();
                int thirstPoints = this.config.getInt("Thirst.SaturationRestoration.Raining.ThirstPoints");
                int saturationPoints = this.config.getInt("Thirst.SaturationRestoration.Raining.SaturationPoints");
                this.thirstManager.addThirst(player, thirstPoints);
                this.thirstManager.addSaturation(player, saturationPoints);
                if (this.config.getBoolean("Thirst.SaturationRestoration.Raining.Sound.Enabled")) {
                    String soundName = this.config.getString("Thirst.SaturationRestoration.Raining.Sound.Sound");
                    float volume = (float)this.config.getDouble("Thirst.SaturationRestoration.Raining.Sound.Volume");
                    float pitch = (float)this.config.getDouble("Thirst.SaturationRestoration.Raining.Sound.Pitch");
                    Utils.playSound(loc, soundName, volume, pitch);
                }
                if (!this.config.getBoolean("Thirst.Parasites.Rain.Enabled") || !Utils.roll(this.config.getDouble("Thirst.Parasites.Rain.Chance"))) break;
                parasites = true;
            }
        }
        boolean hasStoneSea = false;
        if (RSVPlayer.isValidPlayer(player)) {
            DataModule dataModule = RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule();
            RSVModule baubleModule = RSVModule.getModule("Baubles");
            boolean bl = hasStoneSea = baubleModule.isEnabled((Entity)player) && baubleModule.getUserConfig().getConfig().getBoolean("Items.stone_sea.ParasiteImmunity") && dataModule != null && dataModule.hasBauble("stone_sea");
        }
        if (parasites && !ParasiteTask.hasTask(player.getUniqueId()) && !hasStoneSea) {
            new ParasiteTask(this.module, this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).start();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCampfireInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (!this.tempManager.isTempEnabled(player) || event.useInteractedBlock() != Event.Result.ALLOW || event.getAction() != Action.RIGHT_CLICK_BLOCK || block == null || block.getType() != Material.CAMPFIRE && block.getType() != Material.SOUL_CAMPFIRE) {
            return;
        }
        ItemStack item = event.getItem();
        if (Utils.isItemReal(item) && (item.getType() == Material.WATER_BUCKET || item.getType().toString().contains("SHOVEL") || item.getType() == Material.FLINT_AND_STEEL)) {
            new TemperatureEnvironmentTask(this.module, this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).runTaskLaterAsynchronously((Plugin)this.plugin, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSplashPotionLand(PotionSplashEvent event) {
        if (!this.shouldEventBeRan((Entity)event.getPotion())) {
            return;
        }
        Location loc = event.getPotion().getLocation();
        double rad = this.config.getDouble("Temperature.Environment.CubeLength");
        Collection nearby = loc.getWorld().getNearbyEntities(loc, rad, rad, rad, entity -> entity instanceof Player);
        nearby.forEach(entity -> new TemperatureEnvironmentTask(this.module, this.plugin, RSVPlayer.getPlayers().get(entity.getUniqueId())).runTaskLaterAsynchronously((Plugin)this.plugin, 1L));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlamingProjectileLand(ProjectileHitEvent event) {
        Arrow arrow;
        Projectile projectile;
        if (!this.shouldEventBeRan((Entity)event.getEntity()) || (!((projectile = event.getEntity()) instanceof Arrow) || (arrow = (Arrow)projectile).getFireTicks() <= 0) && !(event.getEntity() instanceof Fireball) || event.getHitBlock() == null || event.getHitBlock().getType() != Material.CAMPFIRE && event.getHitBlock().getType() != Material.SOUL_CAMPFIRE) {
            return;
        }
        Location loc = event.getEntity().getLocation();
        double rad = this.config.getDouble("Temperature.Environment.CubeLength");
        Collection nearby = loc.getWorld().getNearbyEntities(loc, rad, rad, rad, entity -> {
            Player player;
            return entity instanceof Player && RSVPlayer.isValidPlayer(player = (Player)entity);
        });
        nearby.forEach(entity -> new TemperatureEnvironmentTask(this.module, this.plugin, RSVPlayer.getPlayers().get(entity.getUniqueId())).runTaskLaterAsynchronously((Plugin)this.plugin, 1L));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        GameMode mode = player.getGameMode();
        if (!this.shouldEventBeRan((Entity)player) || mode != GameMode.SURVIVAL && mode != GameMode.ADVENTURE) {
            return;
        }
        ItemStack item = event.getItem();
        String name = RSVItem.isRSVItem(item) ? RSVItem.getNameFromItem(item) : item.getType().toString();
        Set keys = this.config.getConfigurationSection("Thirst.SaturationRestoration.Foods").getKeys(false);
        if (name == null || !this.thirstManager.isThirstEnabled(player)) {
            return;
        }
        if (keys.contains(name)) {
            RSVModule baubleModule;
            int thirstPoints = this.config.getInt("Thirst.SaturationRestoration.Foods." + name + ".ThirstPoints");
            int saturationPoints = this.config.getInt("Thirst.SaturationRestoration.Foods." + name + ".SaturationPoints");
            this.thirstManager.addThirst(player, thirstPoints);
            this.thirstManager.addSaturation(player, saturationPoints);
            DataModule dataModule = RSVPlayer.getPlayers().get(player.getUniqueId()).getBaubleDataModule();
            if (!(!name.equals(item.getType().toString()) || item.getType() != Material.POTION || ((PotionMeta)item.getItemMeta()).getBasePotionData().getType() != PotionType.WATER || (baubleModule = RSVModule.getModule("Baubles")).isGloballyEnabled() && baubleModule.getUserConfig().getConfig().getBoolean("Items.stone_sea.ParasiteImmunity") && dataModule != null && dataModule.hasBauble("stone_sea") || !this.config.getBoolean("Thirst.Parasites.UnpurifiedWaterBottle.Enabled") || !Utils.roll(this.config.getDouble("Thirst.Parasites.UnpurifiedWaterBottle.Chance")) || ParasiteTask.hasTask(player.getUniqueId()))) {
                new ParasiteTask(this.module, this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).start();
            }
            if (name.equals("juice_chorus_fruit") && this.config.getBoolean("Items.juice_chorus_fruit.Teleport.Enabled")) {
                Location loc = player.getLocation();
                Utils.randomTpSafely((Entity)player, this.config.getDouble("Items.juice_chorus_fruit.Teleport.MaxRadius"));
                if (this.config.getBoolean("Items.juice_chorus_fruit.Teleport.Sound.Enabled")) {
                    String soundName = this.config.getString("Items.juice_chorus_fruit.Teleport.Sound.Sound");
                    float volume = (float)this.config.getDouble("Items.juice_chorus_fruit.Teleport.Sound.Volume");
                    float pitch = (float)this.config.getDouble("Items.juice_chorus_fruit.Teleport.Sound.Pitch");
                    Utils.playSound(loc, soundName, volume, pitch);
                }
            }
        } else if (name.equals("canteen_filled")) {
            String canteenDrink = (String)Utils.getNbtTag(item, "rsvdrink", PersistentDataType.STRING);
            if (canteenDrink.equals("Unpurified Water")) {
                int thirstPoints = this.config.getInt("Thirst.SaturationRestoration.Foods.POTION.ThirstPoints");
                int saturationPoints = this.config.getInt("Thirst.SaturationRestoration.Foods.POTION.SaturationPoints");
                if (this.config.getBoolean("Thirst.Parasites.UnpurifiedWaterBottle.Enabled") && Utils.roll(this.config.getDouble("Thirst.Parasites.UnpurifiedWaterBottle.Chance")) && !ParasiteTask.hasTask(player.getUniqueId())) {
                    new ParasiteTask(this.module, this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).start();
                }
                this.thirstManager.addThirst(player, thirstPoints);
                this.thirstManager.addSaturation(player, saturationPoints);
            } else {
                String drink = canteenDrink.toLowerCase().replace(' ', '_');
                int thirstPoints = this.config.getInt("Thirst.SaturationRestoration.Foods." + drink + ".ThirstPoints");
                int saturationPoints = this.config.getInt("Thirst.SaturationRestoration.Foods." + drink + ".SaturationPoints");
                this.thirstManager.addThirst(player, thirstPoints);
                this.thirstManager.addSaturation(player, saturationPoints);
            }
            EquipmentSlot hand = Utils.getSlotContainingRsvItem(player, name);
            if (hand != null) {
                if (hand == EquipmentSlot.HAND) {
                    player.getInventory().setItemInMainHand(this.fillCanteen(item, canteenDrink, -1));
                } else {
                    player.getInventory().setItemInOffHand(this.fillCanteen(item, canteenDrink, -1));
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        Player player;
        Entity e = event.getEntity();
        if (!this.shouldEventBeRan(e) || !(e instanceof Player) || (player = (Player)e).getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        UUID id = player.getUniqueId();
        if (this.thirstEnabled) {
            if (event.isCancelled()) {
                this.module.getDehydrationDeath().remove(id);
                this.module.getParasiteDeath().remove(id);
            } else if (this.thirstManager.isThirstEnabled(player)) {
                if (event.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
                    if (this.config.getBoolean("Thirst.SaturationRestoration.Drowning.Enabled")) {
                        int thirstPoints = this.config.getInt("Thirst.SaturationRestoration.Drowning.ThirstPoints");
                        int saturationPoints = this.config.getInt("Thirst.SaturationRestoration.Drowning.SaturationPoints");
                        this.thirstManager.addThirst(player, thirstPoints);
                        this.thirstManager.addSaturation(player, saturationPoints);
                    }
                    if (this.config.getBoolean("Thirst.Parasites.Drowning.Enabled") && Utils.roll(this.config.getDouble("Thirst.Parasites.Drowning.Chance")) && !ParasiteTask.hasTask(player.getUniqueId())) {
                        new ParasiteTask(this.module, this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).start();
                    }
                }
                double parasiteExhaustionMultiplier = this.config.getBoolean("Thirst.Parasites.MultiplyExhaustionRates.Enabled") ? this.config.getDouble("Thirst.Parasites.MultiplyExhaustionRates.Value") : 1.0;
                this.thirstManager.setExhaustion(player, this.thirstManager.getExhaustion(player) + this.config.getDouble("Thirst.ExhaustionLevelIncrease.TakingDamage") * parasiteExhaustionMultiplier);
            }
            if (player.getHealth() - event.getFinalDamage() > 0.0) {
                this.module.getDehydrationDeath().remove(id);
                this.module.getParasiteDeath().remove(id);
            }
        }
        if (this.tempEnabled && (player.getHealth() - event.getFinalDamage() > 0.0 || event.isCancelled())) {
            this.module.getHyperthermiaDeath().remove(id);
            this.module.getHypothermiaDeath().remove(id);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRegenerate(EntityRegainHealthEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.thirstManager.isThirstEnabled(player = (Player)entity) && event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            this.thirstManager.addExhaustion(player, this.config.getDouble("Thirst.ExhaustionLevelIncrease.RegeneratingHealth"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpongeAbsorb(SpongeAbsorbEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFluidLevelChange(FluidLevelChangeEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLeafDecay(LeavesDecayEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCauldronLevel(CauldronLevelChangeEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        this.adjustEnvTemp((Cancellable)event);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        String oldWorld = event.getFrom().toString();
        if (!this.shouldEventBeRan((Entity)player) || !RSVPlayer.isValidPlayer(player) || this.module.getAllowedWorlds().contains(oldWorld) || !this.tempEnabled && !this.thirstEnabled) {
            return;
        }
        RSVPlayer rsvplayer = RSVPlayer.getPlayers().get(player.getUniqueId());
        if (this.tempEnabled) {
            if (!TemperatureCalculateTask.hasTask(player.getUniqueId())) {
                new TemperatureCalculateTask(this.module, this.plugin, rsvplayer).start();
            }
            if (RSVItem.isHoldingItem("thermometer", player) && !ThermometerTask.hasTask(player.getUniqueId())) {
                new ThermometerTask(this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).start();
            }
        }
        if (this.thirstEnabled && !ThirstCalculateTask.hasTask(player.getUniqueId())) {
            new ThirstCalculateTask(this.module, this.plugin, rsvplayer).start();
        }
        if (!DisplayTask.hasTask(player.getUniqueId())) {
            new DisplayTask(this.plugin, rsvplayer).start();
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (!this.shouldEventBeRan((Entity)event.getView().getPlayer())) {
            return;
        }
        ItemStack[] matrix = event.getInventory().getMatrix();
        int canteenIndex = -1;
        int juiceIndex = -1;
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (RSVItem.isRSVItem(item)) {
                String name = RSVItem.getNameFromItem(item);
                if (name.equals("canteen_empty") || name.equals("canteen_filled")) {
                    canteenIndex = canteenIndex == -1 ? i : -2;
                    continue;
                }
                if (!name.contains("juice") && !name.equals("purified_water_bottle")) continue;
                juiceIndex = juiceIndex == -1 ? i : -2;
                continue;
            }
            if (!Utils.isItemReal(item) || item.getType() != Material.POTION) continue;
            juiceIndex = juiceIndex == -1 ? i : -2;
        }
        if (canteenIndex > -1 && juiceIndex > -1) {
            ItemStack canteen = matrix[canteenIndex];
            ItemStack juice = matrix[juiceIndex];
            if (canteen.getAmount() == 1 && juice.getAmount() == 1) {
                String drinkName;
                String string = drinkName = RSVItem.isRSVItem(juice) ? RSVItem.getNameFromItem(juice) : "Unpurified Water";
                if (this.canFill(canteen, drinkName)) {
                    ItemStack copy = canteen.clone();
                    event.getInventory().setResult(this.fillCanteen(copy, drinkName, 1));
                }
            }
        }
    }

    @EventHandler
    public void onItemAcquire(PlayerItemAcquireEvent event) {
        ItemStack item = event.getItem();
        EquipmentSlot loc = event.getLocation();
        if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).equals("thermometer") || loc != EquipmentSlot.HAND && loc != EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (RSVPlayer.isValidPlayer(player) && player.isOnline() && !ThermometerTask.hasTask(player.getUniqueId())) {
            new ThermometerTask(this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).start();
        }
    }

    private boolean canFill(ItemStack canteen, String newDrink) {
        String originalDrink = (String)Utils.getNbtTag(canteen, "rsvdrink", PersistentDataType.STRING);
        if (Utils.getCustomDurability(canteen) >= Utils.getMaxCustomDurability(canteen)) {
            return false;
        }
        if (!originalDrink.equals("None")) {
            return originalDrink.equals(newDrink);
        }
        return true;
    }

    private ItemStack fillCanteen(ItemStack canteen, String drink, int change) {
        int durability = Utils.getCustomDurability(canteen);
        int sum = durability + change;
        ItemMeta meta = canteen.getItemMeta();
        if (sum < 1) {
            if (meta.getDisplayName().equals(RSVItem.getItem("canteen_filled").getItemMeta().getDisplayName())) {
                meta.setDisplayName(RSVItem.getItem("canteen_empty").getItemMeta().getDisplayName());
            }
            int customModelData = RSVItem.getItem("canteen_empty").getItemMeta().getCustomModelData();
            NamespacedKey itemModel = Utils.getItemModel(RSVItem.getItem("canteen_empty").getItemMeta());
            if (!meta.hasCustomModelData()) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
                canteen.setItemMeta(meta);
            } else if (meta.getCustomModelData() != customModelData) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
                canteen.setItemMeta(meta);
            }
            if (!Utils.hasItemModel(meta)) {
                Utils.setItemModel(meta, itemModel);
                canteen.setItemMeta(meta);
            } else if (Utils.getItemModel(meta) != itemModel) {
                Utils.setItemModel(meta, itemModel);
                canteen.setItemMeta(meta);
            }
            Utils.addNbtTag(canteen, "rsvitem", "canteen_empty", PersistentDataType.STRING);
            Utils.addNbtTag(canteen, "rsvdrink", "None", PersistentDataType.STRING);
            canteen.setType(Material.GLASS_BOTTLE);
        } else {
            if (meta.getDisplayName().equals(RSVItem.getItem("canteen_empty").getItemMeta().getDisplayName())) {
                meta.setDisplayName(RSVItem.getItem("canteen_filled").getItemMeta().getDisplayName());
            }
            int customModelData = RSVItem.getItem("canteen_filled").getItemMeta().getCustomModelData();
            NamespacedKey itemModel = Utils.getItemModel(RSVItem.getItem("canteen_filled").getItemMeta());
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            if (!meta.hasCustomModelData()) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
                canteen.setItemMeta(meta);
            } else if (meta.getCustomModelData() != customModelData) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
                canteen.setItemMeta(meta);
            }
            if (!Utils.hasItemModel(meta)) {
                Utils.setItemModel(meta, itemModel);
                canteen.setItemMeta(meta);
            } else if (Utils.getItemModel(meta) != itemModel) {
                Utils.setItemModel(meta, itemModel);
                canteen.setItemMeta(meta);
            }
            Utils.addNbtTag(canteen, "rsvitem", "canteen_filled", PersistentDataType.STRING);
            Utils.addNbtTag(canteen, "rsvdrink", drink, PersistentDataType.STRING);
            canteen.setType(Material.POTION);
        }
        Utils.changeDurability(canteen, change, false, false, null);
        return canteen;
    }

    public void adjustEnvTemp(Cancellable blockEvent) {
        if (!blockEvent.isCancelled()) {
            ConfigurationSection section;
            Block block = null;
            BlockData data1 = null;
            BlockData data2 = null;
            World world = null;
            boolean singleBlock = true;
            if (blockEvent instanceof BlockPlaceEvent) {
                BlockPlaceEvent event = (BlockPlaceEvent)blockEvent;
                block = event.getBlockPlaced();
                data2 = block.getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof BlockBreakEvent) {
                BlockBreakEvent event = (BlockBreakEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                world = block.getWorld();
                this.thirstManager.addExhaustion(event.getPlayer(), this.config.getDouble("Thirst.ExhaustionLevelIncrease.BreakingBlock"));
            } else if (blockEvent instanceof FurnaceBurnEvent) {
                FurnaceBurnEvent event = (FurnaceBurnEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                data2 = data1.clone();
                world = block.getWorld();
                ((Lightable)data1).setLit(false);
                ((Lightable)data2).setLit(true);
            } else if (blockEvent instanceof LeavesDecayEvent) {
                LeavesDecayEvent event = (LeavesDecayEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof FluidLevelChangeEvent) {
                FluidLevelChangeEvent event = (FluidLevelChangeEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                data2 = event.getNewData();
                world = block.getWorld();
            } else if (blockEvent instanceof EntityChangeBlockEvent) {
                EntityChangeBlockEvent event = (EntityChangeBlockEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                data2 = event.getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof BlockGrowEvent) {
                BlockGrowEvent event = (BlockGrowEvent)blockEvent;
                block = event.getBlock();
                data2 = block.getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof CauldronLevelChangeEvent) {
                CauldronLevelChangeEvent event = (CauldronLevelChangeEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                data2 = event.getNewState().getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof BlockFadeEvent) {
                BlockFadeEvent event = (BlockFadeEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                data2 = event.getNewState().getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof BlockBurnEvent) {
                BlockBurnEvent event = (BlockBurnEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof BlockIgniteEvent) {
                BlockIgniteEvent event = (BlockIgniteEvent)blockEvent;
                block = event.getBlock();
                data1 = block.getBlockData();
                world = block.getWorld();
            } else if (blockEvent instanceof BlockExplodeEvent) {
                BlockExplodeEvent event = (BlockExplodeEvent)blockEvent;
                block = event.getBlock();
                world = block.getWorld();
                singleBlock = false;
            } else if (blockEvent instanceof BlockFertilizeEvent) {
                BlockFertilizeEvent event = (BlockFertilizeEvent)blockEvent;
                block = event.getBlock();
                world = block.getWorld();
                singleBlock = false;
            } else if (blockEvent instanceof SpongeAbsorbEvent) {
                SpongeAbsorbEvent event = (SpongeAbsorbEvent)blockEvent;
                block = event.getBlock();
                world = block.getWorld();
                singleBlock = false;
            }
            if (this.shouldEventBeRan(world) && (TemperatureEnvironmentTask.willAffectTemperature(data1, section = this.config.getConfigurationSection("Temperature.Environment.Blocks")) || TemperatureEnvironmentTask.willAffectTemperature(data2, section))) {
                double rad = this.config.getDouble("Temperature.Environment.CubeLength");
                Collection nearby = world.getNearbyEntities(block.getLocation(), rad, rad, rad, entity -> entity instanceof Player);
                for (Entity e : nearby) {
                    Player player = (Player)e;
                    TemperatureCalculateTask tempTask = TemperatureCalculateTask.getTasks().get(player.getUniqueId());
                    if (tempTask == null) continue;
                    if (singleBlock) {
                        double ogVal = TemperatureEnvironmentTask.getValue(data1, section);
                        double finalVal = TemperatureEnvironmentTask.getValue(data2, section);
                        double regulateEnv = tempTask.getRegulateEnv();
                        double changeEnv = tempTask.getChangeEnv();
                        if (TemperatureEnvironmentTask.isRegulatory(data1, section)) {
                            regulateEnv -= ogVal;
                        } else {
                            changeEnv -= ogVal;
                        }
                        if (TemperatureEnvironmentTask.isRegulatory(data2, section)) {
                            regulateEnv += finalVal;
                        } else {
                            changeEnv += finalVal;
                        }
                        tempTask.setRegulateEnv(regulateEnv);
                        tempTask.setChangeEnv(changeEnv);
                        continue;
                    }
                    new TemperatureEnvironmentTask(this.module, this.plugin, RSVPlayer.getPlayers().get(player.getUniqueId())).runTaskLaterAsynchronously((Plugin)this.plugin, 1L);
                }
            }
        }
    }
}

