/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.data.toughasnails.DataModule;
import me.val_mobile.tan.ParasiteTask;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.ThirstCalculateTask;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ThirstManager {
    private final TanModule module;
    private final FileConfiguration config;

    public ThirstManager(TanModule module) {
        this.module = module;
        this.config = module.getUserConfig().getConfig();
    }

    public boolean isThirstEnabled(@Nullable Player player) {
        return this.module.isThirstGloballyEnabled() && RSVPlayer.isValidPlayer(player) && this.module.isEnabled((Entity)player) && RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule() != null;
    }

    public boolean hasParasites(@Nullable Player player) {
        if (this.isThirstEnabled(player)) {
            return ParasiteTask.hasTask(player.getUniqueId());
        }
        return false;
    }

    public int getThirst(@Nullable Player player) {
        if (this.isThirstEnabled(player)) {
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                return ThirstCalculateTask.getTasks().get(player.getUniqueId()).getThirstLvl();
            }
            DataModule module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule();
            if (module != null) {
                return module.getThirst();
            }
        }
        return 0;
    }

    public int getSaturation(@Nullable Player player) {
        if (this.isThirstEnabled(player)) {
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                return ThirstCalculateTask.getTasks().get(player.getUniqueId()).getSaturationLvl();
            }
            DataModule module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule();
            if (module != null) {
                return module.getThirstSaturation();
            }
        }
        return 0;
    }

    public double getExhaustion(@Nullable Player player) {
        if (this.isThirstEnabled(player)) {
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                return ThirstCalculateTask.getTasks().get(player.getUniqueId()).getExhaustionLvl();
            }
            DataModule module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule();
            if (module != null) {
                return module.getThirstExhaustion();
            }
        }
        return 0.0;
    }

    public int getTickTimer(@Nullable Player player) {
        if (this.isThirstEnabled(player)) {
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                return ThirstCalculateTask.getTasks().get(player.getUniqueId()).getTickTimer();
            }
            DataModule module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule();
            if (module != null) {
                return module.getThirstTickTimer();
            }
        }
        return 0;
    }

    public void setSaturation(@Nullable Player player, int saturation) {
        if (this.isThirstEnabled(player)) {
            DataModule module;
            saturation = Utils.clamp(saturation, 0, this.getThirst(player));
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                ThirstCalculateTask.getTasks().get(player.getUniqueId()).setSaturationLvl(saturation);
            }
            if ((module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule()) != null) {
                module.setThirstSaturation(saturation);
            }
        }
    }

    public void addSaturation(@Nullable Player player, int saturation) {
        this.setSaturation(player, this.getSaturation(player) + saturation);
    }

    public void setExhaustion(@Nullable Player player, double exhaustion) {
        if (this.isThirstEnabled(player)) {
            DataModule module;
            exhaustion = Utils.clamp(exhaustion, 0.0, 2.147483647E9);
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                ThirstCalculateTask.getTasks().get(player.getUniqueId()).setExhaustionLvl(exhaustion);
            }
            if ((module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule()) != null) {
                module.setThirstExhaustion(exhaustion);
            }
        }
    }

    public void addExhaustion(@Nullable Player player, double exhaustion) {
        boolean hasParasites = this.hasParasites(player) && this.config.getBoolean("Thirst.Parasites.MultiplyExhaustionRates.Enabled");
        this.setExhaustion(player, this.getExhaustion(player) + (exhaustion *= hasParasites ? this.config.getDouble("Thirst.Parasites.MultiplyExhaustionRates.Value") : 1.0));
    }

    public void setTickTimer(@Nullable Player player, int tickTimer) {
        if (this.isThirstEnabled(player)) {
            DataModule module;
            tickTimer = Utils.clamp(tickTimer, 0, 80);
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                ThirstCalculateTask.getTasks().get(player.getUniqueId()).setTickTimer(tickTimer);
            }
            if ((module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule()) != null) {
                module.setThirstTickTimer(tickTimer);
            }
        }
    }

    public void addTickTimer(@Nullable Player player, int tickTimer) {
        this.setTickTimer(player, this.getTickTimer(player) + tickTimer);
    }

    public void setThirst(@Nullable Player player, int thirst) {
        if (this.isThirstEnabled(player)) {
            DataModule module;
            thirst = Utils.clamp(thirst, 0, 20);
            int saturation = Utils.clamp(this.getSaturation(player), 0, thirst);
            if (ThirstCalculateTask.hasTask(player.getUniqueId())) {
                ThirstCalculateTask.getTasks().get(player.getUniqueId()).setThirstLvl(thirst);
                ThirstCalculateTask.getTasks().get(player.getUniqueId()).setSaturationLvl(saturation);
            }
            if ((module = RSVPlayer.getPlayers().get(player.getUniqueId()).getTanDataModule()) != null) {
                module.setThirst(thirst);
                module.setThirstSaturation(saturation);
            }
        }
    }

    public void addThirst(@Nullable Player player, int thirst) {
        this.setThirst(player, this.getThirst(player) + thirst);
    }
}

