/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils.recipe;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import me.val_mobile.utils.recipe.RSVRecipe;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;

public class RSVAnvilRecipe
implements Recipe,
RSVRecipe {
    private final String name;
    private final ItemStack result;
    private final ItemStack leftIng;
    private final ItemStack rightIng;
    private final int repairCost;
    private final int maxRepairCost;

    public RSVAnvilRecipe(@Nonnull FileConfiguration config, @Nonnull String name) {
        this.name = name;
        this.result = RSVRecipe.getResult(config, name);
        this.leftIng = RSVRecipe.getItem(config, name + ".LeftIngredient.Item", name + ".LeftIngredient.Amount");
        this.rightIng = RSVRecipe.getItem(config, name + ".RightIngredient.Item", name + ".RightIngredient.Amount");
        this.repairCost = config.getInt(name + ".RepairCost");
        this.maxRepairCost = config.getInt(name + ".MaximumRepairCost");
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ItemStack getResult() {
        return this.result;
    }

    @Nonnull
    public ItemStack getLeftIngredient() {
        return this.leftIng;
    }

    @Nonnull
    public ItemStack getRightIngredient() {
        return this.rightIng;
    }

    @Nonnegative
    public int getRepairCost() {
        return this.repairCost;
    }

    @Nonnegative
    public int getMaxRepairCost() {
        return this.maxRepairCost;
    }

    public boolean isValidRecipe(@Nonnull AnvilInventory inv) {
        ItemStack firstItem = inv.getItem(0);
        ItemStack secondItem = inv.getItem(1);
        if (firstItem != null && secondItem != null) {
            ItemMeta firstMeta = firstItem.getItemMeta();
            ItemMeta secondMeta = secondItem.getItemMeta();
            if (firstMeta != null && secondMeta != null) {
                return firstMeta.equals((Object)this.leftIng.getItemMeta()) && secondMeta.equals((Object)this.rightIng.getItemMeta());
            }
        }
        return false;
    }

    public void useRecipe(@Nonnull PrepareAnvilEvent e) {
        AnvilInventory inv = e.getInventory();
        e.setResult(this.result);
        inv.setRepairCost(this.repairCost);
        inv.setMaximumRepairCost(this.maxRepairCost);
    }
}

