/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.baubles.BaubleEvents;
import me.val_mobile.baubles.WormholeInventory;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;

public class BaubleModule
extends RSVModule {
    private final RSVPlugin plugin;
    public static final String NAME = "Baubles";
    private final RSVConfig config;
    private WormholeInventory inv;
    private BaubleEvents events;
    private final Collection<UUID> brokenHeartPlayers = new ArrayList<UUID>();

    public BaubleModule(RSVPlugin plugin) {
        super(NAME, plugin, Map.of(), Map.of(RSVModule.getModule("IceandFire"), "Detected disabled Ice and Fire module. Dragon's eye recipe will be partially disabled."));
        this.plugin = plugin;
        this.config = new RSVConfig(plugin, "resources/baubles/playerdata.yml");
    }

    @Override
    public void initialize() {
        this.setUserConfig(new RSVConfig(this.plugin, "baubles.yml"));
        this.setItemConfig(new RSVConfig(this.plugin, "resources/baubles/items.yml"));
        this.setRecipeConfig(new RSVConfig(this.plugin, "resources/baubles/recipes.yml"));
        this.setModuleItems(new ModuleItems(this));
        this.setModuleRecipes(new ModuleRecipes(this, this.plugin));
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Initialize.Enabled")) {
            String message = Utils.translateMsg(config.getString("Initialize.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
        this.events = new BaubleEvents(this, this.plugin);
        this.getModuleItems().initialize();
        this.getModuleRecipes().initialize();
        this.events.initialize();
        this.inv = new WormholeInventory(this.plugin, this);
    }

    @Override
    public void shutdown() {
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Shutdown.Enabled")) {
            String message = Utils.translateMsg(config.getString("Shutdown.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
    }

    public RSVConfig getPlayerDataConfig() {
        return this.config;
    }

    public Collection<UUID> getBrokenHeartPlayers() {
        return this.brokenHeartPlayers;
    }

    public BaubleEvents getEvents() {
        return this.events;
    }

    public WormholeInventory getInv() {
        return this.inv;
    }
}

