/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BrokenHeartRepairTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, BrokenHeartRepairTask> tasks = new HashMap<UUID, BrokenHeartRepairTask>();
    private final RSVPlayer rsvPlayer;
    private final UUID id;
    private final RSVPlugin plugin;
    private final Collection<String> allowedWorlds;
    private final boolean sleepRepairEnabled;
    private final int durabilityChange;
    private final int duration;
    private int ticks = 0;

    public BrokenHeartRepairTask(RSVPlugin plugin, BaubleModule module, RSVPlayer rsvPlayer) {
        this.rsvPlayer = rsvPlayer;
        this.id = rsvPlayer.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.plugin = plugin;
        FileConfiguration config = module.getUserConfig().getConfig();
        this.duration = config.getInt("Items.broken_heart.SleepRepair.Duration");
        this.sleepRepairEnabled = config.getBoolean("Items.broken_heart.SleepRepair.Enabled");
        this.durabilityChange = config.getInt("Items.broken_heart.SleepRepair.Amount");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            ++this.ticks;
            if (this.ticks > this.duration) {
                ItemStack brokenHeart = this.rsvPlayer.getBaubleDataModule().getBaubleBag().getItem("broken_heart");
                Utils.changeDurability(brokenHeart, this.durabilityChange, false, false, (Entity)player);
                this.stop();
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.rsvPlayer.getBaubleDataModule().hasBauble("broken_heart") && this.sleepRepairEnabled && player.isSleeping() && this.allowedWorlds.contains(player.getWorld().getName());
    }

    @Override
    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static Map<UUID, BrokenHeartRepairTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

