/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.baubles.EndermanAlly;
import me.val_mobile.baubles.EndermanAllyUtils;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EnderCrownTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, EnderCrownTask> tasks = new HashMap<UUID, EnderCrownTask>();
    private final RSVPlayer rsvPlayer;
    private final UUID id;
    private final RSVPlugin plugin;
    private final boolean transfromEndermen;
    private final double maxDist;
    private final boolean alliesEnabled;
    private final boolean mustTakeDamage;
    private final double maxHealthPercent;
    private final double allySpawnChance;
    private final int minAllies;
    private final int maxAllies;
    private final int allyDelay;
    private final Collection<String> allowedWorlds;
    private final boolean shouldTakeWaterDamage;
    private final double waterDamage;
    private final int waterDamageDelay;
    private final double waterDamageChance;
    private final Predicate<Entity> filter = entity -> entity instanceof Enderman && !EndermanAllyUtils.isEndermanAlly(entity);
    private final int tickPeriod;
    private int waterDamageTicks;
    private int allyTicks;

    public EnderCrownTask(BaubleModule module, RSVPlayer rsvPlayer, RSVPlugin plugin) {
        this.rsvPlayer = rsvPlayer;
        this.id = rsvPlayer.getPlayer().getUniqueId();
        FileConfiguration config = module.getUserConfig().getConfig();
        this.allowedWorlds = module.getAllowedWorlds();
        this.plugin = plugin;
        this.transfromEndermen = config.getBoolean("Items.ender_queens_crown.TransformRegularEndermen.Enabled");
        this.maxDist = config.getDouble("Items.ender_queens_crown.TransformRegularEndermen.MaxDistance");
        this.mustTakeDamage = config.getBoolean("Items.ender_queens_crown.SummonEndermenAllies.MustTakeDamage");
        this.alliesEnabled = config.getBoolean("Items.ender_queens_crown.SummonEndermenAllies.Enabled");
        this.minAllies = config.getInt("Items.ender_queens_crown.SummonEndermenAllies.MinAmount");
        this.maxAllies = config.getInt("Items.ender_queens_crown.SummonEndermenAllies.MaxAmount");
        this.allySpawnChance = config.getDouble("Items.ender_queens_crown.SummonEndermenAllies.Chance");
        this.allyDelay = config.getInt("Items.ender_queens_crown.SummonEndermenAllies.Delay");
        this.maxHealthPercent = config.getDouble("Items.ender_queens_crown.SummonEndermenAllies.MaxHealthPercent");
        this.shouldTakeWaterDamage = config.getBoolean("Items.ender_queens_crown.WaterContact.Enabled");
        this.waterDamage = config.getDouble("Items.ender_queens_crown.WaterContact.Damage");
        this.waterDamageChance = config.getDouble("Items.ender_queens_crown.WaterContact.Chance");
        this.waterDamageDelay = config.getInt("Items.ender_queens_crown.WaterContact.Delay");
        this.tickPeriod = config.getInt("Items.ender_queens_crown.TickPeriod");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            if (this.transfromEndermen) {
                Collection entities = player.getWorld().getNearbyEntities(player.getLocation(), this.maxDist, this.maxDist, this.maxDist, this.filter);
                for (Entity e : entities) {
                    EndermanAlly ally = Utils.spawnEndermanAlly(player, e.getLocation());
                    ally.addEntityToWorld(player.getWorld());
                    ally.getEntity().teleport(e.getLocation());
                    ((LivingEntity)ally.getEntity()).setHealth(((LivingEntity)e).getHealth());
                    e.remove();
                }
            }
            if (this.shouldTakeWaterDamage) {
                this.waterDamageTicks += this.tickPeriod;
                if (this.waterDamageTicks > this.waterDamageDelay && Utils.roll(this.waterDamageChance) && (player.isInWater() || player.getWorld().hasStorm() && player.getLocation().getY() >= (double)player.getWorld().getHighestBlockYAt(player.getLocation()))) {
                    player.damage(this.waterDamage);
                    this.waterDamageTicks = 0;
                }
            }
            if (this.alliesEnabled) {
                this.allyTicks += this.tickPeriod;
                if (this.canSpawnAllies(false)) {
                    this.spawnAllies();
                }
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName()) && this.rsvPlayer.getBaubleDataModule().hasBauble("ender_queens_crown");
    }

    @Override
    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, this.tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static Map<UUID, EnderCrownTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public boolean areAlliesEnabled() {
        return this.alliesEnabled;
    }

    public boolean canSpawnAllies(boolean playerDamaged) {
        Player player;
        if (this.allyTicks > this.allyDelay && Utils.roll(this.allySpawnChance) && (player = this.rsvPlayer.getPlayer()).getHealth() / player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() <= this.maxHealthPercent) {
            if (this.mustTakeDamage) {
                return playerDamaged;
            }
            return true;
        }
        return false;
    }

    public void spawnAllies() {
        Player player = this.rsvPlayer.getPlayer();
        Location loc = player.getLocation();
        World world = player.getWorld();
        int numAllies = Utils.getRandomNum(this.minAllies, this.maxAllies);
        for (int i = 0; i < numAllies; ++i) {
            EndermanAlly ally = Utils.spawnEndermanAlly(player, loc);
            ally.addEntityToWorld(world);
            Utils.randomTpSafely(ally.getEntity(), this.maxDist);
            this.allyTicks = 0;
        }
    }
}

