/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import me.val_mobile.baubles.PotionBaubleEffect;
import me.val_mobile.baubles.TickableBauble;
import me.val_mobile.data.RSVModule;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionBauble
extends TickableBauble {
    private final Collection<PotionBaubleEffect> effects = new ArrayList<PotionBaubleEffect>();

    public PotionBauble(String name) {
        super(name);
        FileConfiguration config = RSVModule.getModule("Baubles").getUserConfig().getConfig();
        ConfigurationSection section = config.getConfigurationSection("Items." + name + ".Effects");
        if (section != null) {
            Set keys = section.getKeys(false);
            for (String key : keys) {
                int dur = section.getInt(key + ".Duration");
                int amp = section.getInt(key + ".Amplifier");
                int ampInc = section.getInt(key + ".AmplifierIncrement");
                this.effects.add(new PotionBaubleEffect(PotionEffectType.getByName((String)key), dur, amp, ampInc));
            }
        }
    }

    public void ability(Player player, int amount) {
        for (PotionBaubleEffect effect : this.effects) {
            int baseAmp = effect.getAmplifier();
            int inc = effect.getIncrement();
            int amp = baseAmp + (amount - 1) * inc;
            player.addPotionEffect(new PotionEffect(effect.getType(), effect.getDuration(), amp));
        }
    }

    public Collection<PotionBaubleEffect> getEffects() {
        return this.effects;
    }
}

