/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.baubles.PotionBauble;
import me.val_mobile.baubles.TickableBauble;
import me.val_mobile.baubles.TickableBaubleManager;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.data.baubles.DataModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PotionBaubleTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, Collection<PotionBaubleTask>> tasks = new HashMap<UUID, Collection<PotionBaubleTask>>();
    private final BaubleModule module;
    private final DataModule dataModule;
    private final RSVPlayer rsvPlayer;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final RSVPlugin plugin;
    private final PotionBauble potionBauble;

    public PotionBaubleTask(BaubleModule module, PotionBauble potionBauble, RSVPlayer rsvPlayer, RSVPlugin plugin) {
        this.rsvPlayer = rsvPlayer;
        this.id = rsvPlayer.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.plugin = plugin;
        this.potionBauble = potionBauble;
        this.module = module;
        this.dataModule = rsvPlayer.getBaubleDataModule();
        Map<UUID, Collection<TickableBauble>> baubles = TickableBaubleManager.getBaubles();
        ArrayList<PotionBauble> potBaubles = baubles.containsKey(this.id) ? baubles.get(this.id) : new ArrayList<PotionBauble>();
        potBaubles.add(potionBauble);
        baubles.put(this.id, potBaubles);
        if (tasks.containsKey(this.id)) {
            ArrayList<PotionBaubleTask> colTasks = new ArrayList<PotionBaubleTask>(tasks.get(this.id));
            colTasks.add(this);
            tasks.replace(this.id, colTasks);
        } else {
            tasks.put(this.id, List.of(this));
        }
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            int amount = this.getAmount();
            if (amount > 0) {
                if (this.potionBauble.getName().equals("pride_pendant")) {
                    if (Utils.doublesEquals(player.getHealth(), player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())) {
                        this.potionBauble.ability(player, amount);
                    } else {
                        if (tasks.get(this.id).size() < 2) {
                            tasks.remove(this.id);
                        } else {
                            Collection<PotionBaubleTask> colTasks = tasks.get(this.id);
                            colTasks.remove(this);
                            tasks.put(this.id, colTasks);
                        }
                        this.cancel();
                    }
                } else {
                    this.potionBauble.ability(player, amount);
                }
            } else {
                if (tasks.get(this.id).size() < 2) {
                    tasks.remove(this.id);
                } else {
                    Collection<PotionBaubleTask> colTasks = tasks.get(this.id);
                    colTasks.remove(this);
                    tasks.put(this.id, colTasks);
                }
                this.cancel();
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName());
    }

    @Override
    public void start() {
        FileConfiguration config = this.module.getUserConfig().getConfig();
        int tickPeriod = config.getInt("Items." + this.potionBauble.getName() + ".TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    private int getAmount() {
        return this.dataModule.getBaubleAmount(this.potionBauble.getName());
    }

    public PotionBauble getPotionBauble() {
        return this.potionBauble;
    }

    public static boolean hasTask(UUID id, String name) {
        Collection<PotionBaubleTask> colTasks;
        if (tasks.containsKey(id) && (colTasks = tasks.get(id)) != null) {
            for (PotionBaubleTask t : colTasks) {
                if (!t.getPotionBauble().getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public UUID getId() {
        return this.id;
    }

    public static Map<UUID, Collection<PotionBaubleTask>> getTasks() {
        return tasks;
    }
}

