/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StoneGreaterInertiaTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, StoneGreaterInertiaTask> tasks = new HashMap<UUID, StoneGreaterInertiaTask>();
    private static final float MAX_WALK_SPEED = 1.0f;
    private static final float DEFAULT_WALK_SPEED = 0.2f;
    private final RSVPlayer rsvPlayer;
    private final RSVPlugin plugin;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final FileConfiguration config;
    private final double walkSpeedMultiplier;

    public StoneGreaterInertiaTask(BaubleModule module, RSVPlayer rsvPlayer, RSVPlugin plugin) {
        this.rsvPlayer = rsvPlayer;
        this.id = rsvPlayer.getPlayer().getUniqueId();
        this.config = module.getUserConfig().getConfig();
        this.allowedWorlds = module.getAllowedWorlds();
        this.plugin = plugin;
        this.walkSpeedMultiplier = this.config.getDouble("Items.stone_greater_inertia.WalkSpeedMultiplier");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            player.setWalkSpeed((float)Math.min((double)0.2f * this.walkSpeedMultiplier, 1.0));
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName()) && this.rsvPlayer.getBaubleDataModule().hasBauble("stone_greater_inertia");
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Items.stone_negative_gravity.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        if (this.rsvPlayer.getPlayer() != null) {
            this.rsvPlayer.getPlayer().setWalkSpeed(0.2f);
        }
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, StoneGreaterInertiaTask> getTasks() {
        return tasks;
    }
}

