/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StoneNegativeGravityTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, StoneNegativeGravityTask> tasks = new HashMap<UUID, StoneNegativeGravityTask>();
    private final RSVPlayer rsvPlayer;
    private final RSVPlugin plugin;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final FileConfiguration config;
    private final double maxDownwardVelocity;
    private final double maxUpwardVelocity;
    private final boolean wasGravityInitiallyOn;
    private final boolean reenableGravity;

    public StoneNegativeGravityTask(BaubleModule module, RSVPlayer rsvPlayer, RSVPlugin plugin) {
        this.rsvPlayer = rsvPlayer;
        this.id = rsvPlayer.getPlayer().getUniqueId();
        this.config = module.getUserConfig().getConfig();
        this.allowedWorlds = module.getAllowedWorlds();
        this.plugin = plugin;
        this.wasGravityInitiallyOn = rsvPlayer.getPlayer().hasGravity();
        this.reenableGravity = this.config.getBoolean("Items.stone_negative_gravity.ReenableGravity");
        this.maxDownwardVelocity = this.config.getDouble("Items.stone_negative_gravity.Instability.MaxDownwardVelocity");
        this.maxUpwardVelocity = this.config.getDouble("Items.stone_negative_gravity.Instability.MaxUpwardVelocity");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            player.setGravity(false);
            if (RSVItem.isHoldingItemInMainHand("stone_negative_gravity", player)) {
                player.setVelocity(player.getVelocity().setY(Utils.getRandomNum(this.maxDownwardVelocity, this.maxUpwardVelocity)));
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName()) && (this.rsvPlayer.getBaubleDataModule().hasBauble("stone_negative_gravity") || RSVItem.isHoldingItemInMainHand("stone_negative_gravity", player));
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Items.stone_negative_gravity.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        if (this.rsvPlayer.getPlayer() != null) {
            if (this.reenableGravity) {
                this.rsvPlayer.getPlayer().setGravity(true);
            } else {
                this.rsvPlayer.getPlayer().setGravity(this.wasGravityInitiallyOn);
            }
        }
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, StoneNegativeGravityTask> getTasks() {
        return tasks;
    }
}

