/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVMob;
import me.val_mobile.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Commands
implements CommandExecutor {
    private final RSVPlugin plugin;
    private final FileConfiguration config;

    public Commands(RSVPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getCommandsConfig();
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command cmd, @Nonnull String label, @Nonnull String[] args) {
        if (label.equalsIgnoreCase("RealisticSurvival") || label.equalsIgnoreCase("rsv")) {
            if (sender instanceof BlockCommandSender) {
                if (!this.config.getBoolean("EnableCommandBlockUsage")) {
                    this.sendNoPermissionMessage(sender);
                    return true;
                }
            } else if (sender instanceof CommandMinecart && !this.config.getBoolean("EnableCommandBlockMinecartUsage")) {
                this.sendNoPermissionMessage(sender);
                return true;
            }
            if (args.length == 0) {
                this.sendIncompleteCommandMsg(sender);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "give": {
                    if (!sender.hasPermission("realisticsurvival.command.give")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length < 3) {
                        this.sendIncompleteCommandMsg(sender);
                        return true;
                    }
                    RSVItem customItem = RSVItem.getItem(args[2]);
                    if (!Utils.isItemReal(customItem)) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("MisspelledItemName"), sender, Map.of("MISSPELLED_NAME", args[2])));
                        return true;
                    }
                    int amount = 1;
                    if (args.length > 3) {
                        try {
                            amount = Integer.parseInt(args[3]);
                        }
                        catch (NumberFormatException e) {
                            this.sendInvalidArgumentMsg(sender);
                            return true;
                        }
                    }
                    if (amount < 1) {
                        if (this.config.getBoolean("Give.TooFewItems.Enabled")) {
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Give.TooFewItems.Message"), sender, null));
                        }
                        return true;
                    }
                    if (amount > this.config.getInt("Give.TooManyItems.MaxValue")) {
                        if (this.config.getBoolean("Give.TooManyItems.Enabled")) {
                            Map<String, Object> placeholders = Map.of("MAXIMUM_VALUE", this.config.getInt("Give.TooManyItems.MaxValue"));
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Give.TooManyItems.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    List targets = Bukkit.selectEntities((CommandSender)sender, (String)args[1]);
                    if (targets.isEmpty()) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    ArrayList<Player> filteredTargets = new ArrayList<Player>();
                    for (Entity e : targets) {
                        Player player2;
                        if (!(e instanceof Player) || !(player2 = (Player)e).isOnline()) continue;
                        filteredTargets.add(player2);
                    }
                    if (filteredTargets.isEmpty()) {
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    for (Player player3 : filteredTargets) {
                        Utils.addItemToInventory((Inventory)player3.getInventory(), customItem, amount, player3.getLocation());
                        this.playSound(player3);
                    }
                    if (this.config.getBoolean("Give.CorrectExecution.Enabled")) {
                        if (filteredTargets.size() == 1) {
                            placeholders = Map.of("VALUE", amount, "DISPLAY_NAME", ChatColor.stripColor((String)customItem.getItemMeta().getDisplayName()), "PLAYER_NAME", ((Player)filteredTargets.get(0)).getDisplayName());
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Give.CorrectExecution.SingleTargetMessage"), sender, placeholders));
                        } else {
                            placeholders = Map.of("VALUE", amount, "DISPLAY_NAME", ChatColor.stripColor((String)customItem.getItemMeta().getDisplayName()));
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Give.CorrectExecution.MultipleTargetMessage"), sender, placeholders));
                        }
                    }
                    return true;
                }
                case "reload": {
                    if (!sender.hasPermission("realisticsurvival.command.reload")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    RSVConfig.getConfigList().forEach(config -> config.reloadConfig());
                    if (this.config.getBoolean("Reload.CorrectExecution.Enabled")) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("Reload.CorrectExecution.Message"), sender, null));
                    }
                    return true;
                }
                case "spawnitem": {
                    Map<String, Object> placeholders;
                    double z;
                    double y;
                    double x;
                    World world;
                    if (!sender.hasPermission("realisticsurvival.command.spawnitem")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length == 1) {
                        this.sendIncompleteCommandMsg(sender);
                        return true;
                    }
                    RSVItem item = RSVItem.getItem(args[1]);
                    if (!Utils.isItemReal(item)) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("MisspelledItemName"), sender, Map.of("MISSPELLED_NAME", args[1])));
                        return true;
                    }
                    int amount = 1;
                    if (sender instanceof Player) {
                        Player player4 = (Player)sender;
                        if (args.length == 2) {
                            world = player4.getWorld();
                            Location loc = player4.getLocation();
                            x = loc.getX();
                            y = loc.getY();
                            z = loc.getZ();
                        } else {
                            if (args.length < 6) {
                                this.sendIncompleteCommandMsg((CommandSender)player4);
                                return true;
                            }
                            try {
                                amount = Integer.parseInt(args[2]);
                                x = Double.parseDouble(args[3]);
                                y = Double.parseDouble(args[4]);
                                z = Double.parseDouble(args[5]);
                            }
                            catch (NumberFormatException e) {
                                this.sendInvalidArgumentMsg(sender);
                                return true;
                            }
                            world = player4.getWorld();
                            if (args.length == 7) {
                                world = Bukkit.getWorld((String)args[6]);
                            }
                        }
                    } else {
                        if (args.length < 7) {
                            this.sendIncompleteCommandMsg(sender);
                            return true;
                        }
                        try {
                            amount = Integer.parseInt(args[2]);
                            x = Double.parseDouble(args[3]);
                            y = Double.parseDouble(args[4]);
                            z = Double.parseDouble(args[5]);
                            world = Bukkit.getWorld((String)args[6]);
                        }
                        catch (NumberFormatException e) {
                            this.sendInvalidArgumentMsg(sender);
                            return true;
                        }
                    }
                    if (world == null) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("MisspelledWorld"), sender, null));
                        return true;
                    }
                    if (amount < 1) {
                        if (this.config.getBoolean("SpawnItem.TooFewItems.Enabled")) {
                            sender.sendMessage(Utils.translateMsg(this.config.getString("SpawnItem.TooFewItems.Message"), sender, null));
                        }
                        return true;
                    }
                    if (amount > item.getMaxStackSize()) {
                        if (this.config.getBoolean("SpawnItem.ExceedsStackSize.Enabled")) {
                            placeholders = Map.of("STACK_SIZE", item.getMaxStackSize());
                            sender.sendMessage(Utils.translateMsg(this.config.getString("SpawnItem.ExceedsStackSize.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    if (amount > this.config.getInt("SpawnItem.TooManyItems.MaxValue")) {
                        if (this.config.getBoolean("SpawnItem.TooManyItems.Enabled")) {
                            placeholders = Map.of("MAXIMUM_VALUE", this.config.getInt("SpawnItem.TooManyItems.MaxValue"));
                            sender.sendMessage(Utils.translateMsg(this.config.getString("SpawnItem.TooManyItems.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    if (amount > item.getMaxStackSize() && this.config.getBoolean("SpawnItem.CheckStackSize")) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    item.setAmount(amount);
                    world.dropItemNaturally(new Location(world, x, y, z), (ItemStack)item);
                    if (this.config.getBoolean("SpawnItem.CorrectExecution.Enabled")) {
                        placeholders = Map.of("ITEM_NAME", item.hasItemMeta() ? item.getItemMeta().getDisplayName() : args[1], "X_COORD", x, "Y_COORD", y, "Z_COORD", z, "WORLD_NAME", world.getName());
                        sender.sendMessage(Utils.translateMsg(this.config.getString("SpawnItem.CorrectExecution.Message"), sender, placeholders));
                    }
                    return true;
                }
                case "summon": {
                    String mobName;
                    double z;
                    double y;
                    double x;
                    World world;
                    if (!sender.hasPermission("realisticsurvival.command.summon")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length == 1) {
                        this.sendIncompleteCommandMsg(sender);
                        return true;
                    }
                    if (sender instanceof Player) {
                        Player player5 = (Player)sender;
                        if (args.length == 2) {
                            Location loc = player5.getLocation();
                            world = loc.getWorld();
                            x = loc.getX();
                            y = loc.getY();
                            z = loc.getZ();
                        } else {
                            if (args.length < 5) {
                                this.sendIncompleteCommandMsg((CommandSender)player5);
                                return true;
                            }
                            try {
                                x = Double.parseDouble(args[2]);
                                y = Double.parseDouble(args[3]);
                                z = Double.parseDouble(args[4]);
                            }
                            catch (NumberFormatException e) {
                                this.sendInvalidArgumentMsg(sender);
                                return true;
                            }
                            world = player5.getWorld();
                            if (args.length == 6) {
                                world = Bukkit.getWorld((String)args[6]);
                            }
                        }
                    } else {
                        if (args.length < 6) {
                            this.sendIncompleteCommandMsg(sender);
                            return true;
                        }
                        try {
                            x = Double.parseDouble(args[2]);
                            y = Double.parseDouble(args[3]);
                            z = Double.parseDouble(args[4]);
                            world = Bukkit.getWorld((String)args[5]);
                        }
                        catch (NumberFormatException e) {
                            this.sendInvalidArgumentMsg(sender);
                            return true;
                        }
                    }
                    if (world == null) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("MisspelledWorld"), sender, null));
                        return true;
                    }
                    Location loc = new Location(world, x, y, z);
                    RSVMob mob = switch (mobName = args[1].toLowerCase()) {
                        case "fire_dragon" -> Utils.spawnFireDragon(loc);
                        case "ice_dragon" -> Utils.spawnIceDragon(loc);
                        case "lightning_dragon" -> Utils.spawnLightningDragon(loc);
                        case "sea_serpent" -> Utils.spawnSeaSerpent(loc);
                        case "siren" -> Utils.spawnSiren(loc);
                        default -> null;
                    };
                    if (mob == null) {
                        if (this.config.getBoolean("Summon.MisspelledMob.Enabled")) {
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Summon.MisspelledMob.Message"), sender, Map.of("MISSPELLED_NAME", mobName)));
                        }
                        return true;
                    }
                    switch (mobName) {
                        case "fire_dragon": 
                        case "ice_dragon": 
                        case "lightning_dragon": 
                        case "sea_serpent": 
                        case "siren": {
                            if (RSVModule.getModule("IceandFire").isEnabled(world)) break;
                            if (this.config.getBoolean("Summon.RequiredModulesDisabled.Enabled")) {
                                Map<String, Object> placeholders = Map.of("REQUIRED_MODULES", String.join((CharSequence)", ", mob.getRequiredModules()));
                                sender.sendMessage(Utils.translateMsg(this.config.getString("Summon.RequiredModulesDisabled.Message"), sender, placeholders));
                            }
                            return true;
                        }
                    }
                    mob.addEntityToWorld(world);
                    if (this.config.getBoolean("Summon.CorrectExecution.Enabled")) {
                        Map<String, Object> placeholders = Map.of("MOB_NAME", StringUtils.capitalize((String)mobName.replaceAll("_", "")), "X_COORD", x, "Y_COORD", y, "Z_COORD", z, "WORLD_NAME", world.getName());
                        sender.sendMessage(Utils.translateMsg(this.config.getString("Summon.CorrectExecution.Message"), sender, placeholders));
                    }
                    return true;
                }
                case "temperature": {
                    if (!sender.hasPermission("realisticsurvival.command.temperature")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length <= 2) {
                        this.sendIncompleteCommandMsg(sender);
                        return true;
                    }
                    TempManager manager = ((TanModule)RSVModule.getModule("ToughAsNails")).getTempManager();
                    List targets = Bukkit.selectEntities((CommandSender)sender, (String)args[1]);
                    if (targets == null) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    if (!RSVModule.getModule("ToughAsNails").isGloballyEnabled()) {
                        if (this.config.getBoolean("Temperature.TanModuleDisabled.Enabled")) {
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.TanModuleDisabled.Message"), sender, null));
                        }
                        return true;
                    }
                    ArrayList<Player> filteredTargets = new ArrayList<Player>();
                    for (Entity e : targets) {
                        Player player6;
                        if (!(e instanceof Player) || !(player6 = (Player)e).isOnline() || !manager.isTempEnabled(player6)) continue;
                        filteredTargets.add(player6);
                    }
                    if (filteredTargets.isEmpty()) {
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    double temperature = 12.5;
                    double addition = 0.0;
                    boolean isRelative = false;
                    try {
                        if (args[2].startsWith("~")) {
                            isRelative = true;
                            addition = Double.parseDouble(args[2].substring(1));
                        } else {
                            temperature = Double.parseDouble(args[2]);
                        }
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    if (temperature < 0.0) {
                        if (this.config.getBoolean("Temperature.BelowMinValue.Enabled")) {
                            Map<String, Object> placeholders = Map.of("MINIMUM_VALUE", 0.0);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.BelowMinValue.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    if (temperature > 25.0) {
                        if (this.config.getBoolean("Temperature.AboveMaxValue.Enabled")) {
                            Map<String, Object> placeholders = Map.of("MAXIMUM_VALUE", 25.0);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.AboveMaxValue.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    double oldTemp = manager.getTemperature((Player)filteredTargets.get(0));
                    if (isRelative) {
                        double finalAddition = addition;
                        filteredTargets.forEach(player -> manager.addTemperature((Player)player, finalAddition));
                    } else {
                        double finalTemperature = temperature;
                        filteredTargets.forEach(player -> manager.setTemperature((Player)player, finalTemperature));
                    }
                    if (this.config.getBoolean("Temperature.CorrectExecution.Enabled")) {
                        if (filteredTargets.size() == 1) {
                            if (isRelative) {
                                Map<String, Object> placeholders = Map.of("PLAYER_NAME", ((Player)filteredTargets.get(0)).getDisplayName(), "OLD_TEMPERATURE", oldTemp, "NEW_TEMPERATURE", temperature, "CHANGE", addition);
                                sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.CorrectExecution.SingleTargetRelativeMessage"), sender, placeholders));
                            } else {
                                Map<String, Object> placeholders = Map.of("PLAYER_NAME", ((Player)filteredTargets.get(0)).getDisplayName(), "OLD_TEMPERATURE", oldTemp, "NEW_TEMPERATURE", temperature);
                                sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.CorrectExecution.SingleTargetMessage"), sender, placeholders));
                            }
                        } else if (isRelative) {
                            Map<String, Object> placeholders = Map.of("CHANGE", addition);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.CorrectExecution.MultipleTargetRelativeMessage"), sender, placeholders));
                        } else {
                            Map<String, Object> placeholders = Map.of("NEW_TEMPERATURE", temperature);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Temperature.CorrectExecution.MultipleTargetMessage"), sender, placeholders));
                        }
                    }
                    return true;
                }
                case "thirst": {
                    if (!sender.hasPermission("realisticsurvival.command.thirst")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length <= 2) {
                        this.sendIncompleteCommandMsg(sender);
                        return true;
                    }
                    ThirstManager manager = ((TanModule)RSVModule.getModule("ToughAsNails")).getThirstManager();
                    List targets = Bukkit.selectEntities((CommandSender)sender, (String)args[1]);
                    if (targets.isEmpty()) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    if (!RSVModule.getModule("ToughAsNails").isGloballyEnabled()) {
                        if (this.config.getBoolean("Thirst.TanModuleDisabled.Enabled")) {
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.TanModuleDisabled.Message"), sender, null));
                        }
                        return true;
                    }
                    ArrayList<Player> filteredTargets = new ArrayList<Player>();
                    for (Entity e : targets) {
                        Player player7;
                        if (!(e instanceof Player) || !(player7 = (Player)e).isOnline() || !manager.isThirstEnabled(player7)) continue;
                        filteredTargets.add(player7);
                    }
                    if (filteredTargets.isEmpty()) {
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    int thirst = 10;
                    int addition = 0;
                    boolean isRelative = false;
                    try {
                        if (args[2].startsWith("~")) {
                            isRelative = true;
                            addition = Integer.parseInt(args[2].substring(1));
                        } else {
                            thirst = Integer.parseInt(args[2]);
                        }
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    if (thirst < 0) {
                        if (this.config.getBoolean("Thirst.BelowMinValue.Enabled")) {
                            Map<String, Object> placeholders = Map.of("MINIMUM_VALUE", 0);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.BelowMinValue.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    if (thirst > 20) {
                        if (this.config.getBoolean("Thirst.AboveMaxValue.Enabled")) {
                            Map<String, Object> placeholders = Map.of("MAXIMUM_VALUE", 20);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.AboveMaxValue.Message"), sender, placeholders));
                        }
                        return true;
                    }
                    int oldThirst = manager.getThirst((Player)filteredTargets.get(0));
                    if (isRelative) {
                        int finalAddition = addition;
                        filteredTargets.forEach(player -> manager.addThirst((Player)player, finalAddition));
                    } else {
                        int finalThirst = thirst;
                        filteredTargets.forEach(player -> manager.setThirst((Player)player, finalThirst));
                    }
                    if (this.config.getBoolean("Thirst.CorrectExecution.Enabled")) {
                        if (filteredTargets.size() == 1) {
                            if (isRelative) {
                                Map<String, Object> placeholders = Map.of("PLAYER_NAME", ((Player)filteredTargets.get(0)).getDisplayName(), "OLD_THIRST", oldThirst, "NEW_THIRST", thirst, "CHANGE", addition);
                                sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.CorrectExecution.SingleTargetRelativeMessage"), sender, placeholders));
                            } else {
                                Map<String, Object> placeholders = Map.of("PLAYER_NAME", ((Player)filteredTargets.get(0)).getDisplayName(), "OLD_THIRST", oldThirst, "NEW_THIRST", thirst);
                                sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.CorrectExecution.SingleTargetMessage"), sender, placeholders));
                            }
                        } else if (isRelative) {
                            Map<String, Object> placeholders = Map.of("CHANGE", addition);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.CorrectExecution.MultipleTargetRelativeMessage"), sender, placeholders));
                        } else {
                            Map<String, Object> placeholders = Map.of("NEW_THIRST", thirst);
                            sender.sendMessage(Utils.translateMsg(this.config.getString("Thirst.CorrectExecution.MultipleTargetMessage"), sender, placeholders));
                        }
                    }
                    return true;
                }
                case "resetitem": {
                    String mainHand;
                    if (!sender.hasPermission("realisticsurvival.command.resetitem")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length == 1) {
                        if (sender instanceof Player) {
                            Player player8 = (Player)sender;
                            PlayerInventory inv = player8.getInventory();
                            ItemStack itemMainHand = inv.getItemInMainHand();
                            if (RSVItem.isRSVItem(itemMainHand)) {
                                inv.setItemInMainHand(RSVItem.convertItemStackToRSVItem(itemMainHand));
                                player8.updateInventory();
                                if (this.config.getBoolean("ResetItem.CorrectExecution.Enabled")) {
                                    sender.sendMessage(Utils.translateMsg(this.config.getString("ResetItem.CorrectExecution.MainHand.SingleTargetMessage"), sender, null));
                                }
                            } else if (this.config.getBoolean("ResetItem.NoValidItemsFound.Enabled")) {
                                sender.sendMessage(Utils.translateMsg(this.config.getString("ResetItem.NoValidItemsFound.MainHand.SingleTargetMessage"), sender, null));
                            }
                            return true;
                        }
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    List targets = Bukkit.selectEntities((CommandSender)sender, (String)args[1]);
                    if (targets.isEmpty()) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    ArrayList<Player> filteredTargets = new ArrayList<Player>();
                    for (Entity e : targets) {
                        Player player9;
                        if (!(e instanceof Player) || !(player9 = (Player)e).isOnline()) continue;
                        filteredTargets.add(player9);
                    }
                    if (filteredTargets.isEmpty()) {
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    boolean checkEntireInv = args.length >= 3 && args[2].equalsIgnoreCase("all");
                    boolean reset = false;
                    for (Player player10 : filteredTargets) {
                        PlayerInventory inv = player10.getInventory();
                        if (checkEntireInv) {
                            for (int i = 0; i < inv.getSize(); ++i) {
                                item = inv.getItem(i);
                                if (!RSVItem.isRSVItem(item)) continue;
                                inv.setItem(i, RSVItem.convertItemStackToRSVItem(item));
                                reset = true;
                            }
                        } else {
                            item = inv.getItemInMainHand();
                            if (RSVItem.isRSVItem(item)) {
                                inv.setItemInMainHand(RSVItem.convertItemStackToRSVItem(item));
                                reset = true;
                            }
                        }
                        player10.updateInventory();
                    }
                    String execution = reset ? "CorrectExecution" : "NoValidItemsFound";
                    String single = filteredTargets.size() == 1 ? "SingleTargetMessage" : "MultipleTargetMessage";
                    String string = mainHand = checkEntireInv ? "Inventory" : "MainHand";
                    if (this.config.getBoolean("ResetItem." + execution + ".Enabled")) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("ResetItem." + execution + "." + mainHand + "." + single), sender, null));
                    }
                    return true;
                }
                case "updateitem": {
                    String mainHand;
                    if (!sender.hasPermission("realisticsurvival.command.updateitem")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    if (args.length == 1) {
                        if (sender instanceof Player) {
                            Player player11 = (Player)sender;
                            PlayerInventory inv = player11.getInventory();
                            ItemStack itemMainHand = inv.getItemInMainHand();
                            if (RSVItem.isRSVItem(itemMainHand)) {
                                Utils.updateItem(itemMainHand);
                                player11.updateInventory();
                                if (this.config.getBoolean("UpdateItem.CorrectExecution.Enabled")) {
                                    sender.sendMessage(Utils.translateMsg(this.config.getString("UpdateItem.CorrectExecution.MainHand.SingleTargetMessage"), sender, null));
                                }
                            } else if (this.config.getBoolean("UpdateItem.NoValidItemsFound.Enabled")) {
                                sender.sendMessage(Utils.translateMsg(this.config.getString("UpdateItem.NoValidItemsFound.MainHand.SingleTargetMessage"), sender, null));
                            }
                            return true;
                        }
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    List targets = Bukkit.selectEntities((CommandSender)sender, (String)args[1]);
                    if (targets.isEmpty()) {
                        this.sendInvalidArgumentMsg(sender);
                        return true;
                    }
                    ArrayList<Player> filteredTargets = new ArrayList<Player>();
                    for (Entity e : targets) {
                        Player player12;
                        if (!(e instanceof Player) || !(player12 = (Player)e).isOnline()) continue;
                        filteredTargets.add(player12);
                    }
                    if (filteredTargets.isEmpty()) {
                        this.sendInvalidTargetMsg(sender);
                        return true;
                    }
                    boolean checkEntireInv = args.length >= 3 && args[2].equalsIgnoreCase("all");
                    boolean reset = false;
                    for (Player player13 : filteredTargets) {
                        PlayerInventory inv = player13.getInventory();
                        if (checkEntireInv) {
                            for (int i = 0; i < inv.getSize(); ++i) {
                                item = inv.getItem(i);
                                if (!RSVItem.isRSVItem(item)) continue;
                                Utils.updateItem(item);
                                reset = true;
                            }
                        } else {
                            item = inv.getItemInMainHand();
                            if (RSVItem.isRSVItem(item)) {
                                Utils.updateItem(item);
                                reset = true;
                            }
                        }
                        player13.updateInventory();
                    }
                    String execution = reset ? "CorrectExecution" : "NoValidItemsFound";
                    String single = filteredTargets.size() == 1 ? "SingleTargetMessage" : "MultipleTargetMessage";
                    String string = mainHand = checkEntireInv ? "Inventory" : "MainHand";
                    if (this.config.getBoolean("UpdateItem." + (String)execution + ".Enabled")) {
                        sender.sendMessage(Utils.translateMsg(this.config.getString("UpdateItem." + (String)execution + "." + mainHand + "." + single), sender, null));
                    }
                    return true;
                }
                case "help": {
                    if (!sender.hasPermission("realisticsurvival.command.help")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    this.config.getStringList("Help").forEach(msg -> sender.sendMessage(Utils.translateMsg(msg, sender, null)));
                    return true;
                }
                case "version": {
                    if (!sender.hasPermission("realisticsurvival.command.version")) {
                        this.sendNoPermissionMessage(sender);
                        return true;
                    }
                    Map<String, Object> placeholders = Map.of("PLUGIN_VERSION", this.plugin.getDescription().getVersion());
                    sender.sendMessage(Utils.translateMsg(this.config.getString("Version"), sender, placeholders));
                    Bukkit.getServer().dispatchCommand(sender, "version");
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private void sendInvalidTargetMsg(CommandSender sender) {
        sender.sendMessage(Utils.translateMsg(this.config.getString("InvalidTarget"), sender, null));
    }

    private void sendInvalidArgumentMsg(CommandSender sender) {
        sender.sendMessage(Utils.translateMsg(this.config.getString("InvalidArgument"), sender, null));
    }

    private void sendIncompleteCommandMsg(CommandSender sender) {
        sender.sendMessage(Utils.translateMsg(this.config.getString("IncompleteCommand"), sender, null));
    }

    private void sendNoPermissionMessage(CommandSender sender) {
        sender.sendMessage(Utils.translateMsg(this.config.getString("NoPermission"), sender, null));
    }

    private void playSound(Player player) {
        if (this.config.getBoolean("Give.CorrectExecution.Sound.Enabled")) {
            Utils.playSound(player.getLocation(), this.config.getString("Give.CorrectExecution.Sound.Sound"), (float)this.config.getDouble("Give.CorrectExecution.Sound.Volume"), (float)this.config.getDouble("Give.CorrectExecution.Sound.Pitch"));
        }
    }
}

