/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import me.val_mobile.data.FileBuilder;
import me.val_mobile.rsv.RSVPlugin;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RSVConfig
extends FileBuilder {
    private static final Set<RSVConfig> configList = new HashSet<RSVConfig>();
    private boolean updated;
    private final String path;
    private final RSVPlugin plugin;
    private final boolean updateOldVersions;
    private FileConfiguration config;

    public RSVConfig(RSVPlugin plugin, String path, boolean replace, boolean updateOldVersions) {
        super(plugin, path, replace);
        this.plugin = plugin;
        this.path = path;
        this.updateOldVersions = updateOldVersions;
        this.createConfig();
        configList.add(this);
    }

    public RSVConfig(RSVPlugin plugin, String path) {
        this(plugin, path, false, true);
    }

    public void createConfig() {
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        if (this.updateOldVersions && !this.updated) {
            this.updateConfig();
        }
    }

    private void updateConfig() {
        String currentVersion = "";
        String latestVersion = this.plugin.getDescription().getVersion();
        this.updated = true;
        if (this.config.contains("ConfigId")) {
            currentVersion = this.config.getString("ConfigId");
        }
        if (currentVersion.compareTo(latestVersion) < 0) {
            boolean autoUpdate;
            int num = 0;
            String newPath = this.path.replace(".yml", "_Backup_" + num + ".yml");
            while (new File(this.plugin.getDataFolder(), newPath).exists()) {
                newPath = newPath.replace("_Backup_" + (++num - 1), "_Backup_" + num);
            }
            FileConfiguration pluginConfig = this.plugin.getConfig();
            boolean bl = autoUpdate = pluginConfig == null || pluginConfig.getBoolean("AutoUpdateConfig");
            if (autoUpdate) {
                try {
                    Files.copy(Path.of(this.file.getAbsolutePath(), new String[0]), Path.of(this.file.getAbsolutePath().replace(".yml", "_Backup_" + num + ".yml"), new String[0]), new CopyOption[0]);
                    InputStream stream = this.plugin.getResource(this.path);
                    InputStreamReader reader = new InputStreamReader(stream);
                    YamlConfiguration embedded = YamlConfiguration.loadConfiguration((Reader)reader);
                    Set embeddedKeys = embedded.getKeys(true);
                    Set configKeys = this.config.getKeys(true);
                    for (String str : embeddedKeys) {
                        if (configKeys.contains(str)) continue;
                        this.config.set(str, embedded.get(str));
                    }
                    this.config.set("ConfigId", (Object)latestVersion);
                    this.config.save(this.file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.file.renameTo(new File(this.plugin.getDataFolder(), newPath));
                this.createFile(this.path);
                this.createConfig();
            }
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(FileConfiguration config) {
        this.config = config;
    }

    public void reloadConfig() {
        this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.file));
    }

    public static Set<RSVConfig> getConfigList() {
        return configList;
    }
}

