/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data.baubles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import me.val_mobile.data.baubles.BaubleSlot;
import me.val_mobile.data.baubles.GUI;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BaubleInventory
extends GUI {
    public BaubleInventory(Player player) {
        super(player, 54, "Bauble Bag");
        BaubleSlot[] values;
        Inventory inv = this.getInventory();
        for (BaubleSlot slot : values = BaubleSlot.values()) {
            for (int i : slot.getValues()) {
                if (RSVItem.isRSVItem(inv.getItem(i))) continue;
                inv.setItem(i, slot.getItem());
            }
        }
        RSVItem guiGlass = RSVItem.getItem("gui_glass");
        int size = inv.getSize();
        for (int i = 0; i < size; ++i) {
            if (Utils.isItemReal(inv.getItem(i))) continue;
            inv.setItem(i, (ItemStack)guiGlass);
        }
    }

    public Collection<ItemStack> getAllBaubles() {
        BaubleSlot[] values;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (BaubleSlot slot : values = BaubleSlot.values()) {
            for (int i : slot.getValues()) {
                ItemStack item = this.getInventory().getItem(i);
                if (!RSVItem.isRSVItem(item)) continue;
                items.add(item);
            }
        }
        return items;
    }

    public void removeAndDropAllBaubles(Location loc) {
        BaubleSlot[] values = BaubleSlot.values();
        World world = loc.getWorld();
        Inventory inv = this.getInventory();
        for (BaubleSlot slot : values) {
            block13: for (int i : slot.getValues()) {
                ItemStack item = inv.getItem(i);
                if (!RSVItem.isRSVItem(item)) continue;
                switch (RSVItem.getNameFromItem(item)) {
                    case "gui_glass": 
                    case "body_slot": 
                    case "ring_slot": 
                    case "charm_slot": 
                    case "belt_slot": 
                    case "amulet_slot": 
                    case "head_slot": {
                        continue block13;
                    }
                    default: {
                        world.dropItemNaturally(loc, item);
                        inv.setItem(i, slot.getItem());
                    }
                }
            }
        }
    }

    public void removeAllBaubles() {
        BaubleSlot[] values = BaubleSlot.values();
        Inventory inv = this.getInventory();
        for (BaubleSlot slot : values) {
            for (int i : slot.getValues()) {
                inv.setItem(i, slot.getItem());
            }
        }
    }

    public Collection<String> getAllBaubleNames() {
        ArrayList<String> items = new ArrayList<String>();
        BaubleSlot[] values = BaubleSlot.values();
        Inventory inv = this.getInventory();
        for (BaubleSlot slot : values) {
            for (int i : slot.getValues()) {
                ItemStack item = inv.getItem(i);
                if (!RSVItem.isRSVItem(item)) continue;
                items.add(RSVItem.getNameFromItem(item));
            }
        }
        return items;
    }

    public boolean hasBauble(String name) {
        Player player = Bukkit.getPlayer((UUID)this.getId());
        if (player == null) {
            return false;
        }
        Collection<ItemStack> baubleCol = this.getAllBaubles();
        for (ItemStack bauble : baubleCol) {
            if (!RSVItem.isRSVItem(bauble) || !RSVItem.getNameFromItem(bauble).equals(name)) continue;
            return true;
        }
        return false;
    }

    public int getBaubleAmount(String name) {
        int sum = 0;
        Collection<ItemStack> baubleCol = this.getAllBaubles();
        for (ItemStack bauble : baubleCol) {
            if (!RSVItem.isRSVItem(bauble) || !RSVItem.getNameFromItem(bauble).equals(name)) continue;
            ++sum;
        }
        return sum;
    }

    public ItemStack getItem(String name) {
        Collection<ItemStack> items = this.getAllBaubles();
        for (ItemStack item : items) {
            if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).equals(name)) continue;
            return item;
        }
        return null;
    }

    public void fillDefaultItems() {
        Inventory inv = this.getInventory();
        for (int i = 0; i < inv.getSize(); ++i) {
            if (Utils.isItemReal(inv.getItem(i))) continue;
            inv.setItem(i, BaubleSlot.getItemInSlot(i));
        }
    }
}

