/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data.baubles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVDataModule;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.baubles.BaubleInventory;
import me.val_mobile.data.baubles.BaubleSlot;
import me.val_mobile.utils.RSVItem;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;

public class DataModule
implements RSVDataModule {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final Logger LOGGER = Bukkit.getLogger();
    private final RSVConfig config;
    private final BaubleInventory baubleBag;
    private final UUID id;

    public DataModule(Player player) {
        this.baubleBag = new BaubleInventory(player);
        this.config = ((BaubleModule)RSVModule.getModule("Baubles")).getPlayerDataConfig();
        this.id = player.getUniqueId();
    }

    public BaubleInventory getBaubleBag() {
        return this.baubleBag;
    }

    public boolean hasBauble(String name) {
        return this.baubleBag.hasBauble(name);
    }

    public int getBaubleAmount(String name) {
        return this.baubleBag.getBaubleAmount(name);
    }

    @Override
    public void retrieveData() {
        FileConfiguration config = this.config.getConfig();
        Inventory inv = this.baubleBag.getInventory();
        String jsonString = config.getString(String.valueOf(this.id) + ".Items");
        if (jsonString == null || jsonString.isEmpty()) {
            LOGGER.info("[Baubles] No existing data found for " + String.valueOf(this.id) + ". Filling default items.");
            this.baubleBag.fillDefaultItems();
            return;
        }
        try {
            Type newType = new TypeToken<Map<String, Map<String, Object>>>(this){}.getType();
            Map serializedItems = (Map)GSON.fromJson(jsonString, newType);
            if (serializedItems == null || serializedItems.isEmpty()) {
                LOGGER.warning("[Baubles] JSON was parsed but empty for " + String.valueOf(this.id) + ". Filling defaults.");
                this.baubleBag.fillDefaultItems();
                return;
            }
            for (Map.Entry entry : serializedItems.entrySet()) {
                int slot = Integer.parseInt((String)entry.getKey());
                Map itemData = (Map)entry.getValue();
                if (itemData == null || itemData.isEmpty()) continue;
                ItemStack item = ItemStack.deserialize((Map)itemData);
                inv.setItem(slot, item);
            }
            LOGGER.info("[Baubles] Successfully loaded data for " + String.valueOf(this.id) + " (JSON format)");
        }
        catch (JsonSyntaxException ex) {
            LOGGER.warning("[Baubles] Detected legacy Base64 format for " + String.valueOf(this.id) + ". Converting...");
            try {
                Type legacyType = new TypeToken<Map<String, String>>(this){}.getType();
                Map legacyItems = (Map)GSON.fromJson(jsonString, legacyType);
                HashMap<String, Map> convertedMap = new HashMap<String, Map>();
                if (legacyItems != null) {
                    for (Map.Entry entry : legacyItems.entrySet()) {
                        int slot = Integer.parseInt((String)entry.getKey());
                        String base64 = (String)entry.getValue();
                        if (base64 == null || base64.isEmpty()) continue;
                        ItemStack item = this.deserializeItem(base64);
                        inv.setItem(slot, item);
                        convertedMap.put((String)entry.getKey(), item.serialize());
                    }
                    String newJson = GSON.toJson(convertedMap);
                    config.set(String.valueOf(this.id) + ".Items", (Object)newJson);
                    this.saveFile(config);
                    LOGGER.info("[Baubles] Successfully converted Base64 -> JSON for " + String.valueOf(this.id));
                }
            }
            catch (Exception e) {
                LOGGER.severe("[Baubles] Failed to convert Base64 data for " + String.valueOf(this.id));
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            LOGGER.severe("[Baubles] Unexpected error loading data for " + String.valueOf(this.id));
            e.printStackTrace();
        }
        this.baubleBag.fillDefaultItems();
    }

    @Override
    public void saveData() {
        FileConfiguration config = this.config.getConfig();
        Inventory inv = this.baubleBag.getInventory();
        BaubleSlot[] values = BaubleSlot.values();
        Pattern ignoreSlotPattern = Pattern.compile("^(charm|body|ring|belt|amulet|head)_slot$");
        HashMap<String, Map> serializedMap = new HashMap<String, Map>();
        for (BaubleSlot slot : values) {
            for (int i : slot.getValues()) {
                ItemStack item = inv.getItem(i);
                if (!RSVItem.isRSVItem(item) || ignoreSlotPattern.matcher(RSVItem.getNameFromItem(item)).find()) continue;
                serializedMap.put(String.valueOf(i), item.serialize());
            }
        }
        String jsonString = GSON.toJson(serializedMap);
        config.set(String.valueOf(this.id) + ".Items", (Object)jsonString);
        this.saveFile(config);
        LOGGER.info("[Baubles] Saved bauble data for " + String.valueOf(this.id));
    }

    public void saveFile(FileConfiguration config) {
        try {
            config.save(this.config.getFile());
        }
        catch (IOException e) {
            LOGGER.severe("[Baubles] Failed to save config for " + String.valueOf(this.id));
            e.printStackTrace();
        }
    }

    private ItemStack deserializeItem(String base64) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(base64);
        try (BukkitObjectInputStream inputStream = new BukkitObjectInputStream((InputStream)new ByteArrayInputStream(data));){
            ItemStack itemStack = (ItemStack)inputStream.readObject();
            return itemStack;
        }
    }
}

