/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.firstaid;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.firstaid.FaModule;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;

public class Body {
    private final FaModule module;
    private final Location playerLoc;
    private final FileConfiguration config;
    private double leftLegHealth;
    private double rightLegHealth;
    private double leftArmHealth;
    private double rightArmHealth;
    private double leftFootHealth;
    private double rightFootHealth;
    private double torsoHealth;
    private double headHealth;

    public Body(@Nonnull FaModule module, @Nonnull Location playerLoc) {
        this.module = module;
        this.playerLoc = playerLoc.clone();
        this.config = module.getUserConfig().getConfig();
    }

    @Nullable
    public BodyPart getHitBodyPart(@Nonnull Location loc) {
        return null;
    }

    public double getHealth(@Nonnull BodyPart organType) {
        return switch (organType.ordinal()) {
            case 0 -> this.leftLegHealth;
            case 1 -> this.rightLegHealth;
            case 4 -> this.leftArmHealth;
            case 5 -> this.rightArmHealth;
            case 2 -> this.leftFootHealth;
            case 3 -> this.rightFootHealth;
            case 7 -> this.torsoHealth;
            case 6 -> this.headHealth;
            default -> -1.0;
        };
    }

    public void setHealth(@Nonnull BodyPart organType, @Nonnegative double health) {
        health = Math.max(health, 0.0);
        switch (organType.ordinal()) {
            case 0: {
                this.leftLegHealth = health;
            }
        }
    }

    public double getMaximumHealth(@Nonnull BodyPart organType) {
        return -1.0;
    }

    public static enum BodyPart {
        LEFT_LEG,
        RIGHT_LEG,
        LEFT_FOOT,
        RIGHT_FOOT,
        LEFT_ARM,
        RIGHT_ARM,
        HEAD,
        TORSO;

    }
}

