/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.firstaid;

import java.util.Map;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.firstaid.FaEvents;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;

public class FaModule
extends RSVModule {
    private final RSVPlugin plugin;
    public static final String NAME = "FirstAid";
    private final RSVConfig config;
    private FaEvents events;

    public FaModule(RSVPlugin plugin) {
        super(NAME, plugin, Map.of(), Map.of());
        this.plugin = plugin;
        this.config = new RSVConfig(plugin, "resources/firstaid/playerdata.yml");
    }

    @Override
    public void initialize() {
        this.setUserConfig(new RSVConfig(this.plugin, "firstaid.yml"));
        this.setItemConfig(new RSVConfig(this.plugin, "resources/firstaid/items.yml"));
        this.setRecipeConfig(new RSVConfig(this.plugin, "resources/firstaid/recipes.yml"));
        this.setModuleItems(new ModuleItems(this));
        this.setModuleRecipes(new ModuleRecipes(this, this.plugin));
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Initialize.Enabled")) {
            String message = Utils.translateMsg(config.getString("Initialize.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
        this.events = new FaEvents(this, this.plugin);
        this.getModuleItems().initialize();
        this.getModuleRecipes().initialize();
        this.events.initialize();
    }

    @Override
    public void shutdown() {
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Shutdown.Enabled")) {
            String message = Utils.translateMsg(config.getString("Shutdown.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
    }

    public FaEvents getEvents() {
        return this.events;
    }

    public RSVConfig getPlayerDataConfig() {
        return this.config;
    }
}

