/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.DragonBreed;
import me.val_mobile.iceandfire.DragonGender;
import me.val_mobile.iceandfire.DragonVariant;
import me.val_mobile.utils.LorePresets;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVMob;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public interface Dragon
extends RSVMob {
    @Override
    default public List<String> getRequiredModules() {
        return List.of("IceandFire");
    }

    @Override
    default public String getParentModule() {
        return "IceandFire";
    }

    @Override
    default public String name() {
        return this.getBreed().toString().toLowerCase() + "_dragon";
    }

    @Override
    default public void addNbtData() {
        Utils.addNbtTag(this.getEntity(), "rsvmob", this.name(), PersistentDataType.STRING);
        Utils.addNbtTag(this.getEntity(), "rsvdragonstage", Integer.valueOf(this.getStage()), PersistentDataType.INTEGER);
        Utils.addNbtTag(this.getEntity(), "rsvdragonage", Integer.valueOf(this.getAge()), PersistentDataType.INTEGER);
        Utils.addNbtTag(this.getEntity(), "rsvdragonvariant", this.getVariant().toString(), PersistentDataType.STRING);
        Utils.addNbtTag(this.getEntity(), "rsvdragonbreed", this.getBreed().toString(), PersistentDataType.STRING);
        Utils.addNbtTag(this.getEntity(), "rsvdragongender", this.getGender().toString(), PersistentDataType.STRING);
    }

    @Nonnull
    default public List<ItemStack> getLoot(@Nullable ItemStack tool) {
        FileConfiguration config = RSVModule.getModule("IceandFire").getUserConfig().getConfig();
        int stage = this.getStage();
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        String breed = this.getBreed().toString().toLowerCase();
        ConfigurationSection section = config.getConfigurationSection("Dragon.LootTable");
        RSVItem heart = RSVItem.getItem("dragon_heart_" + breed);
        RSVItem skull = RSVItem.getItem("dragon_skull_" + breed);
        RSVItem scales = RSVItem.getItem("dragonscale_" + this.getVariant().toString().toLowerCase());
        RSVItem blood = RSVItem.getItem("dragon_blood_" + breed);
        RSVItem flesh = RSVItem.getItem("dragon_flesh_" + breed);
        RSVItem bones = RSVItem.getItem("dragonbone");
        LorePresets.addDragonSkullLore(skull, stage, breed.toString());
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Dragoncales.Stage" + this.getStage()), scales, tool, false));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Blood.Stage" + this.getStage()), blood, tool, false));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Dragonbones.Stage" + this.getStage()), bones, tool, false));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Flesh.Stage" + this.getStage()), flesh, tool, false));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Skull.Stage" + this.getStage()), skull, tool, false));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Heart.Stage" + this.getStage()), heart, tool, false));
        loot.addAll(this.getConfigurableLoot(tool));
        return loot;
    }

    public void performMeleeAttack(LivingEntity var1);

    public void performSpecialAbility(LivingEntity var1);

    public void triggerBreathAttack(Location var1);

    public void triggerExplosionAttack(Location var1);

    public DragonBreed getBreed();

    public DragonVariant getVariant();

    public int getStage();

    public int getAge();

    public DragonGender getGender();

    public void setStage(int var1);

    public void setAge(int var1);

    @Override
    default public void applyConfigOptions() {
        EnderDragon dragon = (EnderDragon)this.getEntity();
        ConfigurationSection section = RSVModule.getModule(this.getParentModule()).getUserConfig().getConfig().getConfigurationSection("Dragon.Info");
        dragon.setCustomName(Utils.translateMsg(section.getString("Name"), (CommandSender)dragon, Map.of("VARIANT", this.getVariant(), "BREED", this.getBreed(), "GENDER", this.getGender(), "AGE", this.getAge(), "STAGE", this.getStage())));
        dragon.setCustomNameVisible(section.getBoolean("CustomNameVisible"));
        double minHealth = section.getDouble("Health.Stage" + this.getStage() + ".Min");
        double maxHealth = section.getDouble("Health.Stage" + this.getStage() + ".Max");
        double health = Utils.getRandomNum(minHealth, maxHealth);
        if (health > dragon.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
            dragon.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        }
        dragon.setHealth(health);
    }

    @Override
    default public void setup() {
        RSVMob.super.setup();
        ((EnderDragon)this.getEntity()).setPhase(EnderDragon.Phase.STRAFING);
    }
}

