/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.Dragon;
import me.val_mobile.iceandfire.DragonUtils;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVMob;
import me.val_mobile.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class GenericBreath
extends BukkitRunnable {
    protected final Set<String> immuneBlocks;
    protected final Map<String, String[]> specialBlocks = new HashMap<String, String[]>();
    protected final EnderDragon dragon;
    protected final Vector velocity;
    protected final World world;
    protected final Location loc;
    protected final Particle particle;
    protected final double radius;
    protected final int decayTicks;
    protected final RSVPlugin plugin;
    protected final FileConfiguration config;
    protected int ticks = 0;

    public GenericBreath(EnderDragon dragon, Location target, RSVPlugin plugin, BreathType type) {
        ConfigurationSection section;
        this.dragon = dragon;
        this.config = RSVModule.getModule("IceandFire").getUserConfig().getConfig();
        String breed = StringUtils.capitalize((String)DragonUtils.getBreed(dragon).toString().toLowerCase());
        String prefix = StringUtils.capitalize((String)type.toString().toLowerCase());
        int stage = DragonUtils.getStage(dragon);
        double magnitude = this.config.getInt("Dragon." + breed + "Dragon." + prefix + "Attack.Velocity.Stage" + stage);
        this.plugin = plugin;
        this.loc = dragon.getLocation().clone();
        this.world = this.loc.getWorld();
        this.velocity = target.toVector().subtract(dragon.getLocation().toVector()).normalize().multiply(magnitude / 20.0);
        this.radius = this.config.getInt("Dragon." + breed + "Dragon." + prefix + "Attack.Radius.Stage" + stage);
        this.particle = Particle.valueOf((String)this.config.getString("Dragon." + breed + "Dragon." + prefix + "Attack.Particle"));
        this.decayTicks = this.config.getInt("Dragon." + breed + "Dragon." + prefix + "Attack.DespawnTime");
        this.immuneBlocks = Set.copyOf(this.config.getStringList("Dragon." + breed + "Dragon." + prefix + "Attack.ImmuneBlocks"));
        List specialBlocks = this.config.getStringList("Dragon." + breed + "Dragon." + prefix + "Attack.SpecialBlocks");
        if (!specialBlocks.isEmpty()) {
            for (String entry : specialBlocks) {
                String[] split = entry.split(":");
                String key = split[0];
                String[] results = split[1].split(",");
                this.specialBlocks.put(key, results);
            }
        }
        if ((section = this.config.getConfigurationSection("Dragon." + breed + "Dragon." + prefix + "Attack.Sound.Stage" + stage)) != null && section.getBoolean("Enabled")) {
            Utils.playSound(this.loc, section.getString("Sound"), (float)section.getDouble("Volume"), (float)section.getDouble("Pitch"));
        }
    }

    public GenericBreath(Dragon dragon, Location target, RSVPlugin plugin, BreathType type) {
        ConfigurationSection section;
        this.dragon = (EnderDragon)dragon.getEntity();
        this.config = RSVModule.getModule("IceandFire").getUserConfig().getConfig();
        String breed = StringUtils.capitalize((String)dragon.getBreed().toString().toLowerCase());
        String prefix = StringUtils.capitalize((String)type.toString().toLowerCase());
        int stage = dragon.getStage();
        double magnitude = this.config.getInt("Dragon." + breed + "Dragon." + prefix + "Attack.Velocity.Stage" + stage);
        this.plugin = plugin;
        this.loc = dragon.getEntity().getLocation().clone();
        this.world = this.loc.getWorld();
        this.velocity = target.toVector().subtract(dragon.getEntity().getLocation().toVector()).normalize().multiply(magnitude / 20.0);
        this.radius = this.config.getInt("Dragon." + breed + "Dragon." + prefix + "Attack.Radius.Stage" + stage);
        this.particle = Particle.valueOf((String)this.config.getString("Dragon." + breed + "Dragon." + prefix + "Attack.Particle"));
        this.decayTicks = this.config.getInt("Dragon." + breed + "Dragon." + prefix + "Attack.DespawnTime");
        this.immuneBlocks = Set.copyOf(this.config.getStringList("Dragon." + breed + "Dragon." + prefix + "Attack.ImmuneBlocks"));
        List specialBlocks = this.config.getStringList("Dragon." + breed + "Dragon." + prefix + "Attack.SpecialBlocks");
        if (!specialBlocks.isEmpty()) {
            for (String entry : specialBlocks) {
                String[] split = entry.split(":");
                String key = split[0];
                String[] results = split[1].split(",");
                this.specialBlocks.put(key, results);
            }
        }
        if ((section = this.config.getConfigurationSection("Dragon." + breed + "Dragon." + prefix + "Attack.Sound.Stage" + stage)) != null && section.getBoolean("Enabled")) {
            Utils.playSound(this.loc, section.getString("Sound"), (float)section.getDouble("Volume"), (float)section.getDouble("Pitch"));
        }
    }

    public void run() {
        Predicate<Entity> filter;
        Collection collection;
        if (!this.loc.getBlock().isEmpty()) {
            Location newLoc = this.loc.clone();
            while (!newLoc.getBlock().isEmpty()) {
                newLoc.setY(newLoc.getY() + 1.0);
                if (!newLoc.getBlock().isEmpty() && !(this.loc.toVector().distanceSquared(newLoc.toVector()) > this.radius * this.radius)) continue;
            }
            this.grief(newLoc, (int)this.radius);
            this.stop();
        }
        ++this.ticks;
        if (this.ticks > this.decayTicks) {
            this.stop();
        }
        if (this.ticks > 10 && !(collection = this.world.getNearbyEntities(this.loc, this.radius, this.radius, this.radius, filter = entity -> !entity.getUniqueId().equals(this.dragon.getUniqueId()) && (!RSVMob.isMob(entity) || !RSVMob.getMob(entity).equals(RSVMob.getMob((Entity)this.dragon))))).isEmpty()) {
            for (Entity e : collection) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)e;
                DragonUtils.performSpecialAbility(this.dragon, living);
            }
        }
        this.world.spawnParticle(this.particle, this.loc, 5, 0.1, 0.1, 0.1, 0.0, null, true);
        this.loc.add(this.velocity);
        this.performSpecialRunnableLogic();
    }

    public void stop() {
        this.performSpecialCollisionLogic();
        this.cancel();
    }

    public abstract void grief(Location var1, int var2);

    public abstract void performSpecialCollisionLogic();

    public abstract void performSpecialRunnableLogic();

    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public static enum BreathType {
        BREATH,
        EXPLOSION;

    }
}

