/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import me.val_mobile.data.ModuleEvents;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.Dragon;
import me.val_mobile.iceandfire.DragonBreed;
import me.val_mobile.iceandfire.DragonUtils;
import me.val_mobile.iceandfire.IceFireModule;
import me.val_mobile.iceandfire.SeaSerpent;
import me.val_mobile.iceandfire.SeaSerpentUtils;
import me.val_mobile.iceandfire.Siren;
import me.val_mobile.iceandfire.SirenUtils;
import me.val_mobile.iceandfire.TideGuardianTask;
import me.val_mobile.misc.PlayerItemAcquireEvent;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.BurnTask;
import me.val_mobile.spartanandfire.ElectrocuteTask;
import me.val_mobile.spartanandfire.FreezeTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVMob;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Squid;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class IceFireEvents
extends ModuleEvents
implements Listener {
    private final IceFireModule module;
    private final FileConfiguration config;
    private final RSVPlugin plugin;

    public IceFireEvents(IceFireModule module, RSVPlugin plugin) {
        super(module, plugin);
        this.config = module.getUserConfig().getConfig();
        this.plugin = plugin;
        this.module = module;
    }

    private double applyDragonItemEffect(@Nullable Entity defender, @Nullable ItemStack item, double origDamage) {
        if (!RSVItem.isRSVItem(item) || !RSVItem.getModuleNameFromItem(item).equals(this.module.getName())) {
            return origDamage;
        }
        return this.applyDragonItemEffect(defender, RSVItem.getNameFromItem(item), origDamage);
    }

    private double applyDragonItemEffect(@Nullable Entity defender, @Nullable String name, double origDamage) {
        if (this.module.getUserConfig() == null || defender == null || name == null || name.isEmpty() || name.startsWith("_") || name.endsWith("_")) {
            return origDamage;
        }
        String type = name.substring(0, name.lastIndexOf("_"));
        String weaponType = name.substring(name.lastIndexOf("_") + 1);
        if (weaponType.equals("longbow") || weaponType.equals("crossbow")) {
            origDamage *= this.config.getDouble("Items." + name + ".AttackDamageMultiplier");
        }
        switch (type) {
            case "dragonbone_flamed": {
                if (Utils.hasNbtTag(defender, "rsvmob") && !((String)Utils.getNbtTag(defender, "rsvmob", PersistentDataType.STRING)).equals("fire_dragon")) {
                    origDamage += this.config.getDouble("Items." + name + ".DragonBonusDamage");
                }
                if (BurnTask.hasTask(defender.getUniqueId())) break;
                int fireTicks = this.config.getInt("Items." + name + ".InfernoAbility.FireTicks");
                int tickPeriod = this.config.getInt("Items." + name + ".InfernoAbility.TickPeriod");
                new BurnTask(this.plugin, defender, fireTicks, tickPeriod).start();
                break;
            }
            case "dragonbone_iced": {
                if (Utils.hasNbtTag(defender, "rsvmob") && !((String)Utils.getNbtTag(defender, "rsvmob", PersistentDataType.STRING)).equals("ice_dragon")) {
                    origDamage += this.config.getDouble("Items." + name + ".DragonBonusDamage");
                }
                if (FreezeTask.hasTask(defender.getUniqueId())) break;
                new FreezeTask(this.plugin, this.module, name, defender).start();
                break;
            }
            case "dragonbone_lightning": {
                if (Utils.hasNbtTag(defender, "rsvmob") && !((String)Utils.getNbtTag(defender, "rsvmob", PersistentDataType.STRING)).equals("lightning_dragon")) {
                    origDamage += this.config.getDouble("Items." + name + ".DragonBonusDamage");
                }
                if (this.config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Enabled")) {
                    Location loc = defender.getLocation();
                    if (this.config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Cosmetic")) {
                        loc.getWorld().strikeLightningEffect(loc);
                    } else {
                        loc.getWorld().strikeLightning(loc);
                    }
                }
                if (!(defender instanceof Damageable)) break;
                Damageable damageable = (Damageable)defender;
                if (ElectrocuteTask.hasTask(defender.getUniqueId())) break;
                new ElectrocuteTask(this.plugin, this.module, name, damageable).start();
                break;
            }
            case "dragonsteel_fire": {
                if (BurnTask.hasTask(defender.getUniqueId())) break;
                int fireTicks = this.config.getInt("Items." + name + ".InfernoAbility.FireTicks");
                int tickPeriod = this.config.getInt("Items." + name + ".InfernoAbility.TickPeriod");
                new BurnTask(this.plugin, defender, fireTicks, tickPeriod).start();
                break;
            }
            case "dragonsteel_ice": {
                if (FreezeTask.hasTask(defender.getUniqueId())) break;
                new FreezeTask(this.plugin, this.module, name, defender).start();
                break;
            }
            case "dragonsteel_lightning": {
                if (this.config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Enabled")) {
                    Location loc = defender.getLocation();
                    if (this.config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Cosmetic")) {
                        loc.getWorld().strikeLightningEffect(loc);
                    } else {
                        loc.getWorld().strikeLightning(loc);
                    }
                }
                if (!(defender instanceof Damageable)) break;
                Damageable damageable = (Damageable)defender;
                if (ElectrocuteTask.hasTask(defender.getUniqueId())) break;
                new ElectrocuteTask(this.plugin, this.module, name, damageable).start();
                break;
            }
        }
        return origDamage;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntityMonitor(EntityDamageByEntityEvent event) {
        LivingEntity living;
        Entity defender = event.getEntity();
        Entity attacker = event.getDamager();
        if (!this.shouldEventBeRan(defender) || !this.shouldEventBeRan(attacker)) {
            return;
        }
        if (Utils.hasNbtTag(attacker, "rsvbow")) {
            String name = (String)Utils.getNbtTag(attacker, "rsvbow", PersistentDataType.STRING);
            IceFireModule.applyDragonItemEffect(defender, name, (RSVModule)this.module);
        } else if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker).getEquipment() != null) {
            ItemStack itemMainHand = living.getEquipment().getItemInMainHand();
            IceFireModule.applyDragonItemEffect(defender, itemMainHand, (RSVModule)this.module);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        LivingEntity living;
        Entity defender = event.getEntity();
        Entity attacker = event.getDamager();
        if (!this.shouldEventBeRan(defender) || !this.shouldEventBeRan(attacker)) {
            return;
        }
        double damage = event.getDamage();
        if (Utils.hasNbtTag(attacker, "rsvbow")) {
            String name = (String)Utils.getNbtTag(attacker, "rsvbow", PersistentDataType.STRING);
            damage = IceFireModule.applyDragonItemBonusDamage(defender, name, damage, (RSVModule)this.module);
        } else if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker).getEquipment() != null) {
            ItemStack itemMainHand = living.getEquipment().getItemInMainHand();
            damage = IceFireModule.applyDragonItemBonusDamage(defender, itemMainHand, damage, (RSVModule)this.module);
        }
        event.setDamage(damage);
    }

    @EventHandler
    public void onArmorAcquire(PlayerItemAcquireEvent event) {
        ItemStack item = event.getItem();
        if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).contains("tide_guardian_")) {
            return;
        }
        EquipmentSlot loc = event.getLocation();
        switch (loc) {
            case HEAD: 
            case CHEST: 
            case LEGS: 
            case FEET: {
                break;
            }
            default: {
                return;
            }
        }
        Player player = event.getPlayer();
        if (!TideGuardianTask.hasTask(player.getUniqueId())) {
            new TideGuardianTask(this.module, player, this.plugin).start();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        EnderDragon dragon;
        LivingEntity entity = event.getEntity();
        if (!this.shouldEventBeRan((Entity)entity)) {
            return;
        }
        if (entity instanceof Squid || entity instanceof Guardian || entity instanceof Dolphin) {
            if (this.config.getBoolean("SeaSerpent.Enabled.Enabled") && Utils.roll(this.config.getDouble("SeaSerpent.SpawnChance"))) {
                Utils.spawnSeaSerpent(entity.getLocation()).addEntityToWorld(entity.getWorld());
            }
            if (this.config.getBoolean("Siren.Enabled") && Utils.roll(this.config.getDouble("Siren.SpawnChance"))) {
                Utils.spawnSiren(entity.getLocation()).addEntityToWorld(entity.getWorld());
            }
        }
        if (entity instanceof EnderDragon && !DragonUtils.isDragon((Entity)(dragon = (EnderDragon)entity)) && this.config.getBoolean("Dragon.Enabled") && Utils.roll(this.config.getDouble("Dragon.SpawnChance"))) {
            double val = Math.random();
            double fireChance = this.config.getDouble("Dragon.FireDragon.Enabled.Chance");
            double iceChance = this.config.getDouble("Dragon.IceDragon.Enabled.Chance");
            if (val <= fireChance) {
                DragonUtils.convertToFireDragon(dragon);
            } else if (val <= fireChance + iceChance) {
                DragonUtils.convertToIceDragon(dragon);
            } else {
                DragonUtils.convertToLightningDragon(dragon);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLaunch(ProjectileLaunchEvent event) {
        EnderDragon dragon;
        ProjectileSource projectileSource;
        final Projectile proj = event.getEntity();
        if (!(this.shouldEventBeRan((Entity)proj) && proj instanceof DragonFireball && (projectileSource = proj.getShooter()) instanceof EnderDragon && DragonUtils.isDragon((Entity)(dragon = (EnderDragon)projectileSource)))) {
            return;
        }
        final DragonBreed breed = DragonUtils.getBreed(dragon);
        new BukkitRunnable(this){
            final /* synthetic */ IceFireEvents this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Location target = dragon.getEyeLocation().add(proj.getVelocity().normalize().multiply(100));
                switch (breed) {
                    case FIRE: {
                        if (Utils.roll(this.this$0.config.getDouble("Dragon.FireDragon.BreathAttack.Chance"))) {
                            DragonUtils.triggerBreathFireAttack(dragon, target);
                            break;
                        }
                        DragonUtils.triggerExplosionFireAttack(dragon, target);
                        break;
                    }
                    case ICE: {
                        if (Utils.roll(this.this$0.config.getDouble("Dragon.IceDragon.BreathAttack.Chance"))) {
                            DragonUtils.triggerBreathIceAttack(dragon, target);
                            break;
                        }
                        DragonUtils.triggerExplosionIceAttack(dragon, target);
                        break;
                    }
                    case LIGHTNING: {
                        if (Utils.roll(this.this$0.config.getDouble("Dragon.LightningDragon.BreathAttack.Chance"))) {
                            DragonUtils.triggerBreathLightningAttack(dragon, target);
                            break;
                        }
                        DragonUtils.triggerExplosionLightningAttack(dragon, target);
                        break;
                    }
                }
                proj.remove();
            }
        }.runTaskLater((Plugin)this.plugin, 2L);
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!this.shouldEventBeRan((Entity)entity) || !RSVMob.isMob((Entity)entity)) {
            return;
        }
        Location loc = entity.getLocation();
        World world = loc.getWorld();
        Collection<Object> loots = new ArrayList();
        switch (RSVMob.getMob((Entity)entity)) {
            case "fire_dragon": 
            case "ice_dragon": 
            case "lightning_dragon": {
                if (entity instanceof Dragon) break;
                loots = DragonUtils.generateLoot((EnderDragon)entity);
                break;
            }
            case "sea_serpent": {
                if (entity instanceof SeaSerpent) break;
                loots = SeaSerpentUtils.generateLoot((ElderGuardian)entity);
                break;
            }
            case "siren": {
                if (entity instanceof Siren) break;
                loots = SirenUtils.generateLoot((Guardian)entity);
                break;
            }
        }
        for (ItemStack loot : loots) {
            if (!Utils.isItemReal(loot)) continue;
            world.dropItemNaturally(loc, loot);
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (!this.shouldEventBeRan((Entity)event.getView().getPlayer())) {
            return;
        }
        if (recipe == null) {
            ItemStack[] matrix = event.getInventory().getMatrix();
            ArrayList<ItemStack> rsvItems = new ArrayList<ItemStack>();
            for (ItemStack item : matrix) {
                if (!RSVItem.isRSVItem(item)) continue;
                rsvItems.add(item);
            }
            if (rsvItems.size() == 2) {
                ItemStack dragonBlood;
                ItemStack dragonboneWeapon = switch (RSVItem.getNameFromItem((ItemStack)rsvItems.get(0))) {
                    case "dragon_blood_fire", "dragon_blood_ice", "dragon_blood_lightning" -> {
                        dragonBlood = (ItemStack)rsvItems.get(0);
                        yield (ItemStack)rsvItems.get(1);
                    }
                    default -> {
                        dragonBlood = (ItemStack)rsvItems.get(1);
                        yield (ItemStack)rsvItems.get(0);
                    }
                };
                String dragonBloodName = RSVItem.getNameFromItem(dragonBlood);
                String dragonboneWeaponName = RSVItem.getNameFromItem(dragonboneWeapon);
                switch (dragonBloodName) {
                    case "dragon_blood_fire": 
                    case "dragon_blood_ice": 
                    case "dragon_blood_lightning": {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (!dragonboneWeaponName.equals("dragonbone_sword")) {
                    return;
                }
                String specialAbility = switch (dragonBloodName) {
                    case "dragon_blood_fire" -> "flamed";
                    case "dragon_blood_ice" -> "iced";
                    case "dragon_blood_lightning" -> "lightning";
                    default -> null;
                };
                String weaponType = dragonboneWeaponName.substring(dragonboneWeaponName.indexOf("_") + 1);
                String upgradedWeaponName = "dragonbone_" + specialAbility + "_" + weaponType;
                NamespacedKey recipeKey = NamespacedKey.fromString((String)upgradedWeaponName, (Plugin)this.plugin);
                if (Bukkit.getRecipe((NamespacedKey)recipeKey) != null) {
                    RSVItem upgradedWeapon = RSVItem.getItem(upgradedWeaponName);
                    event.getInventory().setResult((ItemStack)upgradedWeapon);
                }
            }
        }
    }
}

