/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.integrations;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.TemperatureCalculateTask;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.CharacterValues;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class RSVExpansion
extends PlaceholderExpansion {
    private final RSVPlugin plugin;
    private final TempManager tempManager;
    private final ThirstManager thirstManager;
    private final CharacterValues charValues;

    public RSVExpansion(RSVPlugin plugin) {
        this.plugin = plugin;
        TanModule module = (TanModule)RSVModule.getModule("ToughAsNails");
        this.tempManager = module.getTempManager();
        this.thirstManager = module.getThirstManager();
        this.charValues = new CharacterValues();
    }

    @Nonnull
    public String getIdentifier() {
        return "rsv";
    }

    @Nonnull
    public String getAuthor() {
        return "Val_Mobile";
    }

    @Nonnull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @Nonnull String params) {
        String[] args = params.split("_");
        if (args.length == 0) {
            this.printErrorMessage(params);
            return "";
        }
        block5 : switch (args[0]) {
            case "tan": {
                if (!RSVModule.getModule("ToughAsNails").isEnabled((Entity)player)) {
                    this.printErrorMessage(params);
                    return "";
                }
                if (args.length < 3) {
                    this.printErrorMessage(params);
                    return "";
                }
                switch (args[1]) {
                    case "temp": {
                        if (!this.tempManager.isTempEnabled(player)) {
                            this.printErrorMessage(params);
                            return "";
                        }
                        double internalTemp = this.tempManager.getTemperature(player);
                        switch (args[2]) {
                            case "numeric": {
                                double temp;
                                int decimalplaces;
                                if (args.length < 5) {
                                    this.printErrorMessage(params);
                                    return "";
                                }
                                try {
                                    decimalplaces = Integer.parseInt(args[4]);
                                }
                                catch (NumberFormatException e) {
                                    return "";
                                }
                                FileConfiguration intConfig = this.plugin.getIntegrationsConfig();
                                double celsius = 2.0 * internalTemp / (25.0 * (internalTemp > 12.5 ? intConfig.getDouble("RealisticSeasons.HotMultiplier") : intConfig.getDouble("RealisticSeasons.ColdMultiplier"))) + intConfig.getDouble("RealisticSeasons.DefaultTemperature");
                                switch (args[3]) {
                                    case "internal": {
                                        temp = internalTemp;
                                        break;
                                    }
                                    case "celsius": {
                                        temp = celsius;
                                        break;
                                    }
                                    case "fahrenheit": {
                                        temp = celsius * 9.0 / 5.0 + 32.0;
                                        break;
                                    }
                                    case "kelvin": {
                                        temp = celsius + 273.15;
                                        break;
                                    }
                                    default: {
                                        this.printErrorMessage(params);
                                        return "";
                                    }
                                }
                                return String.valueOf(Utils.round(temp, decimalplaces));
                            }
                            case "bar": {
                                return this.charValues.getTemperature(player, (int)Math.round(internalTemp));
                            }
                            case "vignette": {
                                return this.charValues.getFireVignette(player, (int)Math.round(internalTemp));
                            }
                        }
                        break block5;
                    }
                    case "thirst": {
                        if (args.length < 4) {
                            this.printErrorMessage(params);
                            return "";
                        }
                        if (!this.thirstManager.isThirstEnabled(player)) {
                            this.printErrorMessage(params);
                            return "";
                        }
                        double thirst = this.thirstManager.getThirst(player);
                        switch (args[2]) {
                            case "numeric": {
                                int decimalplaces;
                                try {
                                    decimalplaces = Integer.parseInt(args[3]);
                                }
                                catch (NumberFormatException e) {
                                    this.printErrorMessage(params);
                                    return "";
                                }
                                return String.valueOf(Utils.round(thirst, decimalplaces));
                            }
                            case "bar": {
                                return this.charValues.getThirst(player, (int)Math.round(thirst), player.getRemainingAir() < 300 || player.isInWater(), this.thirstManager.hasParasites(player));
                            }
                            case "vignette": {
                                return this.charValues.getThirstVignette(player, (int)Math.round(thirst));
                            }
                        }
                        break block5;
                    }
                    case "hud": {
                        if (!(player != null && player.isOnline() && TemperatureCalculateTask.hasTask(player.getUniqueId()) && TemperatureCalculateTask.hasTask(player.getUniqueId()))) {
                            this.printErrorMessage(params);
                            return "";
                        }
                        this.charValues.getTemperatureThirstActionbar(player, (int)Math.round(this.tempManager.getTemperature(player)), Math.round(this.thirstManager.getThirst(player)), player.getRemainingAir() < 300 || player.isInWater(), this.thirstManager.hasParasites(player));
                        break block5;
                    }
                }
                break;
            }
        }
        this.printErrorMessage(params);
        return "";
    }

    private void printErrorMessage(@Nonnull String params) {
        ConfigurationSection section = this.plugin.getIntegrationsConfig().getConfigurationSection("PlaceholderAPI.Error");
        if (section.getBoolean("Enabled")) {
            this.plugin.getLogger().info(Utils.translateMsg(section.getString("Message"), null, Map.of("PLACEHOLDER", "%" + params + "%")));
        }
    }
}

